/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.feed;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.ExceptionParameters;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.definition.DataContainer;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.feed.DataFeed;
import com.businessobjects.visualization.feed.IFeedMediator;
import com.businessobjects.visualization.feed.definition.DataContainerDef;
import com.businessobjects.visualization.feed.definition.DataContainerType;
import com.businessobjects.visualization.feed.definition.FeedDef;
import com.businessobjects.visualization.feed.generated.XMLDataContainerRef;
import com.businessobjects.visualization.feed.generated.XMLFeed;
import java.util.ArrayList;
import java.util.Iterator;

public class Feed
implements IXMLDelegator {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$feed$Feed == null ? (class$com$businessobjects$visualization$feed$Feed = Feed.class$("com.businessobjects.visualization.feed.Feed")) : class$com$businessobjects$visualization$feed$Feed));
    private final transient FeedDef feedDef_;
    private final transient IFeedMediator internalMediator_;
    private transient Feed parent_;
    private transient DataContainerType dcTypeName_;
    private ArrayList dataContainerList_;
    private ArrayList nestedFeedList_;
    private String id_;
    static /* synthetic */ Class class$com$businessobjects$visualization$feed$Feed;

    public Feed(IFeedMediator mediator, FeedDef feedDef) {
        this(null, mediator, feedDef);
    }

    Feed(Feed parent, IFeedMediator mediator, FeedDef feedDef) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("New Feed instance from feedDef:" + feedDef));
        }
        this.parent_ = parent;
        this.internalMediator_ = mediator;
        this.feedDef_ = feedDef;
        this.dataContainerList_ = null;
        this.nestedFeedList_ = null;
        this.id_ = feedDef.getId() + DataFeed.getNextDefId();
    }

    private ArrayList getDataContainerList() {
        if (this.dataContainerList_ == null) {
            this.dataContainerList_ = new ArrayList();
        }
        return this.dataContainerList_;
    }

    private ArrayList getNestedFeedList() {
        if (this.nestedFeedList_ == null) {
            this.nestedFeedList_ = new ArrayList();
        }
        return this.nestedFeedList_;
    }

    void init(DataDescriptor dd, XMLFeed xmlFeed, SerializationHelper sh) {
        if (!xmlFeed.m_a_DefId.equals(this.feedDef_.getId())) {
            throw new VisualizationInternalException("Mismatch in FeedDef:" + this.feedDef_.getId() + " vs. " + xmlFeed.m_a_DefId);
        }
        this.id_ = xmlFeed.m_a_Id;
        Iterator iter = xmlFeed.m_list_DataContainerRefId.iterator();
        while (iter.hasNext()) {
            XMLDataContainerRef aContainerRef = (XMLDataContainerRef)iter.next();
            if (aContainerRef.m_a_Id.id.equals(DimensionLabels.MEASURENAMES_DIMENSION.getUid())) {
                this.addDataContainer(DimensionLabels.MEASURENAMES_DIMENSION);
                continue;
            }
            this.addDataContainer(dd.getDataContainerByUid(aContainerRef.m_a_Id.id));
        }
        iter = xmlFeed.m_list_Feed.iterator();
        while (iter.hasNext()) {
            XMLFeed nestedFeed = (XMLFeed)iter.next();
            Feed newFeed = new Feed(this, this.internalMediator_, this.feedDef_.findById(nestedFeed.m_a_DefId));
            newFeed.init(dd, nestedFeed, sh);
            this.getNestedFeedList().add(newFeed);
        }
    }

    public Object getXMLDelegate() {
        Iterator iter;
        XMLFeed xmlFeed = new XMLFeed();
        xmlFeed.m_a_Id = this.id_;
        xmlFeed.m_a_DefId = this.feedDef_.getId();
        if (this.dataContainerList_ != null) {
            iter = this.getDataContainerList().iterator();
            while (iter.hasNext()) {
                DataContainer dc = (DataContainer)iter.next();
                XMLDataContainerRef aRef = new XMLDataContainerRef();
                aRef.m_a_Id.id = dc.getUid();
                xmlFeed.m_list_DataContainerRefId.add(aRef);
            }
        }
        if (this.nestedFeedList_ != null) {
            iter = this.getNestedFeedList().iterator();
            while (iter.hasNext()) {
                Feed feed = (Feed)iter.next();
                xmlFeed.m_list_Feed.add((XMLFeed)feed.getXMLDelegate());
            }
        }
        return xmlFeed;
    }

    public DataContainer[] getDataContainers() {
        if (this.dataContainerList_ == null) {
            return new DataContainer[0];
        }
        return this.dataContainerList_.toArray(new DataContainer[0]);
    }

    private void recurseAndSearchNestedDataContainers(ArrayList fullList, String feedDefId) {
        if (feedDefId == null || this.feedDef_.getId().equals(feedDefId)) {
            if (this.dataContainerList_ != null) {
                fullList.addAll(this.dataContainerList_);
            }
            if (feedDefId != null) {
                return;
            }
        }
        if (this.nestedFeedList_ != null) {
            Iterator iter = this.nestedFeedList_.iterator();
            while (iter.hasNext()) {
                Feed feed = (Feed)iter.next();
                feed.recurseAndSearchNestedDataContainers(fullList, feedDefId);
            }
        }
    }

    void recurseAndSearchNestedFeeds(ArrayList fullList, String feedDefId, DataContainerType dcTypeName) {
        if (feedDefId == null || this.feedDef_.getId().equals(feedDefId)) {
            if (dcTypeName == null) {
                fullList.add(this);
            } else if (dcTypeName != null && dcTypeName.equals(this.dcTypeName_)) {
                fullList.add(this);
            }
            if (feedDefId != null) {
                return;
            }
        }
        if (this.nestedFeedList_ != null) {
            Iterator iter = this.nestedFeedList_.iterator();
            while (iter.hasNext()) {
                Feed feed = (Feed)iter.next();
                feed.recurseAndSearchNestedFeeds(fullList, feedDefId, dcTypeName);
            }
        }
    }

    public DataContainer[] getAllNestedDataContainers() {
        ArrayList fullList = new ArrayList();
        this.recurseAndSearchNestedDataContainers(fullList, null);
        return fullList.toArray(new DataContainer[0]);
    }

    public DataContainer[] searchDataContainers(String feedDefId) {
        ArrayList fullList = new ArrayList();
        this.recurseAndSearchNestedDataContainers(fullList, feedDefId);
        return fullList.toArray(new DataContainer[0]);
    }

    public Feed[] getAllNestedFeeds() {
        ArrayList fullList = new ArrayList();
        this.recurseAndSearchNestedFeeds(fullList, null, null);
        return fullList.toArray(new Feed[0]);
    }

    public Feed[] searchFeedsByDefId(String feedDefId) {
        return this.searchFeedsByDefId(feedDefId, null);
    }

    public Feed[] searchFeedsByDefId(String feedDefId, DataContainerType dcTypeName) {
        ArrayList fullList = new ArrayList();
        this.recurseAndSearchNestedFeeds(fullList, feedDefId, dcTypeName);
        return fullList.toArray(new Feed[0]);
    }

    public Feed searchFeedByUid(String feedUid) {
        if (this.id_.equals(feedUid)) {
            return this;
        }
        Feed foundFeed = null;
        if (this.nestedFeedList_ != null) {
            Iterator iter = this.nestedFeedList_.iterator();
            while (iter.hasNext() && foundFeed == null) {
                foundFeed = ((Feed)iter.next()).searchFeedByUid(feedUid);
            }
        }
        return foundFeed;
    }

    public Feed[] getNestedFeeds() {
        if (this.nestedFeedList_ == null) {
            return new Feed[0];
        }
        return this.nestedFeedList_.toArray(new Feed[0]);
    }

    private int getMeasureValuesCount() {
        if (this.dataContainerList_ == null) {
            return 0;
        }
        int count = 0;
        Iterator iter = this.getDataContainerList().iterator();
        while (iter.hasNext()) {
            if (!((DataContainer)iter.next() instanceof MeasureValues)) continue;
            ++count;
        }
        return count;
    }

    public boolean contains(DataContainer dc) {
        if (this.dataContainerList_ == null) {
            return false;
        }
        return this.dataContainerList_.contains(dc);
    }

    public boolean contains(Feed feed) {
        if (this.nestedFeedList_ == null) {
            return false;
        }
        return Feed.contains(feed, this.getNestedFeedList());
    }

    static boolean contains(Feed feed, ArrayList feedList) {
        if (feedList == null) {
            return false;
        }
        return feedList.contains(feed);
    }

    private ExceptionParameters check(DataContainer dc) {
        if (!this.feedDef_.hasDataContainerDefs()) {
            return new ExceptionParameters("VIZ_00141_ERR_FEED_DOES_NOT_TAKE_DATACONTAINERS", new Object[]{this.feedDef_}, null);
        }
        if (this.contains(dc)) {
            return new ExceptionParameters("VIZ_00146_ERR_WAS_ALREADY_FEEDED", new Object[]{dc, this.feedDef_}, null);
        }
        DataContainerDef[] dcType = this.feedDef_.getDataContainerDefList();
        for (int i = 0; i < dcType.length; ++i) {
            if (dcType[i].getType() == DataContainerType.DIMENSIONSHIERARCHY && dc instanceof DimensionLabels && !dc.equals(DimensionLabels.MEASURENAMES_DIMENSION)) {
                return null;
            }
            if (dcType[i].getType() == DataContainerType.MEASUREVALUES && dc instanceof MeasureValues) {
                if (this.getMeasureValuesCount() >= 1) {
                    return new ExceptionParameters("VIZ_00145_ERR_FEED_LIMIT_REACHED", new Object[]{new Integer(dcType[i].getMax()), this.feedDef_}, null);
                }
                return null;
            }
            if (dcType[i].getType() != DataContainerType.MEASURENAMESDIMENSION || !dc.equals(DimensionLabels.MEASURENAMES_DIMENSION)) continue;
            if (this.getMeasureValuesCount() >= 1) {
                return new ExceptionParameters("VIZ_00145_ERR_FEED_LIMIT_REACHED", new Object[]{new Integer(dcType[i].getMax()), this.feedDef_}, null);
            }
            return null;
        }
        return new ExceptionParameters("VIZ_00143_ERR_WRONG_TYPE_ATTACHED_TO_FEED", new Object[]{dc, this.feedDef_}, null);
    }

    public boolean accepts(DataContainer dc) {
        return this.check(dc) == null;
    }

    private static DataContainerType getTypeNameFromDc(DataContainer dc) {
        if (dc.equals(DimensionLabels.MEASURENAMES_DIMENSION)) {
            return DataContainerType.MEASURENAMESDIMENSION;
        }
        if (dc instanceof DimensionLabels) {
            return DataContainerType.DIMENSIONSHIERARCHY;
        }
        if (dc instanceof MeasureValues) {
            return DataContainerType.MEASUREVALUES;
        }
        throw new VisualizationInternalException("Unknown DataContainer:" + dc);
    }

    private static int getFeedCount(FeedDef def, ArrayList feedList) {
        return Feed.getFeedCount(def, feedList, null);
    }

    private static int getFeedCount(FeedDef def, ArrayList feedList, DataContainerType dcTypeName) {
        if (feedList == null) {
            return 0;
        }
        int count = 0;
        Iterator iter = feedList.iterator();
        while (iter.hasNext()) {
            Feed aFeed = (Feed)iter.next();
            if (!aFeed.getFeedDef().getId().equals(def.getId())) continue;
            if (dcTypeName == null) {
                ++count;
                continue;
            }
            DataContainer[] dcList = aFeed.getDataContainers();
            for (int i = 0; i < dcList.length; ++i) {
                if (dcList[i].equals(DimensionLabels.MEASURENAMES_DIMENSION) && dcTypeName.equals(DataContainerType.MEASURENAMESDIMENSION)) {
                    ++count;
                    continue;
                }
                if (dcList[i] instanceof DimensionLabels && dcTypeName.equals(DataContainerType.DIMENSIONSHIERARCHY)) {
                    ++count;
                    continue;
                }
                if (!(dcList[i] instanceof MeasureValues) || !dcTypeName.equals(DataContainerType.MEASUREVALUES)) continue;
                ++count;
            }
        }
        return count;
    }

    static ExceptionParameters check(Feed feed, ArrayList feedList, FeedDef[] feedDefList) {
        if (feedDefList == null || feedDefList.length == 0) {
            return new ExceptionParameters("VIZ_00142_ERR_FEED_DOES_NOT_TAKE_NESTED_FEEDS", new Object[]{feed}, null);
        }
        if (Feed.contains(feed, feedList)) {
            return new ExceptionParameters("VIZ_00146_ERR_WAS_ALREADY_FEEDED", new Object[]{feed, feed.getFeedDef()}, null);
        }
        for (int j = 0; j < feedDefList.length; ++j) {
            ExceptionParameters e;
            if (feedDefList[j].getId().equals(feed.getFeedDef().getId())) {
                if (Feed.getFeedCount(feedDefList[j], feedList) >= feedDefList[j].getMax()) {
                    return new ExceptionParameters("VIZ_00145_ERR_FEED_LIMIT_REACHED", new Object[]{new Integer(feedDefList[j].getMax()), feed.getFeedDef()}, null);
                }
                if (feed.getDataContainers().length > 0) {
                    DataContainer[] dcList = feed.getDataContainers();
                    for (int i = 0; i < dcList.length; ++i) {
                        DataContainerType dcTypeName = Feed.getTypeNameFromDc(dcList[i]);
                        if (Feed.getFeedCount(feedDefList[j], feedList, dcTypeName) < feedDefList[j].getMax(dcTypeName)) continue;
                        return new ExceptionParameters("VIZ_00145_ERR_FEED_LIMIT_REACHED", new Object[]{new Integer(feedDefList[j].getMax(dcTypeName)), feed.getFeedDef().getId() + dcTypeName.toString()}, null);
                    }
                }
                return null;
            }
            if (!feedDefList[j].hasNestedFeedDefs() || (e = Feed.check(feed, feedList, feedDefList[j].getNestedFeedDefList())) != null) continue;
            return null;
        }
        return new ExceptionParameters("VIZ_00144_ERR_WRONG_FEED_ATTACHED_TO_FEED", new Object[]{feed, feed.getFeedDef()}, null);
    }

    public boolean accepts(Feed feed) {
        return Feed.check(feed, this.getNestedFeedList(), this.feedDef_.getNestedFeedDefList()) == null;
    }

    static boolean accepts(Feed feed, ArrayList feedList, FeedDef[] feedDefList) {
        return Feed.check(feed, feedList, feedDefList) == null;
    }

    public void addDataContainer(DataContainer dc) {
        ExceptionParameters exc = this.check(dc);
        if (exc == null) {
            if (this.dcTypeName_ == null) {
                this.dcTypeName_ = Feed.getTypeNameFromDc(dc);
            }
            this.getDataContainerList().add(dc);
            return;
        }
        throw new VisualizationRuntimeException(exc);
    }

    public void addNestedFeed(Feed feed) {
        ExceptionParameters exc = Feed.check(feed, this.getNestedFeedList(), this.feedDef_.getNestedFeedDefList());
        if (exc == null) {
            feed.parent_ = this;
            this.getNestedFeedList().add(feed);
            return;
        }
        throw new VisualizationRuntimeException(exc);
    }

    public boolean removeDataContainer(DataContainer dc) {
        if (this.dataContainerList_ == null) {
            return false;
        }
        return this.dataContainerList_.remove(dc);
    }

    public boolean removeNestedFeed(Feed feed) {
        if (this.nestedFeedList_ == null) {
            return false;
        }
        feed.parent_ = null;
        return this.nestedFeedList_.remove(feed);
    }

    public FeedDef getFeedDef() {
        return this.feedDef_;
    }

    public String getId() {
        return this.id_;
    }

    public Feed getParent() {
        return this.parent_;
    }

    public boolean isNested() {
        return this.parent_ != null;
    }

    public void getFullNestedFeedList(ArrayList fullList, boolean onlyDataContainerHolders) {
        if (this.nestedFeedList_ != null) {
            Iterator iter = this.nestedFeedList_.iterator();
            while (iter.hasNext()) {
                Feed aFeed = (Feed)iter.next();
                aFeed.getFullNestedFeedList(fullList, onlyDataContainerHolders);
                if (onlyDataContainerHolders && !aFeed.getFeedDef().hasDataContainerDefs()) continue;
                fullList.add(aFeed);
            }
        }
    }

    public DataContainerType getDataContainerTypeName() {
        return this.dcTypeName_;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append("Feed[");
        buffer.append("id = ").append(this.id_);
        buffer.append("  DefId = ").append(this.feedDef_.getId());
        buffer.append(", dataContainerList = ").append(this.dataContainerList_);
        buffer.append(", nestedFeedList = ").append(this.nestedFeedList_);
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

