/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.definition;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.DatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.data.SubDatasetAdapter;
import com.businessobjects.visualization.dataexchange.definition.AnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.FilterInfo;
import com.businessobjects.visualization.dataexchange.definition.InvalidDataOperationException;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.definition.MeasureValuesGroup;
import com.businessobjects.visualization.dataexchange.definition.SortInfo;
import com.businessobjects.visualization.dataexchange.definition.SubDatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLAnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLDatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLFilterInfo;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLMeasureValuesGroup;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLSortInfo;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLSubDatasetDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class DatasetDescriptor
implements IXMLDelegator {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$dataexchange$definition$DatasetDescriptor == null ? (class$com$businessobjects$visualization$dataexchange$definition$DatasetDescriptor = DatasetDescriptor.class$("com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor")) : class$com$businessobjects$visualization$dataexchange$definition$DatasetDescriptor));
    public static final int MAX_CARDINALITY = 3;
    public static final int CURRENT_VERSION = 0;
    private DataDescriptor dataDescriptor_;
    private ArrayList axes_ = new ArrayList();
    private ArrayList valueGroups_ = new ArrayList();
    private ArrayList sortInfoList_;
    private ArrayList filterInfoList_;
    private ArrayList subDatasets_ = new ArrayList();
    private static FilterInfo[] emptyList_ = new FilterInfo[0];
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$definition$DatasetDescriptor;

    public DatasetDescriptor() {
        this.sortInfoList_ = new ArrayList();
        this.filterInfoList_ = new ArrayList();
    }

    public DatasetDescriptor(XMLDatasetDescriptor xmlDataset, SerializationHelper sh) {
        this();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Deserializing DatasetDescriptor (runtime version:" + sh.getCurrentVersion() + ") from stream (serialized version:" + sh.getSerializedVersion() + ")"));
        }
        Iterator iter = null;
        iter = xmlDataset.m_list_subDatasetDescriptor.iterator();
        while (iter.hasNext()) {
            SubDatasetDescriptor sds = new SubDatasetDescriptor((XMLSubDatasetDescriptor)iter.next(), sh);
            sds.setDependentDataset(this);
            this.subDatasets_.add(sds);
        }
        iter = xmlDataset.m_list_analysisAxis.iterator();
        while (iter.hasNext()) {
            AnalysisAxis ax = new AnalysisAxis((XMLAnalysisAxis)iter.next(), sh);
            ax.setDataset(this);
            this.axes_.add(ax);
        }
        iter = xmlDataset.m_list_measureValuesGroup.iterator();
        while (iter.hasNext()) {
            MeasureValuesGroup mvg = new MeasureValuesGroup((XMLMeasureValuesGroup)iter.next(), sh);
            mvg.setDataset(this);
            this.valueGroups_.add(mvg);
        }
        iter = xmlDataset.m_list_sortInfo.iterator();
        while (iter.hasNext()) {
            SortInfo si = new SortInfo((XMLSortInfo)iter.next(), sh);
            this.sortInfoList_.add(si);
        }
        iter = xmlDataset.m_list_filterInfo.iterator();
        while (iter.hasNext()) {
            FilterInfo fi = new FilterInfo((XMLFilterInfo)iter.next(), sh);
            this.filterInfoList_.add(fi);
        }
    }

    public void clear() {
        Iterator iter = null;
        iter = this.getSubDatasetIterator();
        while (iter.hasNext()) {
            ((SubDatasetDescriptor)iter.next()).clear();
        }
        iter = this.getAxisIterator();
        while (iter.hasNext()) {
            ((AnalysisAxis)iter.next()).clear();
        }
        iter = this.getValueGroupIterator();
        while (iter.hasNext()) {
            ((MeasureValuesGroup)iter.next()).clear();
        }
        iter = this.getSortInfoListIterator();
        while (iter.hasNext()) {
            ((SortInfo)iter.next()).clear();
        }
        iter = this.getFilterInfoListIterator();
        while (iter.hasNext()) {
            ((FilterInfo)iter.next()).clear();
        }
        this.axes_.clear();
        this.valueGroups_.clear();
        this.sortInfoList_.clear();
        this.filterInfoList_.clear();
        this.subDatasets_.clear();
        this.dataDescriptor_ = null;
    }

    public Object getXMLDelegate() {
        XMLDatasetDescriptor xmlDataset = new XMLDatasetDescriptor();
        Iterator iter = null;
        iter = this.getSubDatasetIterator();
        while (iter.hasNext()) {
            xmlDataset.m_list_subDatasetDescriptor.add((XMLSubDatasetDescriptor)((SubDatasetDescriptor)iter.next()).getXMLDelegate());
        }
        iter = this.getAxisIterator();
        while (iter.hasNext()) {
            xmlDataset.m_list_analysisAxis.add((XMLAnalysisAxis)((AnalysisAxis)iter.next()).getXMLDelegate());
        }
        iter = this.getValueGroupIterator();
        while (iter.hasNext()) {
            xmlDataset.m_list_measureValuesGroup.add((XMLMeasureValuesGroup)((MeasureValuesGroup)iter.next()).getXMLDelegate());
        }
        iter = this.getSortInfoListIterator();
        while (iter.hasNext()) {
            xmlDataset.m_list_sortInfo.add((XMLSortInfo)((SortInfo)iter.next()).getXMLDelegate());
        }
        iter = this.getFilterInfoListIterator();
        while (iter.hasNext()) {
            xmlDataset.m_list_filterInfo.add((XMLFilterInfo)((FilterInfo)iter.next()).getXMLDelegate());
        }
        return xmlDataset;
    }

    public void addAxis(AnalysisAxis anAxis) {
        if (this.getCardinality() >= 3) {
            Object[] args = new Object[]{Integer.toString(3)};
            throw new InvalidDataOperationException("VIZ_00004_ERR_INVALID_DATA_OPERATION", args);
        }
        this.axes_.add(anAxis);
        anAxis.setDataset(this);
    }

    public void removeAxis(AnalysisAxis anAxis) {
        this.axes_.remove(anAxis);
    }

    public void addValueGroup(MeasureValuesGroup aValueGroup) {
        this.valueGroups_.add(aValueGroup);
        aValueGroup.setDataset(this);
    }

    public void removeValueGroup(MeasureValuesGroup aValueGroup) {
        this.valueGroups_.remove(aValueGroup);
    }

    public void addSubDataset(SubDatasetDescriptor subDataset) {
        this.subDatasets_.add(subDataset);
        subDataset.setDependentDataset(this);
    }

    public void removeSubDataset(SubDatasetDescriptor subDataset) {
        this.subDatasets_.remove(subDataset);
    }

    public void addSortInfo(SortInfo sortInfo) {
        this.sortInfoList_.add(sortInfo);
    }

    public void removeSortInfo(SortInfo sortInfo) {
        this.sortInfoList_.remove(sortInfo);
    }

    public void addFilterInfo(FilterInfo filterInfo) {
        this.filterInfoList_.add(filterInfo);
    }

    public void removeFilterInfo(FilterInfo filterInfo) {
        this.filterInfoList_.remove(filterInfo);
    }

    public void removeAllFilterInfo() {
        this.filterInfoList_.clear();
    }

    public AnalysisAxis[] getAxisList() {
        return this.axes_.toArray(new AnalysisAxis[0]);
    }

    public MeasureValuesGroup[] getValueGroupList() {
        return this.valueGroups_.toArray(new MeasureValuesGroup[0]);
    }

    public SortInfo[] getSortInfoList() {
        return this.sortInfoList_.toArray(new SortInfo[0]);
    }

    public boolean hasFilterInfo() {
        return this.filterInfoList_.size() > 0;
    }

    public FilterInfo[] getFilterInfoList() {
        if (this.filterInfoList_.size() == 0) {
            return emptyList_;
        }
        return this.filterInfoList_.toArray(new FilterInfo[this.filterInfoList_.size()]);
    }

    public SubDatasetDescriptor[] getSubDatasetList() {
        return this.subDatasets_.toArray(new SubDatasetDescriptor[this.subDatasets_.size()]);
    }

    public int getCardinality() {
        return this.axes_.size();
    }

    public Iterator getAxisIterator() {
        return this.axes_.iterator();
    }

    public Iterator getSubDatasetIterator() {
        return this.subDatasets_.iterator();
    }

    public Iterator getValueGroupIterator() {
        return this.valueGroups_.iterator();
    }

    public Iterator getSortInfoListIterator() {
        return this.sortInfoList_.iterator();
    }

    public Iterator getFilterInfoListIterator() {
        return this.filterInfoList_.iterator();
    }

    public DatasetAdapter getDatasetAdapter() {
        DatasetAdapter dsAdapter = new DatasetAdapter();
        AnalysisAxis[] axeList = this.getAxisList();
        AnalysisAxisAdapter[] axisAdapters = new AnalysisAxisAdapter[axeList.length];
        for (int i = 0; i < axisAdapters.length; ++i) {
            axisAdapters[i] = axeList[i].getAxisAdapter();
        }
        dsAdapter.setAxisList(axisAdapters);
        MeasureValuesGroup[] valueGroupList = this.getValueGroupList();
        MeasureValuesGroupAdapter[] valueGroupAdapters = new MeasureValuesGroupAdapter[valueGroupList.length];
        for (int i = 0; i < valueGroupAdapters.length; ++i) {
            valueGroupAdapters[i] = valueGroupList[i].getValueGroupAdapter();
        }
        dsAdapter.setValueGroups(valueGroupAdapters);
        SubDatasetDescriptor[] subDatasetList = this.getSubDatasetList();
        DatasetAdapter[] subDatasetAdapters = new SubDatasetAdapter[subDatasetList.length];
        for (int i = 0; i < subDatasetAdapters.length; ++i) {
            subDatasetAdapters[i] = subDatasetList[i].getSubDatasetAdapter(dsAdapter);
        }
        dsAdapter.setSubDatasets(subDatasetAdapters);
        return dsAdapter;
    }

    static void copyInstance(DatasetDescriptor aDataset, DatasetDescriptor newDataset) {
        Iterator iter = null;
        iter = aDataset.getAxisIterator();
        while (iter.hasNext()) {
            newDataset.addAxis(AnalysisAxis.newInstance((AnalysisAxis)iter.next()));
        }
        iter = aDataset.getValueGroupIterator();
        while (iter.hasNext()) {
            newDataset.addValueGroup(MeasureValuesGroup.newInstance((MeasureValuesGroup)iter.next()));
        }
        iter = aDataset.getSubDatasetIterator();
        while (iter.hasNext()) {
            newDataset.addSubDataset(SubDatasetDescriptor.newInstance((SubDatasetDescriptor)iter.next()));
        }
        iter = aDataset.getSortInfoListIterator();
        while (iter.hasNext()) {
            newDataset.addSortInfo((SortInfo)iter.next());
        }
        iter = aDataset.getFilterInfoListIterator();
        while (iter.hasNext()) {
            newDataset.addFilterInfo((FilterInfo)iter.next());
        }
    }

    public static DatasetDescriptor newInstance(DatasetDescriptor aDataset) {
        DatasetDescriptor newDataset = new DatasetDescriptor();
        DatasetDescriptor.copyInstance(aDataset, newDataset);
        return newDataset;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof DatasetDescriptor)) {
            return false;
        }
        DatasetDescriptor that = (DatasetDescriptor)oThat;
        if (!Arrays.equals(this.getAxisList(), that.getAxisList())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"AxisList not equal");
            }
            return false;
        }
        if (!Arrays.equals(this.getValueGroupList(), that.getValueGroupList())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"ValueGroup not equal");
            }
            return false;
        }
        if (!Arrays.equals(this.getSubDatasetList(), that.getSubDatasetList())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"SubDatasetDescriptor not equal");
            }
            return false;
        }
        if (!Arrays.equals(this.getSortInfoList(), that.getSortInfoList())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"SortInfoList not equal");
            }
            return false;
        }
        if (!Arrays.equals(this.getFilterInfoList(), that.getFilterInfoList())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"FilterInfoList not equal");
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeHelper.hash(result, this.getAxisList());
        result = HashCodeHelper.hash(result, this.getValueGroupList());
        result = HashCodeHelper.hash(result, this.getSubDatasetList());
        result = HashCodeHelper.hash(result, this.getSortInfoList());
        result = HashCodeHelper.hash(result, this.getFilterInfoList());
        return result;
    }

    public ArrayList getAllDataContainers() {
        ArrayList al = new ArrayList();
        Iterator iter = this.getAxisIterator();
        while (iter.hasNext()) {
            al.addAll(((AnalysisAxis)iter.next()).getAllDataContainers());
        }
        iter = this.getValueGroupIterator();
        while (iter.hasNext()) {
            al.addAll(((MeasureValuesGroup)iter.next()).getAllDataContainers());
        }
        return al;
    }

    public int getAxisIndex(DimensionLabels dl) {
        Iterator iter = this.axes_.iterator();
        int i = 0;
        while (iter.hasNext()) {
            int j = ((AnalysisAxis)iter.next()).getDimensionLabelsIndex(dl);
            if (j != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getMeasureGroupIndex(MeasureValues mv) {
        Iterator iter = this.valueGroups_.iterator();
        int i = 0;
        while (iter.hasNext()) {
            int j = ((MeasureValuesGroup)iter.next()).getMeasureValuesIndex(mv);
            if (j != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean subsetOf(DatasetDescriptor containerDescriptor) {
        if (this.valueGroups_.size() > containerDescriptor.valueGroups_.size()) {
            return false;
        }
        Iterator vGroupIter = this.valueGroups_.iterator();
        Iterator containerGroupIter = containerDescriptor.valueGroups_.iterator();
        while (vGroupIter.hasNext()) {
            MeasureValuesGroup mvg = (MeasureValuesGroup)vGroupIter.next();
            MeasureValuesGroup containerMvg = (MeasureValuesGroup)containerGroupIter.next();
            if (containerMvg.getAllDataContainers().containsAll(mvg.getAllDataContainers())) continue;
            return false;
        }
        if (this.axes_.size() != containerDescriptor.axes_.size()) {
            return false;
        }
        Iterator vAxisIter = this.axes_.iterator();
        Iterator containerAxisIter = containerDescriptor.axes_.iterator();
        while (vAxisIter.hasNext()) {
            AnalysisAxis aa = (AnalysisAxis)vAxisIter.next();
            AnalysisAxis containerAa = (AnalysisAxis)containerAxisIter.next();
            if (containerAa.getAllDataContainers().containsAll(aa.getAllDataContainers())) continue;
            return false;
        }
        return true;
    }

    void setDataDescriptor(DataDescriptor dd) {
        this.dataDescriptor_ = dd;
    }

    DataDescriptor getDataDescriptor() {
        return this.dataDescriptor_;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DatasetDescriptor[");
        buffer.append("axes_ = ").append(this.axes_);
        buffer.append(", valueGroups_ = ").append(this.valueGroups_);
        buffer.append(", sortInfoList_ = ").append(this.sortInfoList_);
        buffer.append(", filterInfoList_ = ").append(this.filterInfoList_);
        buffer.append(", subDatasets_ = ").append(this.subDatasets_);
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

