/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.impl;

import com.businessobjects.visualization.common.exceptions.SerializationException;
import com.businessobjects.visualization.common.internal.Base64Coder;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.common.DataStructure;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.InvalidDataTypeException;
import com.businessobjects.visualization.dataexchange.data.generated.XMLData;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataType;
import com.businessobjects.visualization.dataexchange.data.impl.Helper;
import java.io.IOException;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONException;

public class StringLabelData
implements Data {
    private String[] values_;
    private Properties[] properties_;

    public StringLabelData(String[] values) {
        this.setValues(values, DataType.STRING, 1);
    }

    public StringLabelData(String[] values, Properties[] properties) throws InvalidDataTypeException {
        this.setValues(values, DataType.STRING, 1);
        this.setProperties(properties);
    }

    public StringLabelData(XMLData xmlValues, SerializationHelper sh) {
        try {
            if (xmlValues.m_encodedvalues.charAt(0) != '[') {
                this.values_ = (String[])SerializationHelper.bytesToObject(Base64Coder.decode(xmlValues.m_encodedvalues));
                return;
            }
            JSONArray startArray = new JSONArray(xmlValues.m_encodedvalues);
            this.values_ = new String[startArray.length()];
            for (int i = 0; i < this.values_.length; ++i) {
                this.values_[i] = startArray.getString(i);
            }
        }
        catch (IOException e) {
            throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", e);
        }
        catch (JSONException e) {
            throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", e);
        }
    }

    public Object getValues() {
        return this.values_;
    }

    public void setValues(Object values, DataType aType, int iCardinality) throws InvalidDataTypeException {
        if (!(values instanceof String[]) || aType != DataType.STRING || iCardinality != 1) {
            throw new InvalidDataTypeException("VIZ_00026_ERR_STRING___EXPECTED__");
        }
        this.values_ = (String[])values;
    }

    public DataType getType() {
        return DataType.STRING;
    }

    public int getValuesCount(int iCardinality) {
        if (iCardinality > 3 || iCardinality < 1) {
            throw new InvalidDataTypeException("VIZ_00033_ERR_CARDINALIYT_1_TO_3", new Object[]{String.valueOf(iCardinality)});
        }
        if (iCardinality == 1) {
            return this.values_.length;
        }
        return 0;
    }

    public int getCardinality() {
        return 1;
    }

    public Object getXMLDelegate() {
        XMLData data = new XMLData();
        data.m_a_cardinality = 1;
        data.m_dataType = new XMLDataType(0);
        data.m_dataStructure = Helper.toXML(DataStructure.SIMPLE);
        try {
            data.m_encodedvalues = this.toJSONString();
        }
        catch (JSONException e) {
            throw new SerializationException("VIZ_00003_ERR_SERIALIZATION_ERROR", e);
        }
        return data;
    }

    public DataStructure getStructure() {
        return DataStructure.SIMPLE;
    }

    public boolean supportProperties() {
        return true;
    }

    public void setProperties(Object properties) {
        if (properties != null && !(properties instanceof Properties[])) {
            throw new InvalidDataTypeException("VIZ_00020_ERR_PROPERTIES___EXPECTE");
        }
        this.properties_ = (Properties[])properties;
    }

    public Object getProperties() {
        return this.properties_;
    }

    public String toJSONString() throws JSONException {
        return new JSONArray(this.values_).toString();
    }
}

