/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data;

import com.businessobjects.visualization.common.exceptions.SerializationException;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.common.DataStructure;
import com.businessobjects.visualization.dataexchange.data.ClientInfoAdapter;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.DataContainerAdapter;
import com.businessobjects.visualization.dataexchange.data.InvalidDataTypeException;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.graph.impl.DimDataBuilder;
import com.businessobjects.visualization.dataexchange.data.impl.DoubleLabelData;
import com.businessobjects.visualization.dataexchange.data.impl.StringLabelData;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNodeArray;

public class DimensionLabelsAdapter
extends DataContainerAdapter {
    private transient DimDataBuilder dimDataBuilder_;

    public DimensionLabelsAdapter(ClientInfoAdapter cia, String uid, String defaultTitle) {
        this.clientInfoAdapter_ = cia;
        this.serialId_ = uid;
        this.title_ = defaultTitle;
    }

    public DimensionLabelsAdapter(XMLDimensionLabelsAdapter adapter, SerializationHelper sh) {
        super.fromXMLDelegate(adapter, sh);
        if (adapter.m_values != null) {
            if (adapter.m_values.m_dataStructure != null && adapter.m_values.m_dataStructure.value() == 1) {
                this.data_ = new TreeNodeArray(adapter.m_values, sh);
            } else {
                switch (adapter.m_values.m_dataType.value()) {
                    case 0: {
                        this.data_ = new StringLabelData(adapter.m_values, sh);
                        break;
                    }
                    case 1: {
                        this.data_ = new DoubleLabelData(adapter.m_values, sh);
                        break;
                    }
                    default: {
                        throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", "Unknown values datatype:" + adapter.m_values.m_dataType);
                    }
                }
            }
        }
    }

    public void setData(Data data) {
        if (data != null && data.getCardinality() != 1 && data.getStructure() == DataStructure.SIMPLE) {
            throw new InvalidDataTypeException("VIZ_00082_ERR_IMPROPER_CARDINALITY", new Object[]{new Integer(data.getCardinality())});
        }
        this.data_ = data;
    }

    public Data getData() {
        if (this.data_ == null && this.dimDataBuilder_ != null) {
            this.data_ = this.dimDataBuilder_.getData(this);
        }
        return this.data_;
    }

    void setTreeToDataBuilder(DimDataBuilder dataBuilder) {
        this.dimDataBuilder_ = dataBuilder;
    }

    public Object getXMLDelegate() {
        XMLDimensionLabelsAdapter xmlDimAdapter = new XMLDimensionLabelsAdapter();
        super.toXMLDelegate(xmlDimAdapter);
        return xmlDimAdapter;
    }
}

