/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.consumer;

public final class MinMaxHelper {
    public static final GetMin GET_MIN = new GetMin();
    public static final GetMax GET_MAX = new GetMax();
    public static final GetMinNotZero GET_MIN_NOT_ZERO = new GetMinNotZero();

    private MinMaxHelper() {
    }

    public static double init(MinMax f) {
        return -f.get(-1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static double computeMinMax(double initValue, double[] values, MinMax f) {
        double res = initValue;
        for (int j = 0; j < values.length; ++j) {
            if (values[j] == 1.7E308 || Double.isNaN(values[j])) continue;
            res = f.get(res, values[j]);
        }
        return res;
    }

    public static double computeMinMax(double[] values, MinMax f) {
        return MinMaxHelper.computeMinMax(MinMaxHelper.init(f), values, f);
    }

    public static double getMin(double[] values) {
        return MinMaxHelper.computeMinMax(values, GET_MIN);
    }

    public static double getMinNotZero(double[] values) {
        return MinMaxHelper.computeMinMax(values, GET_MIN_NOT_ZERO);
    }

    public static double getMax(double[] values) {
        return MinMaxHelper.computeMinMax(values, GET_MAX);
    }

    public static final class GetMinNotZero
    implements MinMax {
        private GetMinNotZero() {
        }

        public double get(double a, double b) {
            if (a <= 0.0 || a == Double.MAX_VALUE) {
                return b;
            }
            if (b <= 0.0 || b == Double.MAX_VALUE) {
                return a;
            }
            return Math.min(a, b);
        }
    }

    public static final class GetMax
    implements MinMax {
        private GetMax() {
        }

        public double get(double a, double b) {
            return Math.max(a, b);
        }
    }

    public static final class GetMin
    implements MinMax {
        private GetMin() {
        }

        public double get(double a, double b) {
            return Math.min(a, b);
        }
    }

    public static interface MinMax {
        public double get(double var1, double var3);
    }
}

