/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.consumer;

import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.dataexchange.DataHolder;
import com.businessobjects.visualization.dataexchange.LegendGroup;
import com.businessobjects.visualization.dataexchange.LegendItem;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IMember;
import com.businessobjects.visualization.dataexchange.data.DataAdapter;
import com.businessobjects.visualization.dataexchange.data.DataContainerAdapter;
import com.businessobjects.visualization.dataexchange.data.DataRange;
import com.businessobjects.visualization.dataexchange.data.MeasureNamesDimensionAdapter;
import com.businessobjects.visualization.dataexchange.definition.DataContainer;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.feed.Feed;
import com.businessobjects.visualization.window.MeasureRange;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class DataHandler {
    public static final String DIM_SEPARATOR = " / ";
    public static final String PREFIX_SEPARATOR = " - ";
    private DataContainer dataContainer_;
    private DataContainerAdapter dataContainerAdapter_;
    private DataHolder dataHolder_;

    public abstract String getTitle();

    protected void init(DataHolder dh, DataContainer dc) {
        this.dataHolder_ = dh;
        this.dataContainer_ = dc;
        this.dataContainerAdapter_ = DataHandler.getDataContainerAdapter(this.dataHolder_, dc);
    }

    DataHolder getDataHolder() {
        return this.dataHolder_;
    }

    public DataContainer getDataContainer() {
        return this.dataContainer_;
    }

    DataContainerAdapter getDataContainerAdapter() {
        return this.dataContainerAdapter_;
    }

    public static IDimensionLabelsIterator getDimensionLabelsCallBack(GraphicInstance gi, Feed aFeed) {
        return DataHandler.getDimensionLabelsCallBack(gi, aFeed, -1);
    }

    static DataRange getWindowRange(GraphicInstance gi, int aaIndex) {
        if (gi.getWindowManager().checkDataWindow() != null) {
            if (gi.getWindowManager().getDataPushMode() == 0) {
                if (aaIndex == -1) {
                    MeasureRange mr = gi.getWindowManager().checkDataWindow().getMeasureRange();
                    if (mr.equals(MeasureRange.FULL_RANGE)) {
                        return DataRange.FULL_RANGE;
                    }
                    return new DataRange(mr.getLower(), mr.getUpper());
                }
                return gi.getWindowManager().checkDataWindow().getDataRangeByAxis()[aaIndex];
            }
            return null;
        }
        return null;
    }

    private static IDimensionLabelsIterator getDimensionLabelsCallBack(GraphicInstance gi, Feed aFeed, int maxDepth) {
        DimensionLabels dl = (DimensionLabels)aFeed.getDataContainers()[0];
        int aaIndex = gi.getDataDescriptor().getDatasetDescriptor().getAxisIndex(dl);
        return DataHandler.getDimensionLabelsCallBack(new DataHolder(gi.getDataDescriptor(), gi.getDataAdapter()), aFeed, maxDepth, -1, DataHandler.getWindowRange(gi, aaIndex));
    }

    static IDimensionLabelsIterator getDimensionLabelsCallBack(DataHolder dataHolder, Feed aFeed, int maxDepth, DataRange dataRange) {
        return DataHandler.getDimensionLabelsCallBack(dataHolder, aFeed, maxDepth, -1, dataRange);
    }

    static IDimensionLabelsIterator getDimensionLabelsCallBack(DataHolder dataHolder, Feed aFeed, int maxDepth, int maxLevel, DataRange dataRange) {
        DimensionLabels dl = (DimensionLabels)aFeed.getDataContainers()[0];
        if (dl.equals(DimensionLabels.MEASURENAMES_DIMENSION)) {
            MeasureNamesDimensionAdapter mnda = (MeasureNamesDimensionAdapter)DataHandler.getDataContainerAdapter(dataHolder.getDataDescriptor(), dataHolder.getDataAdapter(), dl);
            return mnda.getLabelIterator(dataRange);
        }
        int aaIndex = dataHolder.getDataDescriptor().getDatasetDescriptor().getAxisIndex(dl);
        int dlIndex = dataHolder.getDataDescriptor().getDatasetDescriptor().getAxisList()[aaIndex].getDimensionLabelsIndex(dl);
        return dataHolder.getDataAdapter().getDataset().getLabelsIterator(aaIndex, dlIndex, dataRange, maxDepth, maxLevel);
    }

    public static DataContainerAdapter getDataContainerAdapter(DataDescriptor dd, DataAdapter da, DataContainer dc) {
        if (dd == null || da == null || dc == null) {
            throw new NullPointerException("All passed parameters should be non null");
        }
        DataContainerAdapter dca = null;
        if (dc instanceof DimensionLabels) {
            if (dc.equals(DimensionLabels.MEASURENAMES_DIMENSION)) {
                dca = new MeasureNamesDimensionAdapter(new DataHolder(dd, da));
            } else {
                int axisIndex = dd.getDatasetDescriptor().getAxisIndex((DimensionLabels)dc);
                if (axisIndex == -1) {
                    throw new VisualizationInternalException("Could not find DataContainer:" + dc + " in passed Descriptor");
                }
                int dlIndex = dd.getDatasetDescriptor().getAxisList()[axisIndex].getDimensionLabelsIndex((DimensionLabels)dc);
                dca = da.getDataset().getAxisList()[axisIndex].getDimensionLabelsList()[dlIndex];
            }
        } else if (dc instanceof MeasureValues) {
            int mvgIndex = dd.getDatasetDescriptor().getMeasureGroupIndex((MeasureValues)dc);
            if (mvgIndex == -1) {
                throw new VisualizationInternalException("Could not find DataContainer:" + dc + " in passed Descriptor");
            }
            int mvIndex = dd.getDatasetDescriptor().getValueGroupList()[mvgIndex].getMeasureValuesIndex((MeasureValues)dc);
            dca = da.getDataset().getValueGroupList()[mvgIndex].getMeasureValuesList()[mvIndex];
        } else {
            throw new VisualizationInternalException("Not supported DataContainerType of dc:" + dc);
        }
        return dca;
    }

    public static DataContainerAdapter getDataContainerAdapter(GraphicInstance gi, DataContainer dc) {
        return DataHandler.getDataContainerAdapter(new DataHolder(gi.getDataDescriptor(), gi.getDataAdapter()), dc);
    }

    public static DataContainerAdapter getDataContainerAdapter(DataHolder dh, DataContainer dc) {
        return DataHandler.getDataContainerAdapter(dh.getDataDescriptor(), dh.getDataAdapter(), dc);
    }

    public static String[] getLabels(IDimensionLabelsIterator labelsIterator, String prefix) {
        return DataHandler.getLabels(labelsIterator, prefix, -1);
    }

    public static String[] getLabels(IDimensionLabelsIterator labelsIterator, String prefix, int maxDepth) {
        if (labelsIterator == null) {
            return null;
        }
        labelsIterator.reset();
        ArrayList tempLabels = new ArrayList();
        Recurser recurser = new Recurser();
        recurser.recurse(labelsIterator, 0, "", tempLabels, prefix, maxDepth);
        return tempLabels.toArray(new String[0]);
    }

    public static void getLegendInfos(IDimensionLabelsIterator labelsIterator, ArrayList legendItems, HashMap legendGroups, String prefix) {
        DataHandler.getLegendInfos(labelsIterator, legendItems, legendGroups, prefix, -1);
    }

    public static void getLegendInfos(IDimensionLabelsIterator labelsIterator, ArrayList legendItems, HashMap legendGroups, String prefix, int maxDepth) {
        if (labelsIterator != null) {
            labelsIterator.reset();
            Recurser recurser = new Recurser();
            recurser.legendRecurse(labelsIterator, new ArrayList(), prefix, maxDepth);
            legendItems.addAll(recurser.getLegendItems());
            legendGroups.putAll(recurser.getLegendGroups());
        }
    }

    public int getLegendGroupId() {
        return Recurser.legendGroupId;
    }

    public void setLegendGroupId(int newValue) {
        Recurser.legendGroupId = newValue;
    }

    private static final class Recurser {
        private ArrayList legendItems_ = new ArrayList();
        private HashMap legendGroups_ = new HashMap();
        private static int legendGroupId;

        private Recurser() {
        }

        public void recurse(IDimensionLabelsIterator iter, int dimIndex, String parentLabel, ArrayList tempLabels, String prefix, int depth) {
            if (iter == null) {
                return;
            }
            while (iter.hasNext()) {
                IMember colMember = iter.next();
                IDimensionLabelsIterator nextDimIterator = colMember.getNextStackedDimensionIterator();
                if (nextDimIterator == null) {
                    StringBuffer valBuffer = new StringBuffer();
                    if (prefix.length() != 0) {
                        valBuffer.append(prefix).append(DataHandler.PREFIX_SEPARATOR);
                    }
                    if (depth == 0) {
                        valBuffer.append(parentLabel);
                    } else if (parentLabel.length() != 0) {
                        if (colMember.getValue() != null) {
                            valBuffer.append(parentLabel).append(DataHandler.DIM_SEPARATOR).append(colMember.getValue());
                        } else {
                            valBuffer.append(parentLabel);
                        }
                    } else {
                        valBuffer.append(colMember.getValue());
                    }
                    tempLabels.add(valBuffer.toString());
                    continue;
                }
                if (depth != 0) {
                    String newParentLabel = parentLabel;
                    String colMemberLabel = (String)colMember.getValue();
                    if (parentLabel.length() != 0) {
                        if (colMemberLabel.length() != 0) {
                            newParentLabel = newParentLabel + DataHandler.DIM_SEPARATOR + colMemberLabel;
                        }
                    } else {
                        newParentLabel = colMemberLabel;
                    }
                    this.recurse(nextDimIterator, colMember.getDimensionIndex(), newParentLabel, tempLabels, prefix, depth - 1);
                    continue;
                }
                this.recurse(nextDimIterator, colMember.getDimensionIndex(), parentLabel, tempLabels, prefix, 0);
            }
        }

        public void legendRecurse(IDimensionLabelsIterator iter, ArrayList parentPath, String prefix, int depth) {
            if (iter == null) {
                return;
            }
            int add = -1;
            while (iter.hasNext()) {
                IMember colMember = iter.next();
                IDimensionLabelsIterator nextDimIterator = colMember.getNextStackedDimensionIterator();
                if (nextDimIterator == null) {
                    if (depth == 0) {
                        this.legendItems_.add(new LegendItem((String)parentPath.get(parentPath.size() - 1), legendGroupId));
                        add = 0;
                        continue;
                    }
                    this.legendItems_.add(new LegendItem((String)colMember.getValue(), legendGroupId));
                    add = 1;
                    continue;
                }
                if (depth == 0) continue;
                ArrayList<Object> newParentPath = new ArrayList<Object>(parentPath);
                newParentPath.add(colMember.getValue());
                this.legendRecurse(nextDimIterator, newParentPath, prefix, depth - 1);
            }
            if (add == 0 || add == 1) {
                if (add == 0) {
                    parentPath.remove(parentPath.size() - 1);
                }
                if (prefix.length() != 0) {
                    parentPath.add(prefix);
                }
                this.legendGroups_.put(new Integer(legendGroupId), new LegendGroup(parentPath, legendGroupId));
                ++legendGroupId;
            }
        }

        public ArrayList getLegendItems() {
            return this.legendItems_;
        }

        public HashMap getLegendGroups() {
            return this.legendGroups_;
        }
    }
}

