/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.common;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.internal.HashCodeHelper;

public class DimensionType {
    private static final int I_STANDARD = 0;
    private static final int I_GEOGRAPHIC = 1;
    private static final int I_TIME = 2;
    private static final String S_STANDARD = "Standard";
    private static final String S_GEOGRAPHIC = "Geographic";
    private static final String S_TIME = "Time";
    public static final DimensionType STANDARD = new DimensionType(0);
    public static final DimensionType GEOGRAPHIC = new DimensionType(1);
    public static final DimensionType TIME = new DimensionType(2);
    private final int value_;

    private DimensionType(int value) {
        this.value_ = value;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof DimensionType)) {
            return false;
        }
        return this.value_ == ((DimensionType)oThat).value_;
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeHelper.hash(result, this.value_);
        return result;
    }

    public static DimensionType fromString(String sDimType) {
        if (sDimType.equals(S_STANDARD)) {
            return STANDARD;
        }
        if (sDimType.equals(S_GEOGRAPHIC)) {
            return GEOGRAPHIC;
        }
        if (sDimType.equals(S_TIME)) {
            return TIME;
        }
        throw new VisualizationInternalException("Invalid DimensionType provided: " + sDimType);
    }

    public String toString() {
        if (this.value_ == 2) {
            return S_TIME;
        }
        if (this.value_ == 1) {
            return S_GEOGRAPHIC;
        }
        return S_STANDARD;
    }
}

