/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.GraphicDescription;
import com.businessobjects.visualization.GraphicInstanceMediator;
import com.businessobjects.visualization.LocalizedEngine;
import com.businessobjects.visualization.ProviderDescription;
import com.businessobjects.visualization.common.events.DataDescriptorEvent;
import com.businessobjects.visualization.common.events.GraphicEvent;
import com.businessobjects.visualization.common.events.IGraphicInstanceListener;
import com.businessobjects.visualization.common.exceptions.SerializationException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.common.internal.VersionHelper;
import com.businessobjects.visualization.common.internal.XmlReaderVersion;
import com.businessobjects.visualization.dataexchange.DataHolder;
import com.businessobjects.visualization.dataexchange.data.DataAdapter;
import com.businessobjects.visualization.dataexchange.data.InvalidDataTypeException;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLWindowManager;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLDataDescriptor;
import com.businessobjects.visualization.feed.Feeder;
import com.businessobjects.visualization.feed.definition.DataFeedDefinition;
import com.businessobjects.visualization.feed.definition.FeedDef;
import com.businessobjects.visualization.feed.generated.XMLDataFeed;
import com.businessobjects.visualization.formatting.IFormatSettings;
import com.businessobjects.visualization.graphic.Graphic;
import com.businessobjects.visualization.graphic.GraphicDef;
import com.businessobjects.visualization.graphic.IGraphic;
import com.businessobjects.visualization.graphic.IRegion;
import com.businessobjects.visualization.graphic.PropertyDef;
import com.businessobjects.visualization.graphic.PublicGraphicDef;
import com.businessobjects.visualization.graphic.SettingsManager;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.resource.GraphicResource;
import com.businessobjects.visualization.graphic.resource.GraphicResourceType;
import com.businessobjects.visualization.graphic.resource.GraphicResources;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLGraphic;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLSettings;
import com.businessobjects.visualization.graphicengine.GraphicEngine;
import com.businessobjects.visualization.internal.events.EventListeners;
import com.businessobjects.visualization.legend.GraphicLegendElement;
import com.businessobjects.visualization.legend.IGraphicLegend;
import com.businessobjects.visualization.rendering.RenderEngine;
import com.businessobjects.visualization.rendering.RenderFormat;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.util.xml.XmlWriter;
import com.businessobjects.visualization.window.DataWindowManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class GraphicInstance {
    private LocalizedEngine locEngine_;
    private Graphic graphic_;
    private Feeder feeder_;
    private DataDescriptor dataDescriptor_;
    private DataAdapter dataAdapter_;
    private GraphicInstanceMediator mediator_;
    private DataWindowManager windowManager_;
    private IFormatSettings formatSettings_;
    private boolean isSettingsDependanciesInitialized_;
    private IGraphicLegend graphicLegend_;
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$GraphicInstance == null ? (class$com$businessobjects$visualization$GraphicInstance = GraphicInstance.class$("com.businessobjects.visualization.GraphicInstance")) : class$com$businessobjects$visualization$GraphicInstance));
    public static final int METADA_FLAG = 0;
    public static final int DATA_FLAG = 1;
    public static final int DICT_FLAG = 2;
    public static final int SETTINGS_FLAG = 4;
    public static final int FEED_FLAG = 8;
    public static final int WINDOW_FLAG = 16;
    public static final int ALL_FLAG = 255;
    public static final int DEFAULT_FLAG = 254;
    private final EventListeners listeners_ = new EventListeners();
    static /* synthetic */ Class class$com$businessobjects$visualization$GraphicInstance;

    GraphicInstance(LocalizedEngine le) {
        this.locEngine_ = le;
        this.mediator_ = new GraphicInstanceMediator(this);
    }

    void init(InputStream is) {
        try {
            GraphicInstanceSerializer.read(is, this);
            if (this.locEngine_.getDefaultFont() != null) {
                this.setDefaultValue(this.locEngine_.getDefaultFont());
            }
            ((Graphic)this.getGraphic()).removeAllListener();
            this.isSettingsDependanciesInitialized_ = false;
        }
        catch (Exception e) {
            throw new VisualizationRuntimeException("VIZ_00057_ERR_EXCEPTION_OCCURED_WH", e);
        }
    }

    public void saveState(OutputStream os, int flag) throws SerializationException {
        try {
            GraphicInstanceSerializer.write(os, this, flag);
        }
        catch (Exception e) {
            throw new VisualizationRuntimeException("VIZ_00057_ERR_EXCEPTION_OCCURED_WH", e);
        }
    }

    public void loadState(InputStream is) throws SerializationException {
        try {
            GraphicInstanceSerializer.read(is, this);
        }
        catch (Exception e) {
            throw new VisualizationRuntimeException("VIZ_00057_ERR_EXCEPTION_OCCURED_WH", e);
        }
    }

    public void serialize(OutputStream os, boolean bWithData) throws SerializationException {
        this.saveState(os, bWithData ? 255 : 254);
    }

    public void serialize(OutputStream os) throws SerializationException {
        this.saveState(os, 254);
    }

    public void addListener(IGraphicInstanceListener listener) {
        this.listeners_.addListener(listener);
    }

    public void removeListener(IGraphicInstanceListener listener) {
        this.listeners_.removeListener(listener);
    }

    void fireGraphicChanged() {
        Object[] ls = this.listeners_.getListeners();
        if (ls.length > 0) {
            GraphicEvent event = new GraphicEvent(this);
            for (int i = 0; i < ls.length; ++i) {
                IGraphicInstanceListener listener = (IGraphicInstanceListener)ls[i];
                listener.graphicChanged(event);
            }
        }
    }

    void fireDataDescriptorChanged() {
        Object[] ls = this.listeners_.getListeners();
        if (ls.length > 0) {
            DataDescriptorEvent event = new DataDescriptorEvent(this);
            for (int i = 0; i < ls.length; ++i) {
                IGraphicInstanceListener listener = (IGraphicInstanceListener)ls[i];
                listener.dataDescriptorChanged(event);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void turnTo(String graphicId) {
        PublicGraphicDef pg;
        String oldGraphicId = this.getPublicGraphicId();
        IRegion rootToRestore = null;
        if (!graphicId.equals(oldGraphicId) && null != this.getGraphic()) {
            rootToRestore = this.getGraphic().getRegion("root");
        }
        if ((pg = this.locEngine_.getPublicGraphic(graphicId)) != null) {
            this.graphic_ = new Graphic(pg, this.mediator_);
            if (this.locEngine_.getDefaultFont() != null) {
                this.setDefaultValue(this.locEngine_.getDefaultFont());
            }
        } else {
            GraphicDef gd = this.locEngine_.getGraphicDef(graphicId);
            if (gd == null || gd.getDefaultPublicGraphicId() == null) throw new VisualizationRuntimeException("VIZ_00134_ERR_INVALID_GRAPHICID_TY", new Object[]{graphicId});
            pg = this.locEngine_.getPublicGraphic(gd.getDefaultPublicGraphicId());
            if (pg == null) throw new VisualizationRuntimeException("VIZ_00133_ERR_INVALID_DEFAULT_PUBL", new Object[]{gd.getDefaultPublicGraphicId()});
            this.graphic_ = new Graphic(pg, this.mediator_);
            if (this.locEngine_.getDefaultFont() != null) {
                this.setDefaultValue(this.locEngine_.getDefaultFont());
            }
        }
        this.updateFeeder(true);
        if (null != rootToRestore) {
            IRegion regionToMove = this.getGraphic().getRegion("root");
            SettingsManager.keepSettingsRegion(rootToRestore, regionToMove, this.locEngine_.getPublicGraphic(oldGraphicId), pg);
        }
        this.isSettingsDependanciesInitialized_ = false;
    }

    void updateDataDescriptorFromFeeder() {
        if (this.feeder_ == null) {
            throw new VisualizationRuntimeException("VIZ_00058_ERR_CANNOT_UPDATED_DATA_");
        }
        this.dataDescriptor_ = this.feeder_.getCurrentDataDescriptor();
    }

    public void setDataDescriptor(DataDescriptor datas) {
        if (datas == null) {
            throw new InvalidDataTypeException("VIZ_00154_ERR_NULL_DATA");
        }
        this.dataDescriptor_ = datas;
        this.feeder_ = null;
        this.dataAdapter_ = null;
        this.updateFeeder(false);
    }

    public DataDescriptor getDataDescriptor() {
        if (this.getFeeder() != null) {
            this.dataDescriptor_ = this.feeder_.getCurrentDataDescriptor();
        }
        return this.dataDescriptor_;
    }

    public void setDataAdapter(DataAdapter dataAdapter) {
        this.dataAdapter_ = dataAdapter;
        if (this.windowManager_ != null) {
            this.windowManager_.setLimits(dataAdapter);
        }
    }

    public DataAdapter getDataAdapter() {
        if (this.dataAdapter_ == null && this.dataDescriptor_ != null) {
            this.dataAdapter_ = this.dataDescriptor_.getDataAdapter();
        }
        return this.dataAdapter_;
    }

    public GraphicDescription[] getBestGraphics(int iCount) {
        return this.getBestGraphics(iCount, "", "");
    }

    public GraphicDescription[] getBestGraphics(int iCount, String businessDomainId, String analysisTypeId) {
        if (this.dataDescriptor_ == null) {
            throw new VisualizationRuntimeException("VIZ_00059_ERR_AT_LEAST_DATADESCRIP");
        }
        return this.mediator_.getBestGraphics(iCount, businessDomainId, analysisTypeId);
    }

    public String getGraphicId() {
        if (this.getGraphic() == null) {
            return null;
        }
        return this.getGraphic().getId();
    }

    public String getPublicGraphicId() {
        if (this.getGraphic() == null) {
            return null;
        }
        return this.getGraphic().getGraphicDescription().getId();
    }

    public String getGraphicDefId() {
        return this.getPublicGraphicDef().getGraphicDef().getId();
    }

    public boolean checkFeedsConsistency() {
        return this.feeder_ != null && this.dataDescriptor_ != null && this.feeder_.hasMinimumFeeds() && !this.feeder_.hasUnfeededDataContainers();
    }

    public RenderEngine makeGraph(int outputType) {
        return this.makeGraph(outputType, 0);
    }

    public void importNativeTemplate(InputStream is) {
        GraphicEngine graphicEngine = GraphicEngine.getEngine(this.getGraphicDef().getProviderDescription().getLoaderClass());
        graphicEngine.importNativeTemplate(this, is);
    }

    public void exportNativeTemplate(OutputStream os) {
        GraphicEngine graphicEngine = GraphicEngine.getEngine(this.getGraphicDef().getProviderDescription().getLoaderClass());
        graphicEngine.exportNativeTemplate(this, os);
    }

    public RenderEngine makeGraph(int outputType, int retrieveMap) {
        return this.makeGraph(outputType, retrieveMap, false);
    }

    public RenderEngine makeGraph(int outputType, int retrieveMap, boolean bIgnoreUnfeededContainers) {
        DataHolder.checkConsistency(this.dataDescriptor_, this.dataAdapter_, true);
        if (!this.checkFeedsConsistency()) {
            if (this.feeder_ == null) {
                throw new VisualizationRuntimeException("VIZ_00061_ERR_FEEDER_IS_NULL__GRAP");
            }
            if (!this.feeder_.hasMinimumFeeds()) {
                throw new VisualizationRuntimeException("VIZ_00062_ERR_NOT_ENOUGH_FEEDS_TO_");
            }
            if (this.feeder_.hasUnfeededDataContainers() && !bIgnoreUnfeededContainers) {
                throw new VisualizationRuntimeException("VIZ_00063_ERR_NOT_ALL_DATACONTAINE");
            }
        }
        try {
            GraphicEngine graphicEngine = GraphicEngine.getEngine(this.getPublicGraphicDef().getGraphicDef().getProviderDescription().getLoaderClass());
            if (!this.isSettingsDependanciesInitialized_) {
                graphicEngine.initSettingsDependency(this);
                this.isSettingsDependanciesInitialized_ = true;
            }
            RenderEngine re = graphicEngine.process(this, outputType, retrieveMap);
            return re;
        }
        catch (Throwable objThrowable) {
            throw GraphicEngine.createException(this.getPublicGraphicDef().getGraphicDef().getProviderDescription().getId(), objThrowable);
        }
    }

    public IGraphicLegend getLegend(int outputType) {
        if (this.graphicLegend_ == null) {
            try {
                GraphicEngine graphicEngine = GraphicEngine.getEngine(this.getPublicGraphicDef().getGraphicDef().getProviderDescription().getLoaderClass());
                IGraphicLegend graphicLegend = graphicEngine.getLegend(this, outputType);
                this.setLegend(graphicLegend);
                if (this.graphicLegend_ == null) {
                    return null;
                }
            }
            catch (Throwable objThrowable) {
                throw GraphicEngine.createException(this.getPublicGraphicDef().getGraphicDef().getProviderDescription().getId(), objThrowable);
            }
        }
        GraphicLegendElement[] elements = this.graphicLegend_.getLegendElements();
        for (int i = 0; i < elements.length; ++i) {
            byte[] img = elements[i].generate(outputType);
            elements[i].setImage(img);
        }
        return this.graphicLegend_;
    }

    public void setLegend(IGraphicLegend graphicLegend) {
        this.graphicLegend_ = graphicLegend;
    }

    public RenderFormat[] getAvailableFormat() {
        return this.graphic_.getAvailableFormat();
    }

    private void updateFeeder(boolean bPreserveData) {
        if (this.graphic_ == null) {
            return;
        }
        if (this.graphic_.getPublicGraphicDef() == null) {
            return;
        }
        if (this.graphic_.getPublicGraphicDef().getId() == null) {
            return;
        }
        DataFeedDefinition dfs = this.locEngine_.getDataFeedSpecification(this.graphic_.getGraphicDefId());
        if (this.feeder_ == null) {
            this.feeder_ = new Feeder(dfs, this.mediator_);
        } else {
            this.feeder_.changeDefinition(dfs, bPreserveData);
        }
        if (this.dataDescriptor_ != null) {
            this.feeder_.setDataDescriptor(this.dataDescriptor_);
        }
    }

    public Feeder getFeeder() {
        if (this.feeder_ != null) {
            return this.feeder_;
        }
        this.updateFeeder(false);
        return this.feeder_;
    }

    public GraphicDef getGraphicDef() {
        return this.graphic_.getGraphicDescription().getGraphicDef();
    }

    public PublicGraphicDef getPublicGraphicDef() {
        return this.graphic_.getPublicGraphicDef();
    }

    public IGraphic getGraphic() {
        return this.graphic_;
    }

    public VisuObject getPropertyValue(String regId, String propId) {
        return this.graphic_.getPropertyValue(regId, propId);
    }

    public void setPropertyValue(String regId, String propId, VisuObject value) {
        this.graphic_.setPropertyValue(regId, propId, value);
    }

    public IRegion getRegion(String regId) {
        return this.graphic_.getRegion(regId);
    }

    public VisuBool getRegionValue(String regId) {
        return this.graphic_.getRegionValue(regId);
    }

    public void setRegionValue(String regId, VisuBool value) {
        this.graphic_.setRegionValue(regId, value);
    }

    public void setDefaultValue(VisuObject vo) {
        this.graphic_.setDefaultValue(vo);
    }

    public VisuObject getDefaultValue(VisuObjectType vot) {
        return this.graphic_.getDefaultValue(vot);
    }

    private XMLGraphic getGraphicXmlDelegate() {
        XMLGraphic xg = null;
        Graphic myGraphic = this.graphic_;
        xg = (XMLGraphic)myGraphic.getXMLDelegate();
        return xg;
    }

    public int getMaxRestrictionCount(String feedId) {
        return this.graphic_.getGraphicDescription().getPublicGraphic().getMaxRestrictionCount(feedId);
    }

    public int getMinRestrictionCount(String feedId) {
        return this.graphic_.getGraphicDescription().getPublicGraphic().getMinRestrictionCount(feedId);
    }

    public boolean isFeedOptional(String feedDefId) {
        FeedDef feedDef = this.getFeeder().getDataFeedDefinition().findById(feedDefId);
        return this.mediator_.getMinOccurence(feedDef) == 0 && this.mediator_.getMaxOccurence(feedDef) > 0;
    }

    public boolean isFeedVisible(String feedDefId) {
        FeedDef feedDef = this.getFeeder().getDataFeedDefinition().findById(feedDefId);
        return this.mediator_.getMaxOccurence(feedDef) > 0;
    }

    public DataWindowManager getWindowManager() {
        if (this.windowManager_ == null) {
            this.windowManager_ = new DataWindowManager(this);
        }
        return this.windowManager_;
    }

    public LocalizedEngine getLocalizedEngine() {
        return this.locEngine_;
    }

    ArrayList getValidPublicGraphic(GraphicDef gdef, PropertyDef pdef, VisuObject vo) {
        ArrayList list = new ArrayList();
        return list;
    }

    GraphicInstanceMediator getMediator() {
        return this.mediator_;
    }

    public GraphicResource getResource(GraphicResourceType type, String id) {
        GraphicResource result = this.locEngine_.getResource(type, id);
        return result;
    }

    public GraphicResources getResources() {
        return this.locEngine_.getResources();
    }

    public void setFormatSettings(IFormatSettings formatSettings) {
        this.formatSettings_ = formatSettings;
    }

    public IFormatSettings getFormatSettings() {
        if (this.formatSettings_ == null) {
            return this.locEngine_.getFormatFactory().getDefaultSettings(this.getLocalizedEngine().getLocale());
        }
        return this.formatSettings_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class GraphicInstanceSerializer {
        static final String MAIN_ELEMENT = "GraphicInstance";
        static final String METADATA_ELEMENT = "DataDescriptor";
        static final String DATA_ELEMENT = "DataAdapter";
        static final String DICT_ELEMENT = "SessionDictionary";
        static final String SETTINGS_ELEMENT = "Settings";
        static final String FEED_ELEMENT = "DataFeed";
        static final String WINDOW_ELEMENT = "WindowManager";
        static final String FEEDID_ATTR = "FeedId";
        static final String VERSION_ATTR = "version";
        static final String PROVIDERID_ATTR = "Provider";

        private GraphicInstanceSerializer() {
        }

        protected static void write(OutputStream os, GraphicInstance gi, int flag) throws XmlException {
            XmlWriter xw = new XmlWriter(os, Charset.forName("UTF-8"));
            xw.startDocument();
            xw.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xw.startElement(MAIN_ELEMENT);
            xw.attribute(null, VERSION_ATTR, gi.getPublicGraphicDef().getGraphicDef().getProviderDescription().getVisuVersionManager().getCurrentVersion().getXmlVersion());
            xw.attribute(null, PROVIDERID_ATTR, gi.getPublicGraphicDef().getGraphicDef().getProviderDescription().getId());
            if (gi.dataDescriptor_ != null && (flag & 0) == 0) {
                xw.startElement(METADATA_ELEMENT);
                ((XMLDataDescriptor)gi.dataDescriptor_.getXMLDelegate()).marshall2(xw);
                xw.endElement(METADATA_ELEMENT);
            }
            if (gi.graphic_ != null && (flag & 4) == 4) {
                XMLSettings xmlSettings = new XMLSettings();
                xmlSettings.m_Graphic = gi.getGraphicXmlDelegate();
                xw.startElement(SETTINGS_ELEMENT);
                xmlSettings.marshall2(xw);
                xw.endElement(SETTINGS_ELEMENT);
            }
            if (gi.feeder_ != null && (flag & 8) == 8) {
                xw.startElement(FEED_ELEMENT);
                ((XMLDataFeed)gi.feeder_.getCurrentDataFeed().getXMLDelegate()).marshall2(xw);
                xw.endElement(FEED_ELEMENT);
            }
            if (gi.dataAdapter_ != null && (flag & 1) == 1) {
                xw.startElement(DATA_ELEMENT);
                ((XMLDataAdapter)gi.dataAdapter_.getXMLDelegate()).marshall2(xw);
                xw.endElement(DATA_ELEMENT);
            }
            if (gi.windowManager_ != null && gi.windowManager_.getDataWindow() != null && (flag & 0x10) == 16) {
                xw.startElement(WINDOW_ELEMENT);
                ((XMLWindowManager)gi.windowManager_.getXMLDelegate()).marshall2(xw);
                xw.endElement(WINDOW_ELEMENT);
            }
            xw.endElement(MAIN_ELEMENT);
            xw.endDocument();
        }

        protected static int read(InputStream is, GraphicInstance gi) throws XmlException {
            int flag = 0;
            XmlReader xmlReader = new XmlReader(is);
            XMLDataAdapter xmlDataAdapter = null;
            XMLDataDescriptor xmlDataDescriptor = null;
            XMLSettings xmlSettings = null;
            XMLDataFeed xmlFeed = null;
            XMLWindowManager xmlWindowManager = null;
            String version = null;
            String providerId = null;
            VersionHelper versionHelper = null;
            XmlReaderVersion xmlReaderVersion = new XmlReaderVersion(xmlReader, null, null);
            while (xmlReader.next() != XmlEventType.END_DOCUMENT) {
                String sNode = xmlReader.getName();
                if (sNode != null && sNode.equals(MAIN_ELEMENT) && xmlReader.getEventType() == XmlEventType.START_ELEMENT) {
                    for (int i = 0; i < xmlReader.getAttributeCount(); ++i) {
                        String prefixName = xmlReader.getAttributePrefix(i);
                        String attName = xmlReader.getAttributeName(i);
                        String finalName = (prefixName != null ? prefixName : "") + (prefixName != null && attName != null ? ":" : "") + (attName != null ? attName : "");
                        if (finalName.equals(PROVIDERID_ATTR)) {
                            providerId = xmlReader.getAttributeValue(i);
                        }
                        if (!finalName.equals(VERSION_ATTR)) continue;
                        version = xmlReader.getAttributeValue(i);
                    }
                    ProviderDescription pdesc = gi.locEngine_.getProvider(providerId);
                    if (pdesc == null) {
                        pdesc = gi.locEngine_.getProviders()[0];
                    }
                    versionHelper = new VersionHelper(pdesc.getXmlProviderVersion(), version);
                    xmlReaderVersion = new XmlReaderVersion(xmlReader, versionHelper.getCurrentVersion(), versionHelper.getSerializedVersion());
                }
                if (sNode != null && sNode.equals(METADATA_ELEMENT)) {
                    flag |= 0;
                    xmlDataDescriptor = new XMLDataDescriptor();
                    xmlDataDescriptor.unmarshall(xmlReaderVersion);
                    gi.dataDescriptor_ = new DataDescriptor(xmlDataDescriptor, new SerializationHelper(versionHelper, gi.getLocalizedEngine().getFormatFactory()));
                    continue;
                }
                if (sNode != null && sNode.equals(SETTINGS_ELEMENT)) {
                    flag |= 4;
                    xmlSettings = new XMLSettings();
                    xmlSettings.unmarshall(xmlReaderVersion);
                    XMLGraphic xmlGraphic = xmlSettings.m_Graphic;
                    PublicGraphicDef pg = gi.locEngine_.getPublicGraphic(xmlGraphic.m_a_Id);
                    gi.graphic_ = new Graphic(xmlGraphic, pg, gi.mediator_, xmlReaderVersion.getSerializedVersion());
                    continue;
                }
                if (sNode != null && sNode.equals(FEED_ELEMENT)) {
                    flag |= 8;
                    xmlFeed = new XMLDataFeed();
                    xmlFeed.unmarshall(xmlReaderVersion);
                    continue;
                }
                if (sNode != null && sNode.equals(DATA_ELEMENT)) {
                    flag |= 1;
                    xmlDataAdapter = new XMLDataAdapter();
                    xmlDataAdapter.unmarshall(xmlReaderVersion);
                    gi.dataAdapter_ = new DataAdapter(xmlDataAdapter, new SerializationHelper(versionHelper, gi.getLocalizedEngine().getFormatFactory()));
                    continue;
                }
                if (sNode == null || !sNode.equals(WINDOW_ELEMENT)) continue;
                flag |= 0x10;
                xmlWindowManager = new XMLWindowManager();
                xmlWindowManager.unmarshall(xmlReaderVersion);
            }
            if (xmlFeed != null) {
                gi.feeder_ = new Feeder(gi.locEngine_.getDataFeedSpecification(gi.graphic_.getGraphicDefId()), gi.dataDescriptor_, gi.mediator_, xmlFeed, new SerializationHelper(versionHelper, gi.getLocalizedEngine().getFormatFactory()));
            }
            if (xmlWindowManager != null) {
                gi.windowManager_ = new DataWindowManager(xmlWindowManager, new SerializationHelper(versionHelper, gi.getLocalizedEngine().getFormatFactory()), gi);
            }
            return flag;
        }
    }
}

