/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.logging.log4j;

import com.businessobjects.foundation.logging.log4j.ILock;
import com.businessobjects.foundation.logging.log4j.LockException;
import com.businessobjects.foundation.logging.log4j.PropertyLock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;

class ComboLock
implements ILock {
    private File m_lockFile;
    private PropertyLock m_propLock;
    private FileOutputStream m_fout;
    private FileLock m_fileLock;

    public ComboLock(String lockFileName) throws IOException {
        this.m_lockFile = new File(lockFileName);
        this.m_fout = new FileOutputStream(this.m_lockFile);
        this.m_propLock = new PropertyLock(this.m_lockFile.getCanonicalPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws LockException {
        try {
            this.release();
        }
        finally {
            try {
                this.m_fout.close();
            }
            catch (IOException ioe) {
                throw new LockException(ioe);
            }
        }
    }

    public void acquire() throws LockException {
        boolean locked = false;
        this.m_propLock.acquire();
        try {
            this.m_fileLock = this.m_fout.getChannel().lock();
            locked = true;
        }
        catch (IOException ioe) {
            throw new LockException(ioe);
        }
        finally {
            if (!locked) {
                this.m_propLock.release();
            }
        }
    }

    public void release() throws LockException {
        try {
            this.m_fileLock.release();
        }
        catch (IOException ioe) {
            throw new LockException(ioe);
        }
        finally {
            this.m_propLock.release();
        }
    }
}

