/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.exception;

import com.businessobjects.foundation.exception.IException;
import com.businessobjects.foundation.exception.UncheckedException;
import java.util.Locale;

public class SerializationException
extends UncheckedException {
    protected SerializationException(Object[] args, Throwable cause) {
        super(null, args, cause, null);
    }

    public static class TooManyNodesException
    extends SerializationException {
        public TooManyNodesException(String nodeName) {
            super(new String[]{nodeName}, null);
        }
    }

    public static class MissingLocale
    extends SerializationException {
        public MissingLocale() {
            super(new String[0], null);
        }
    }

    public static class MissingNodeAttribute
    extends SerializationException {
        public MissingNodeAttribute(String attrName, String nodeName) {
            super(new String[]{attrName, nodeName}, null);
        }
    }

    public static class MissingNodeValueException
    extends SerializationException {
        public MissingNodeValueException(String nodeName) {
            super(new String[]{nodeName}, null);
        }
    }

    public static class ArgumentTypeNotSupported
    extends SerializationException {
        public ArgumentTypeNotSupported(String type) {
            super(new String[]{type}, null);
        }
    }

    public static class WrongExceptionType
    extends SerializationException {
        public WrongExceptionType() {
            super(new String[0], null);
        }
    }

    public static class ExceptionWrapper
    extends SerializationException {
        public ExceptionWrapper(Throwable cause) {
            super(new String[]{cause.getLocalizedMessage(), cause.getClass().getName()}, cause);
        }

        public String getMessage(Locale locale) {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException exception = (IException)((Object)t);
                return exception.getMessage(locale);
            }
            return t.getMessage();
        }
    }

    public static class DeserializeDateException
    extends SerializationException {
        public DeserializeDateException() {
            super(new String[0], null);
        }
    }

    public static class ParseDocumentException
    extends SerializationException {
        public ParseDocumentException(Throwable cause) {
            super(new String[0], cause);
        }
    }

    public static class WrongFormatException
    extends SerializationException {
        public WrongFormatException() {
            super(new String[0], null);
        }
    }
}

