/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.exception;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;

class ResourceFinder {
    private static final String s_separator = System.getProperty("file.separator");
    private static final String s_properies = ".properties";

    ResourceFinder() {
    }

    public static List findResourceLocales(ClassLoader cl, String resourceID) {
        String resDir = "";
        StringTokenizer tokenizer = new StringTokenizer(resourceID, ".");
        while (tokenizer.hasMoreTokens()) {
            if (resDir.equals("")) {
                resDir = tokenizer.nextToken();
                continue;
            }
            resDir = resDir + s_separator + tokenizer.nextToken();
        }
        List resources = ResourceFinder.getResources(cl, resourceID, resDir);
        return ResourceFinder.getLocales(resources);
    }

    private static List getResources(ClassLoader cl, String resourceID, String resDir) {
        ArrayList resources = new ArrayList();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)cl;
                URL[] urls = ucl.getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    URL url = urls[i];
                    String fileName = url.toExternalForm();
                    try {
                        File file;
                        if (fileName.endsWith(".jar")) {
                            ResourceFinder.listJarResources(new URL("jar:" + url.toExternalForm() + "!/"), resources, resourceID);
                            continue;
                        }
                        if (!url.getProtocol().equals("file") || !(file = new File(url.getFile())).isDirectory()) continue;
                        ResourceFinder.listDirResources(file, resources, resDir);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            cl = cl.getParent();
        }
        return resources;
    }

    private static void listDirResources(File dir, List resources, String resDir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                ResourceFinder.listDirResources(file, resources, resDir);
                continue;
            }
            String path = file.getPath();
            if (!ResourceFinder.contains(path, resDir) || !file.getName().endsWith(s_properies)) continue;
            resources.add(file.getName());
        }
    }

    private static void listJarResources(URL jarUrl, List resources, String resourceID) {
        try {
            JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
            Enumeration<JarEntry> entries = jarConnection.getJarFile().entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String enrtyName = entry.getName();
                if (!ResourceFinder.contains(enrtyName, resourceID) || !enrtyName.endsWith(s_properies)) continue;
                resources.add(enrtyName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static List getLocales(List resources) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            String resource = (String)iter.next();
            resource = resource.substring(0, resource.length() - s_properies.length());
            String[] parts = resource.split("_");
            int partAmount = parts.length;
            Locale locale = null;
            if (partAmount >= 4) {
                locale = ResourceFinder.checkLocalFormat(parts[partAmount - 3], parts[partAmount - 2], parts[partAmount - 1]);
            } else if (partAmount == 3) {
                locale = ResourceFinder.checkLocalFormat(parts[partAmount - 2], parts[partAmount - 1], "");
            } else if (partAmount == 2) {
                locale = ResourceFinder.checkLocalFormat(parts[partAmount - 1], "", "");
            }
            if (locale == null) continue;
            locales.add(locale);
        }
        return locales;
    }

    private static Locale checkLocalFormat(String langauge, String country, String variant) {
        if (variant.length() != 2 && country.length() != 2 && langauge.length() != 2) {
            return null;
        }
        if (country.length() == 2 && langauge.length() != 2) {
            langauge = country;
            if (variant.length() == 2) {
                country = variant;
                variant = "";
            } else {
                country = "";
                variant = "";
            }
        } else if (variant.length() == 2 && country.length() != 2 && langauge.length() != 2) {
            langauge = variant;
            country = "";
            variant = "";
        }
        return new Locale(langauge, country, variant);
    }

    private static boolean contains(String string, CharSequence subString) {
        return string.indexOf(((Object)subString).toString()) > -1;
    }
}

