/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataInput;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.IOException;
import java.util.Comparator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RangeValue
extends FormulaValue {
    private final FormulaValue h;
    private final FormulaValue g;
    private final boolean i;
    private final boolean j;

    private RangeValue(FormulaValue formulaValue, FormulaValue formulaValue2, boolean bl, boolean bl2) {
        FormulaValueType formulaValueType;
        if (formulaValue == null && formulaValue2 == null) {
            throw new NullPointerException("Both start and end values of a range cannot be null");
        }
        FormulaValueType formulaValueType2 = formulaValue == null ? FormulaValueType.unknown : formulaValue.getFormulaValueType();
        FormulaValueType formulaValueType3 = formulaValueType = formulaValue2 == null ? FormulaValueType.unknown : formulaValue2.getFormulaValueType();
        if (formulaValueType2.getBaseFormulaValueType() == FormulaValueType.bool || formulaValueType.getBaseFormulaValueType() == FormulaValueType.bool) {
            throw new IllegalArgumentException("Boolean range values are not allowed");
        }
        if (formulaValueType2.isRange() || formulaValueType.isRange()) {
            throw new IllegalArgumentException("A range cannot contain ranges as its start or end values");
        }
        if (formulaValueType2.isArray() || formulaValueType.isArray()) {
            throw new IllegalArgumentException("A range cannot contains arrays as its start or end values");
        }
        if (formulaValue != null && formulaValue2 != null && formulaValueType2 != formulaValueType) {
            throw new IllegalArgumentException("The start and end values cannot have different value types");
        }
        this.h = formulaValue;
        this.g = formulaValue2;
        this.i = bl && formulaValue != null;
        this.j = bl2 && formulaValue2 != null;
    }

    public static RangeValue fromStartAndEndValues(FormulaValue formulaValue, FormulaValue formulaValue2, boolean bl, boolean bl2) {
        return new RangeValue(formulaValue, formulaValue2, bl, bl2);
    }

    public static RangeValue fromSingleValue(FormulaValue formulaValue) {
        return new RangeValue(formulaValue, formulaValue, true, true);
    }

    public void store(ValueType valueType, ExtendedDataOutput extendedDataOutput) throws IOException {
        assert (valueType == this.getValueType());
        extendedDataOutput.writeBoolean(this.h != null);
        extendedDataOutput.writeBoolean(this.g != null);
        extendedDataOutput.writeBoolean(this.i);
        extendedDataOutput.writeBoolean(this.j);
        if (this.h != null) {
            this.h.store(valueType.getNonRangeValueType(), extendedDataOutput);
        }
        if (this.g != null) {
            this.g.store(valueType.getNonRangeValueType(), extendedDataOutput);
        }
    }

    public void storeToArchive(ValueType valueType, IOutputArchive iOutputArchive) throws ArchiveException {
        assert (valueType == this.getValueType());
        iOutputArchive.storeBoolean(this.i);
        iOutputArchive.storeBoolean(this.j);
        CrystalValue.StoreToArchive(this.h, valueType.getNonRangeValueType(), iOutputArchive);
        CrystalValue.StoreToArchive(this.g, valueType.getNonRangeValueType(), iOutputArchive);
    }

    public static RangeValue LoadFromArchive(ValueType valueType, IInputArchive iInputArchive) throws ArchiveException {
        assert (valueType.isRange());
        boolean bl = iInputArchive.loadBoolean();
        boolean bl2 = iInputArchive.loadBoolean();
        FormulaValue formulaValue = null;
        FormulaValue formulaValue2 = null;
        formulaValue = (FormulaValue)CrystalValue.LoadFromArchive(valueType.getNonRangeValueType(), iInputArchive);
        formulaValue2 = (FormulaValue)CrystalValue.LoadFromArchive(valueType.getNonRangeValueType(), iInputArchive);
        return RangeValue.fromStartAndEndValues(formulaValue, formulaValue2, bl, bl2);
    }

    public static RangeValue Load(ValueType valueType, ExtendedDataInput extendedDataInput) throws IOException {
        assert (valueType.isRange());
        boolean bl = extendedDataInput.readBoolean();
        boolean bl2 = extendedDataInput.readBoolean();
        boolean bl3 = extendedDataInput.readBoolean();
        boolean bl4 = extendedDataInput.readBoolean();
        FormulaValue formulaValue = null;
        FormulaValue formulaValue2 = null;
        if (bl) {
            formulaValue = FormulaValue.Load(valueType.getNonRangeValueType(), extendedDataInput);
        }
        if (bl2) {
            formulaValue2 = FormulaValue.Load(valueType.getNonRangeValueType(), extendedDataInput);
        }
        return RangeValue.fromStartAndEndValues(formulaValue, formulaValue2, bl3, bl4);
    }

    public int getEncodedSizeForArchive(ValueType valueType) {
        assert (valueType == this.getValueType());
        int n = 8;
        if (this.h != null) {
            n += this.h.getEncodedSizeForArchive(valueType.getNonRangeValueType());
        }
        if (this.g != null) {
            n += this.g.getEncodedSizeForArchive(valueType.getNonRangeValueType());
        }
        return n;
    }

    public int getEncodedSize(ValueType valueType) {
        assert (valueType == this.getValueType());
        int n = 4;
        if (this.h != null) {
            n += this.h.getEncodedSize(valueType.getNonRangeValueType());
        }
        if (this.g != null) {
            n += this.g.getEncodedSize(valueType.getNonRangeValueType());
        }
        return n;
    }

    public FormulaValue coerceToNumber() {
        return this.if(FormulaValueType.number);
    }

    public FormulaValue coerceToCurrency() {
        return this.if(FormulaValueType.currency);
    }

    public FormulaValue coerceToDate() {
        return this.if(FormulaValueType.date);
    }

    public FormulaValue coerceToTime() {
        return this.if(FormulaValueType.time);
    }

    public FormulaValue coerceToDateTime() {
        FormulaValueType formulaValueType = this.getFormulaValueType().getBaseFormulaValueType();
        if (formulaValueType == FormulaValueType.dateTime) {
            return this;
        }
        if (formulaValueType == FormulaValueType.date) {
            DateTimeValue dateTimeValue = null;
            if (this.h != null) {
                dateTimeValue = this.i ? ((DateValue)this.h).getStartOfDayDateTimeValue() : ((DateValue)this.h).getEndOfDayDateTimeValue();
            }
            DateTimeValue dateTimeValue2 = null;
            if (this.g != null) {
                dateTimeValue2 = this.j ? ((DateValue)this.g).getEndOfDayDateTimeValue() : ((DateValue)this.g).getStartOfDayDateTimeValue();
            }
            return RangeValue.fromStartAndEndValues(dateTimeValue, dateTimeValue2, this.i, this.j);
        }
        return this.if(FormulaValueType.dateTime);
    }

    public FormulaValue coerceToString() {
        return this.if(FormulaValueType.string);
    }

    private FormulaValue if(FormulaValueType formulaValueType) {
        FormulaValueType formulaValueType2 = this.getFormulaValueType().getBaseFormulaValueType();
        if (formulaValueType2 == formulaValueType) {
            return this;
        }
        FormulaValue formulaValue = RangeValue.coerce(this.h, formulaValueType);
        FormulaValue formulaValue2 = RangeValue.coerce(this.g, formulaValueType);
        if (formulaValue == null && this.h != null || formulaValue2 == null && this.g != null) {
            return null;
        }
        return RangeValue.fromStartAndEndValues(formulaValue, formulaValue2, this.i, this.j);
    }

    public FormulaValue coerceToRange() {
        return this;
    }

    public FormulaValue toSingleValue() {
        return this.h != null && this.h.equals(this.g) ? this.h : null;
    }

    public FormulaValue getStartValue() {
        return this.h;
    }

    public FormulaValue getEndValue() {
        return this.g;
    }

    public boolean getIncludeStart() {
        return this.i;
    }

    public boolean getIncludeEnd() {
        return this.j;
    }

    public ValueType getValueType() {
        ValueType valueType = this.h != null ? this.h.getValueType() : this.g.getValueType();
        return valueType.getRangeValueType();
    }

    public boolean equals(Object object, boolean bl) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        RangeValue rangeValue = (RangeValue)object;
        if (this.i != rangeValue.i || this.j != rangeValue.j) {
            return false;
        }
        if (this.h == null != (rangeValue.h == null)) {
            return false;
        }
        if (this.h != null && !this.h.equals(rangeValue.h, bl)) {
            return false;
        }
        if (this.g == null != (rangeValue.g == null)) {
            return false;
        }
        return this.g == null || this.g.equals(rangeValue.g, bl);
    }

    public int compareTo(Object object, Comparator comparator) {
        if (object == this) {
            return 0;
        }
        RangeValue rangeValue = (RangeValue)object;
        if (this.getValueType() != rangeValue.getValueType()) {
            throw new ClassCastException("Can't compare RangeValues with different valueTypes");
        }
        int n = RangeValue.compare(this.h, rangeValue.h, comparator);
        if (n != 0) {
            return n;
        }
        n = RangeValue.compare(this.g, rangeValue.g, comparator);
        if (n != 0) {
            return n;
        }
        n = RangeValue.compare(this.i, rangeValue.i);
        if (n != 0) {
            return n;
        }
        return RangeValue.compare(this.j, rangeValue.j);
    }

    public int hashCode(boolean bl) {
        int n = 17;
        n = 37 * n + (this.h == null ? 0 : this.h.hashCode(bl));
        n = 37 * n + (this.g == null ? 0 : this.g.hashCode(bl));
        n = 37 * n + (this.i ? 0 : 1);
        n = 37 * n + (this.j ? 0 : 1);
        return n;
    }

    public String toString() {
        return "r(" + (this.i ? "[" : "(") + this.h + ".." + this.g + (this.j ? "]" : ")") + ")";
    }
}

