/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataInput;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataInputStream;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutputStream;
import com.crystaldecisions.reports.common.value.BinaryValue;
import com.crystaldecisions.reports.common.value.CrystalComparable;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CrystalValue
implements CrystalComparable {
    public abstract ValueType getValueType();

    public int hashCode() {
        return this.hashCode(false);
    }

    public abstract int hashCode(boolean var1);

    public abstract String toString();

    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    public abstract boolean equals(Object var1, boolean var2);

    @Override
    public abstract int compareTo(Object var1, Comparator<String> var2);

    public static int compare(CrystalValue crystalValue, CrystalValue crystalValue2, Comparator<String> comparator) {
        if (crystalValue == null) {
            return crystalValue2 == null ? 0 : -1;
        }
        if (crystalValue2 == null) {
            return 1;
        }
        return crystalValue.compareTo(crystalValue2, comparator);
    }

    static int compare(int n, int n2) {
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return 0;
    }

    static int compare(boolean bl, boolean bl2) {
        if (bl == bl2) {
            return 0;
        }
        return bl ? 1 : -1;
    }

    public boolean canStoreValue(ValueType valueType, int n) {
        assert (valueType != null);
        int n2 = this.getEncodedSize(valueType);
        return n2 <= n;
    }

    public boolean canStoreValueToArchive(ValueType valueType, int n) {
        assert (valueType != null);
        int n2 = this.getEncodedSizeForArchive(valueType);
        return n2 <= n;
    }

    public abstract void store(ValueType var1, ExtendedDataOutput var2) throws IOException;

    public abstract void storeToArchive(ValueType var1, IOutputArchive var2) throws ArchiveException;

    public abstract int getEncodedSize(ValueType var1);

    public abstract int getEncodedSizeForArchive(ValueType var1);

    public static boolean HasFixedEncodedSize(ValueType valueType) {
        return valueType.isNumber() || valueType == ValueType.date || valueType == ValueType.time;
    }

    public static int GetFixedEncodedSize(ValueType valueType) {
        if (valueType.isNumber()) {
            return NumberValue.GetMaxEncodedSize(valueType);
        }
        if (valueType == ValueType.currency) {
            return CurrencyValue.GetMaxEncodedSize();
        }
        if (valueType == ValueType.date) {
            return DateValue.GetMaxEncodedSize();
        }
        if (valueType == ValueType.time) {
            return TimeValue.GetMaxEncodedSize();
        }
        throw new IllegalArgumentException();
    }

    public static CrystalValue Load(ValueType valueType, ExtendedDataInput extendedDataInput) throws IOException {
        CrystalValue crystalValue = null;
        crystalValue = valueType.isBlob() ? BinaryValue.Load(extendedDataInput) : FormulaValue.Load(valueType, extendedDataInput);
        return crystalValue;
    }

    public static void StoreToArchive(CrystalValue crystalValue, ValueType valueType, IOutputArchive iOutputArchive) throws ArchiveException {
        boolean bl = crystalValue != null;
        iOutputArchive.storeBoolean(bl);
        if (bl) {
            crystalValue.storeToArchive(valueType, iOutputArchive);
        }
    }

    public static CrystalValue LoadFromArchive(ValueType valueType, IInputArchive iInputArchive) throws ArchiveException {
        CrystalValue crystalValue = null;
        boolean bl = iInputArchive.loadBoolean();
        if (!bl) {
            return null;
        }
        crystalValue = valueType.isBlob() ? BinaryValue.LoadFromArchive(iInputArchive) : FormulaValue.LoadFromArchive(valueType, iInputArchive);
        return crystalValue;
    }

    public static void StoreToStream(CrystalValue crystalValue, ValueType valueType, OutputStream outputStream) throws IOException {
        ExtendedDataOutput extendedDataOutput = outputStream instanceof ExtendedDataOutput ? (ExtendedDataOutput)((Object)outputStream) : new ExtendedDataOutputStream(outputStream);
        boolean bl = crystalValue != null;
        extendedDataOutput.writeBoolean(bl);
        if (bl) {
            crystalValue.store(valueType, extendedDataOutput);
        }
    }

    public static CrystalValue LoadFromStream(ValueType valueType, InputStream inputStream) throws IOException {
        ExtendedDataInput extendedDataInput = inputStream instanceof ExtendedDataInput ? (ExtendedDataInput)((Object)inputStream) : new ExtendedDataInputStream(inputStream);
        boolean bl = extendedDataInput.readBoolean();
        if (!bl) {
            return null;
        }
        return CrystalValue.Load(valueType, extendedDataInput);
    }

    public static CrystalValue GetDefaultValueForType(ValueType valueType) {
        valueType = valueType.getUnifiedNumberValueType();
        switch (valueType.getBaseValueType().value()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 13: {
                valueType = valueType.isRangeArray() ? ValueType.stringRangeArray : (valueType.isArray() ? ValueType.stringArray : (valueType.isRange() ? ValueType.stringRange : ValueType.string));
                break;
            }
            case 14: {
                return null;
            }
            default: {
                assert (false) : "Unexpected ValueType";
                return null;
            }
        }
        return FormulaValue.makeZeroValue(FormulaValueType.fromValueType(valueType));
    }
}

