/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

class OracleFailoverWorkerThread
extends Thread {
    protected OracleImplicitConnectionCache implicitCache = null;
    protected int eventType = 0;
    protected String eventServiceName = null;
    protected String instanceNameKey = null;
    protected String databaseNameKey = null;
    protected String hostNameKey = null;
    protected String status = null;
    protected int cardinality = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    OracleFailoverWorkerThread(OracleImplicitConnectionCache oicc, int eventType, String instNameKey, String dbUniqNameKey, String hostNameKey, String status, int card) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFailoverWorkerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oicc) + ", " + OracleLog.argument(eventType) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status) + ", " + OracleLog.argument(card));
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.implicitCache = oicc;
            this.eventType = eventType;
            this.instanceNameKey = instNameKey;
            this.databaseNameKey = dbUniqNameKey;
            this.hostNameKey = hostNameKey;
            this.status = status;
            this.cardinality = card;
            Object var11_11 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleFailoverWorkerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_15 = null;
            }
            catch (Throwable throwable2) {
                Object var13_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleFailoverWorkerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            block13: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleFailoverWorkerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                try {
                    if (this.status != null) {
                        this.implicitCache.processFailoverEvent(this.eventType, this.instanceNameKey, this.databaseNameKey, this.hostNameKey, this.status, this.cardinality);
                    }
                }
                catch (Exception ex) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                    try {
                        OracleFailoverWorkerThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleImplicitConnectionCache.OracleFailoverWorkerThread()" + "\neventType=" + this.eventType + "\ninstanceName=" + this.instanceNameKey + "\ndatabaseName=" + this.databaseNameKey + "\nhostName=" + this.hostNameKey + "\nstatus=" + this.status + "\ncardinality=" + this.cardinality + "\n" + ex.getMessage());
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleFailoverWorkerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleFailoverWorkerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleFailoverWorkerThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

