/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestamptzAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 13;
    TimestampTzConverter tstzConverter = null;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    static byte REGIONIDBIT = (byte)-128;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimestamptzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.init(stmt, 181, 181, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimestamptzAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.init(stmt, 181, 181, form, false);
            this.initForDescribe(181, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_15 = null;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TimestamptzAccessor.TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                    var5_4 = null;
                }
                catch (Throwable var4_6) {
                    var5_5 = null;
                    OracleLog.recursiveExit();
                    throw var4_6;
                }
                OracleLog.recursiveExit();
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = 13;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
            this.byteLength = this.internalTypeMaxLength;
            var7_7 = null;
            if (TimestamptzAccessor.TRACE == false) return;
            ** GOTO lbl39
        }
        catch (Throwable var6_15) {
            var7_8 = null;
            if (TimestamptzAccessor.TRACE == false) throw var6_15;
            if (OracleLog.recursiveEnter() == false) throw var6_15;
            try {
                TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var9_11 = null;
            }
            catch (Throwable var8_14) {
                var9_12 = null;
                OracleLog.recursiveExit();
                throw var8_14;
            }
lbl39:
            // 1 sources

            if (OracleLog.recursiveEnter() == false) return;
            try {}
            catch (Throwable var8_13) {
                var9_10 = null;
                OracleLog.recursiveExit();
                throw var8_13;
            }
            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var9_9 = null;
            OracleLog.recursiveExit();
            return;
            OracleLog.recursiveExit();
            throw var6_15;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getString(int currentRow) throws SQLException {
        boolean am;
        String regname;
        block29: {
            String __ex__2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.rowSpaceIndicator == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                            Object var5_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                    __ex__2.fillInStackTrace();
                    throw __ex__2;
                }
                if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) break block29;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var7_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__2 = null;
                Object var18_22 = null;
            }
            catch (Throwable throwable) {
                Object var18_24 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var20_29 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var20_30 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var20_25 = null;
                }
                catch (Throwable throwable) {
                    Object var20_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return __ex__2;
        }
        int off = this.columnIndex + this.byteLength * currentRow;
        int regionID = 0;
        if ((this.oracleTZ1(off) & REGIONIDBIT) != 0) {
            regionID = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(off));
            TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
            if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(off)))) {
                tzTab.updateTable(this.statement.connection, regionID);
            }
            regname = ZONEIDMAP.getRegion(regionID);
        } else {
            int off_hour = this.oracleTZ1(off) - OFFSET_HOUR;
            int off_minute = this.oracleTZ2(off) - OFFSET_MINUTE;
            regname = "GMT" + (off_hour < 0 ? "-" : "+") + Math.abs(off_hour) + ":" + (off_minute < 10 ? "0" : "") + off_minute;
        }
        Calendar calUTC = this.statement.getGMTCalendar();
        int year = this.oracleYear(off);
        calUTC.set(1, year);
        calUTC.set(2, this.oracleMonth(off));
        calUTC.set(5, this.oracleDay(off));
        calUTC.set(11, this.oracleHour(off));
        calUTC.set(12, this.oracleMin(off));
        calUTC.set(13, this.oracleSec(off));
        calUTC.set(14, 0);
        if ((this.oracleTZ1(off) & REGIONIDBIT) != 0) {
            TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
            int offset_gmt = tzTab.getOffset(calUTC, regionID);
            calUTC.add(14, offset_gmt);
        } else {
            calUTC.add(10, this.oracleTZ1(off) - OFFSET_HOUR);
            calUTC.add(12, this.oracleTZ2(off) - OFFSET_MINUTE);
        }
        year = calUTC.get(1);
        int month = calUTC.get(2) + 1;
        int date = calUTC.get(5);
        int hour = calUTC.get(11);
        int min = calUTC.get(12);
        int sec = calUTC.get(13);
        boolean bl = am = hour < 12;
        if (regname.length() > 3 && regname.startsWith("GMT")) {
            regname = regname.substring(3);
        }
        int nanos = this.oracleNanos(off);
        String __result__ = this.toText(year, month, date, hour, min, sec, nanos, am, regname);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var16_41 = null;
            }
            catch (Throwable throwable) {
                Object var16_42 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        String string = __result__;
        Object var18_23 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var20_27 = null;
            }
            catch (Throwable throwable) {
                Object var20_28 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    Date getDate(int currentRow) throws SQLException {
        return this.tstzConverter.getDate(currentRow);
    }

    Date getDate(int currentRow, Calendar cal) throws SQLException {
        return this.getDate(currentRow);
    }

    Time getTime(int currentRow) throws SQLException {
        return this.tstzConverter.getTime(currentRow);
    }

    Time getTime(int currentRow, Calendar cal) throws SQLException {
        return this.getTime(currentRow);
    }

    Timestamp getTimestamp(int currentRow) throws SQLException {
        return this.tstzConverter.getTimestamp(currentRow);
    }

    Timestamp getTimestamp(int currentRow, Calendar cal) throws SQLException {
        return this.getTimestamp(currentRow);
    }

    Object getObject(int currentRow) throws SQLException {
        return this.tstzConverter.getObject(currentRow);
    }

    Datum getOracleObject(int currentRow) throws SQLException {
        return this.tstzConverter.getOracleObject(currentRow);
    }

    DATE getDATE(int currentRow) throws SQLException {
        TIMESTAMPTZ tstz = this.tstzConverter.getTIMESTAMPTZ(currentRow);
        return oracle.sql.TIMESTAMPTZ.toDATE(this.statement.connection, tstz.getBytes());
    }

    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        TIMESTAMPTZ tstz = this.tstzConverter.getTIMESTAMPTZ(currentRow);
        return oracle.sql.TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, tstz.getBytes());
    }

    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        return this.tstzConverter.getTIMESTAMPTZ(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int setHighOrderbits(int ID) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(ID));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = (ID & 0x1FC0) >> 6;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int setLowOrderbits(int ID) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(ID));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = (ID & 0x3F) << 2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getHighOrderbits(int ID) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(ID));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = (ID & 0x7F) << 6;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getLowOrderbits(int ID) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(ID));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = (ID & 0xFC) >> 2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.TimestamptzAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    abstract class TimestampTzConverter {
        TimestampTzConverter() {
        }

        abstract Date getDate(int var1) throws SQLException;

        abstract Time getTime(int var1) throws SQLException;

        abstract Timestamp getTimestamp(int var1) throws SQLException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getObject(int currentRow) throws SQLException {
            TIMESTAMPTZ tIMESTAMPTZ;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                        tIMESTAMPTZ = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                TIMESTAMPTZ __result__ = this.getTIMESTAMPTZ(currentRow);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                tIMESTAMPTZ = __result__;
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var9_13 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var9_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return tIMESTAMPTZ;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Datum getOracleObject(int currentRow) throws SQLException {
            TIMESTAMPTZ tIMESTAMPTZ;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                        tIMESTAMPTZ = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                TIMESTAMPTZ __result__ = this.getTIMESTAMPTZ(currentRow);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                tIMESTAMPTZ = __result__;
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var9_13 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var9_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return tIMESTAMPTZ;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getObject(int currentRow, Map map) throws SQLException {
            TIMESTAMPTZ tIMESTAMPTZ;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                        tIMESTAMPTZ = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                TIMESTAMPTZ __result__ = this.getTIMESTAMPTZ(currentRow);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                tIMESTAMPTZ = __result__;
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var10_14 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var10_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return tIMESTAMPTZ;
        }

        abstract TIMESTAMPTZ getTIMESTAMPTZ(int var1) throws SQLException;
    }

    class GmtTimestampTzConverter
    extends TimestampTzConverter {
        GmtTimestampTzConverter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Date getDate(int currentRow) throws SQLException {
            block20: {
                Date __ex__2;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                TimestamptzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                                Object var5_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_9 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__2 = DatabaseError.createSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                        __ex__2.fillInStackTrace();
                        throw __ex__2;
                    }
                    if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] != -1) break block20;
                    __ex__2 = null;
                    Object var10_13 = null;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var12_20 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var12_21 = null;
                            OracleLog.recursiveExit();
                            throw throwable2;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    throw throwable;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var12_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return __ex__2;
            }
            int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
            Calendar cal = TimestamptzAccessor.this.statement.getGMTCalendar();
            int year = TimestamptzAccessor.this.oracleYear(off);
            cal.set(1, year);
            cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
            cal.set(5, TimestamptzAccessor.this.oracleDay(off));
            cal.set(11, TimestamptzAccessor.this.oracleHour(off));
            cal.set(12, TimestamptzAccessor.this.oracleMin(off));
            cal.set(13, TimestamptzAccessor.this.oracleSec(off));
            cal.set(14, 0);
            long millis = cal.getTimeInMillis();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + new Date(millis));
                    Object var8_25 = null;
                }
                catch (Throwable throwable) {
                    Object var8_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Date date = new Date(millis);
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_18 = null;
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return date;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        Time getTime(int currentRow) throws SQLException {
            Time time;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                        Object var3_2 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                            Object var5_8 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] == -1) {
                    Time __ex__ = null;
                    Object var7_13 = null;
                    if (!TRACE) return __ex__;
                    if (!OracleLog.recursiveEnter()) return __ex__;
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var9_16 = null;
                        OracleLog.recursiveExit();
                        return __ex__;
                    }
                    catch (Throwable throwable) {
                        Object var9_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
                Calendar cal = TimestamptzAccessor.this.statement.getGMTCalendar();
                int year = TimestamptzAccessor.this.oracleYear(off);
                cal.set(1, year);
                cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
                cal.set(5, TimestamptzAccessor.this.oracleDay(off));
                cal.set(11, TimestamptzAccessor.this.oracleHour(off));
                cal.set(12, TimestamptzAccessor.this.oracleMin(off));
                cal.set(13, TimestamptzAccessor.this.oracleSec(off));
                cal.set(14, 0);
                time = new Time(cal.getTimeInMillis());
                Object var7_14 = null;
                if (!TRACE) return time;
            }
            catch (Throwable throwable) {
                Object var7_15 = null;
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {}
                catch (Throwable throwable2) {
                    Object var9_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            if (!OracleLog.recursiveEnter()) return time;
            try {}
            catch (Throwable throwable) {
                Object var9_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_18 = null;
            OracleLog.recursiveExit();
            return time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Timestamp getTimestamp(int currentRow) throws SQLException {
            block20: {
                Timestamp __ex__2;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                TimestamptzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                                Object var5_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_9 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__2 = DatabaseError.createSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                        __ex__2.fillInStackTrace();
                        throw __ex__2;
                    }
                    if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] != -1) break block20;
                    __ex__2 = null;
                    Object var12_13 = null;
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var14_20 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var14_21 = null;
                            OracleLog.recursiveExit();
                            throw throwable2;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    throw throwable;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var14_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return __ex__2;
            }
            int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
            Calendar cal = TimestamptzAccessor.this.statement.getGMTCalendar();
            int year = TimestamptzAccessor.this.oracleYear(off);
            cal.set(1, year);
            cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
            cal.set(5, TimestamptzAccessor.this.oracleDay(off));
            cal.set(11, TimestamptzAccessor.this.oracleHour(off));
            cal.set(12, TimestamptzAccessor.this.oracleMin(off));
            cal.set(13, TimestamptzAccessor.this.oracleSec(off));
            cal.set(14, 0);
            long millis = cal.getTimeInMillis();
            Timestamp result = new Timestamp(millis);
            int nanos = TimestamptzAccessor.this.oracleNanos(off);
            result.setNanos(nanos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var10_27 = null;
                }
                catch (Throwable throwable) {
                    Object var10_28 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Timestamp timestamp = result;
            Object var12_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_18 = null;
                }
                catch (Throwable throwable) {
                    Object var14_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return timestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
            TIMESTAMPTZ tIMESTAMPTZ;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                        tIMESTAMPTZ = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                TIMESTAMPTZ result = null;
                if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                            Object var5_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] != -1) {
                    int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
                    byte[] data = new byte[13];
                    System.arraycopy(TimestamptzAccessor.this.rowSpaceByte, off, data, 0, 13);
                    result = new TIMESTAMPTZ(data);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                tIMESTAMPTZ = result;
                Object var9_14 = null;
                if (!TRACE) return tIMESTAMPTZ;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                    throw throwable;
                }
            }
            if (!OracleLog.recursiveEnter()) return tIMESTAMPTZ;
            try {
                TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return tIMESTAMPTZ;
        }
    }

    class OldTimestampTzConverter
    extends TimestampTzConverter {
        OldTimestampTzConverter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Date getDate(int currentRow) throws SQLException {
            block26: {
                Date __ex__2;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                TimestamptzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                                Object var5_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_9 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__2 = DatabaseError.createSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                        __ex__2.fillInStackTrace();
                        throw __ex__2;
                    }
                    if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] != -1) break block26;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                            Object var7_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_14 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    __ex__2 = null;
                    Object var14_19 = null;
                    if (!TRACE) return __ex__2;
                }
                catch (Throwable throwable) {
                    Object var14_21 = null;
                    if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var16_26 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var16_27 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                        throw throwable;
                    }
                }
                if (!OracleLog.recursiveEnter()) return __ex__2;
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var16_22 = null;
                }
                catch (Throwable throwable) {
                    Object var16_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                return __ex__2;
            }
            int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
            TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar cal = Calendar.getInstance(zone);
            int year = TimestamptzAccessor.this.oracleYear(off);
            cal.set(1, year);
            cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
            cal.set(5, TimestamptzAccessor.this.oracleDay(off));
            cal.set(11, TimestamptzAccessor.this.oracleHour(off));
            cal.set(12, TimestamptzAccessor.this.oracleMin(off));
            cal.set(13, TimestamptzAccessor.this.oracleSec(off));
            cal.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(off) & REGIONIDBIT) != 0) {
                int regionID = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(off));
                TIMEZONETAB tzTab = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(off)))) {
                    tzTab.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                }
                int offset = tzTab.getOffset(cal, regionID);
                boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                if (!sourceTimeInDST && destinationTimeInDST) {
                    cal.add(14, -1 * zone.getDSTSavings());
                } else if (sourceTimeInDST && !destinationTimeInDST) {
                    cal.add(14, zone.getDSTSavings());
                }
                cal.add(10, offset / 3600000);
                cal.add(12, offset % 3600000 / 60000);
            } else {
                cal.add(10, TimestamptzAccessor.this.oracleTZ1(off) - OFFSET_HOUR);
                cal.add(12, TimestamptzAccessor.this.oracleTZ2(off) - OFFSET_MINUTE);
            }
            long millis = cal.getTimeInMillis();
            Date __result__ = new Date(millis);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var12_36 = null;
                }
                catch (Throwable throwable) {
                    Object var12_37 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Date date = __result__;
            Object var14_20 = null;
            if (!TRACE) return date;
            if (!OracleLog.recursiveEnter()) return date;
            try {
                TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_24 = null;
            }
            catch (Throwable throwable) {
                Object var16_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return date;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Time getTime(int currentRow) throws SQLException {
            block29: {
                Time __ex__2;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                TimestamptzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                                Object var5_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_9 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__2 = DatabaseError.createSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                        __ex__2.fillInStackTrace();
                        throw __ex__2;
                    }
                    if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] != -1) break block29;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                            Object var7_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_14 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    __ex__2 = null;
                    Object var14_19 = null;
                }
                catch (Throwable throwable) {
                    Object var14_21 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var16_26 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var16_27 = null;
                            OracleLog.recursiveExit();
                            throw throwable2;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    throw throwable;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var16_22 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_23 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return __ex__2;
            }
            int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
            TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar cal = Calendar.getInstance(zone);
            int year = TimestamptzAccessor.this.oracleYear(off);
            cal.set(1, year);
            cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
            cal.set(5, TimestamptzAccessor.this.oracleDay(off));
            cal.set(11, TimestamptzAccessor.this.oracleHour(off));
            cal.set(12, TimestamptzAccessor.this.oracleMin(off));
            cal.set(13, TimestamptzAccessor.this.oracleSec(off));
            cal.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(off) & REGIONIDBIT) != 0) {
                int regionID = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(off));
                TIMEZONETAB tzTab = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(off)))) {
                    tzTab.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                }
                int offset = tzTab.getOffset(cal, regionID);
                boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                if (!sourceTimeInDST && destinationTimeInDST) {
                    cal.add(14, -1 * zone.getDSTSavings());
                } else if (sourceTimeInDST && !destinationTimeInDST) {
                    cal.add(14, zone.getDSTSavings());
                }
                cal.add(10, offset / 3600000);
                cal.add(12, offset % 3600000 / 60000);
            } else {
                cal.add(10, TimestamptzAccessor.this.oracleTZ1(off) - OFFSET_HOUR);
                cal.add(12, TimestamptzAccessor.this.oracleTZ2(off) - OFFSET_MINUTE);
            }
            long millis = cal.getTimeInMillis();
            Time __result__ = new Time(millis);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var12_36 = null;
                }
                catch (Throwable throwable) {
                    Object var12_37 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Time time = __result__;
            Object var14_20 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var16_24 = null;
                }
                catch (Throwable throwable) {
                    Object var16_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Timestamp getTimestamp(int currentRow) throws SQLException {
            block29: {
                Timestamp __ex__2;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                TimestamptzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                                Object var5_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_9 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__2 = DatabaseError.createSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                        __ex__2.fillInStackTrace();
                        throw __ex__2;
                    }
                    if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] != -1) break block29;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                            Object var7_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_14 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    __ex__2 = null;
                    Object var15_19 = null;
                }
                catch (Throwable throwable) {
                    Object var15_21 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var17_26 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var17_27 = null;
                            OracleLog.recursiveExit();
                            throw throwable2;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    throw throwable;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var17_22 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_23 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return __ex__2;
            }
            int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
            TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar cal = Calendar.getInstance(zone);
            Calendar calUTC = TimestamptzAccessor.this.statement.getGMTCalendar();
            int year = TimestamptzAccessor.this.oracleYear(off);
            cal.set(1, year);
            cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
            cal.set(5, TimestamptzAccessor.this.oracleDay(off));
            cal.set(11, TimestamptzAccessor.this.oracleHour(off));
            cal.set(12, TimestamptzAccessor.this.oracleMin(off));
            cal.set(13, TimestamptzAccessor.this.oracleSec(off));
            cal.set(14, 0);
            calUTC.set(1, year);
            calUTC.set(2, TimestamptzAccessor.this.oracleMonth(off));
            calUTC.set(5, TimestamptzAccessor.this.oracleDay(off));
            calUTC.set(11, TimestamptzAccessor.this.oracleHour(off));
            calUTC.set(12, TimestamptzAccessor.this.oracleMin(off));
            calUTC.set(13, TimestamptzAccessor.this.oracleSec(off));
            calUTC.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(off) & REGIONIDBIT) != 0) {
                int regionID = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(off));
                TIMEZONETAB tzTab = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(off)))) {
                    tzTab.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                }
                int offset = tzTab.getOffset(calUTC, regionID);
                boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                if (!sourceTimeInDST && destinationTimeInDST) {
                    cal.add(14, -1 * zone.getDSTSavings());
                } else if (sourceTimeInDST && !destinationTimeInDST) {
                    cal.add(14, zone.getDSTSavings());
                }
                cal.add(10, offset / 3600000);
                cal.add(12, offset % 3600000 / 60000);
            } else {
                cal.add(10, TimestamptzAccessor.this.oracleTZ1(off) - OFFSET_HOUR);
                cal.add(12, TimestamptzAccessor.this.oracleTZ2(off) - OFFSET_MINUTE);
            }
            long millis = cal.getTimeInMillis();
            Timestamp result = new Timestamp(millis);
            int nanos = TimestamptzAccessor.this.oracleNanos(off);
            result.setNanos(nanos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var13_37 = null;
                }
                catch (Throwable throwable) {
                    Object var13_38 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Timestamp timestamp = result;
            Object var15_20 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_24 = null;
                }
                catch (Throwable throwable) {
                    Object var17_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return timestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
            TIMESTAMPTZ tIMESTAMPTZ;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                        tIMESTAMPTZ = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                TIMESTAMPTZ result = null;
                if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestamptzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                            Object var5_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] != -1) {
                    int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
                    byte[] data = new byte[13];
                    System.arraycopy(TimestamptzAccessor.this.rowSpaceByte, off, data, 0, 13);
                    result = new TIMESTAMPTZ(data);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                tIMESTAMPTZ = result;
                Object var9_14 = null;
                if (!TRACE) return tIMESTAMPTZ;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                try {
                    TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                    throw throwable;
                }
            }
            if (!OracleLog.recursiveEnter()) return tIMESTAMPTZ;
            try {
                TimestamptzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return tIMESTAMPTZ;
        }
    }
}

