/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4COutRawAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CStatement
extends OracleStatement {
    static final byte[][][] parameterDatum = null;
    static final OracleTypeADT[][] parameterOtype = null;
    static final byte[] EMPTY_BYTE = new byte[0];
    T4CConnection t4Connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOall8(boolean doParse, boolean doExecute, boolean doFetch, boolean doDescribe, boolean doDefine) throws SQLException, IOException {
        int i2;
        if (doParse || doDescribe || !doExecute) {
            this.oacdefSent = null;
        }
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.doOall8");
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 439 + "sqlKind = " + (Object)((Object)this.sqlKind));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 439, "sqlKind = " + (Object)((Object)this.sqlKind));
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (doFetch) {
            this.rowPrefetchInLastFetch = this.rowPrefetch;
        }
        int number_of_define_positions_local = this.numberOfDefinePositions;
        if (this.sqlKind.isDML()) {
            number_of_define_positions_local = 0;
        }
        if (this.accessors != null) {
            for (i2 = 0; i2 < this.accessors.length; ++i2) {
                if (this.accessors[i2] == null) continue;
                this.accessors[i2].lastRowProcessed = 0;
            }
        }
        if (this.outBindAccessors != null) {
            for (i2 = 0; i2 < this.outBindAccessors.length; ++i2) {
                if (this.outBindAccessors[i2] == null) continue;
                this.outBindAccessors[i2].lastRowProcessed = 0;
            }
        }
        if (this.returnParamAccessors != null) {
            for (i2 = 0; i2 < this.returnParamAccessors.length; ++i2) {
                if (this.returnParamAccessors[i2] == null) continue;
                this.returnParamAccessors[i2].lastRowProcessed = 0;
            }
        }
        if (this.bindIndicators != null) {
            int number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            int maxNbBytes = 0;
            if (this.ibtBindChars != null) {
                maxNbBytes = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
            }
            for (int P = 0; P < this.numberOfBindPositions; ++P) {
                int subRangeOffset = this.bindIndicatorSubRange + 5 + 10 * P;
                int charPitch = this.bindIndicators[subRangeOffset + 2] & 0xFFFF;
                if (charPitch == 0) continue;
                int formOfUse = this.bindIndicators[subRangeOffset + 9] & 0xFFFF;
                maxNbBytes = formOfUse == 2 ? Math.max(charPitch * this.connection.conversion.maxNCharSize, maxNbBytes) : Math.max(charPitch * this.connection.conversion.cMaxCharSize, maxNbBytes);
            }
            if (this.tmpBindsByteArray == null) {
                this.tmpBindsByteArray = new byte[maxNbBytes];
            } else if (this.tmpBindsByteArray.length < maxNbBytes) {
                this.tmpBindsByteArray = null;
                this.tmpBindsByteArray = new byte[maxNbBytes];
            }
        } else {
            this.tmpBindsByteArray = null;
        }
        int[] definedColumnTypeCopy = this.definedColumnType;
        int[] definedColumnSizeCopy = this.definedColumnSize;
        int[] definedColumnFormOfUseCopy = this.definedColumnFormOfUse;
        if (doDefine && doDescribe && this.sqlObject.includeRowid) {
            definedColumnTypeCopy = new int[this.definedColumnType.length + 1];
            System.arraycopy(this.definedColumnType, 0, definedColumnTypeCopy, 1, this.definedColumnType.length);
            definedColumnTypeCopy[0] = -8;
            definedColumnSizeCopy = new int[this.definedColumnSize.length + 1];
            System.arraycopy(this.definedColumnSize, 0, definedColumnSizeCopy, 1, this.definedColumnSize.length);
            definedColumnFormOfUseCopy = new int[this.definedColumnFormOfUse.length + 1];
            System.arraycopy(this.definedColumnFormOfUse, 0, definedColumnFormOfUseCopy, 1, this.definedColumnFormOfUse.length);
        }
        this.allocateTmpByteArray();
        T4C8Oall all8 = this.t4Connection.all8;
        this.t4Connection.sendPiggyBackedMessages();
        try {
            all8.doOALL(doParse, doExecute, doFetch, doDescribe, doDefine, this.sqlKind, this.cursorId, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals), this.rowPrefetch, this.outBindAccessors, this.numberOfBindPositions, this.accessors, number_of_define_positions_local, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, parameterDatum, parameterOtype, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent, definedColumnTypeCopy, definedColumnSizeCopy, definedColumnFormOfUseCopy, this.registration);
            int tmpCursorID = all8.getCursorId();
            if (tmpCursorID != 0) {
                this.cursorId = tmpCursorID;
            }
            this.oacdefSent = all8.oacdefBindsSent;
        }
        catch (SQLException ea) {
            int tmpCursorID = all8.getCursorId();
            if (tmpCursorID != 0) {
                this.cursorId = tmpCursorID;
            }
            if (ea.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw ea;
        }
    }

    void allocateTmpByteArray() {
        if (this.tmpByteArray == null) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        } else if (this.sizeTmpByteArray > this.tmpByteArray.length) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseBuffers() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            super.releaseBuffers();
            this.tmpByteArray = null;
            this.tmpBindsByteArray = null;
            this.t4Connection.all8.bindChars = null;
            this.t4Connection.all8.bindBytes = null;
            this.t4Connection.all8.tmpBindsByteArray = null;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateRowidAccessor() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reparseOnRedefineIfNeeded() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.needToParse = true;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void defineColumnTypeInternal(int column_index, int type, int size, short form, boolean sizeNotGiven, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(sizeNotGiven) + ", " + OracleLog.argument(typeName));
                    Object var8_7 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.connection.disableDefinecolumntype) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CStatement.defineColumnTypeInternal--DISABLED");
                        Object var10_14 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var10_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        Object var12_17 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var12_18 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Object var20_20 = null;
                if (!TRACE) return;
                if (!OracleLog.recursiveEnter()) return;
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var22_23 = null;
                    OracleLog.recursiveExit();
                    return;
                }
                catch (Throwable throwable) {
                    Object var22_24 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (column_index < 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        Object var14_32 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var14_33 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (sizeNotGiven) {
                if (type == 1 || type == 12) {
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
                }
            } else if (size < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 53);
                        Object var16_35 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var16_36 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.currentResultSet != null && !this.currentResultSet.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 28);
                        Object var18_38 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var18_39 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 28);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int idx = column_index - 1;
            if (this.definedColumnType == null || this.definedColumnType.length <= idx) {
                if (this.definedColumnType == null) {
                    this.definedColumnType = new int[(idx + 1) * 4];
                } else {
                    int[] n_definedColumnType = new int[(idx + 1) * 4];
                    System.arraycopy(this.definedColumnType, 0, n_definedColumnType, 0, this.definedColumnType.length);
                    this.definedColumnType = n_definedColumnType;
                }
            }
            this.definedColumnType[idx] = type;
            if (this.definedColumnSize == null || this.definedColumnSize.length <= idx) {
                if (this.definedColumnSize == null) {
                    this.definedColumnSize = new int[(idx + 1) * 4];
                } else {
                    int[] n_definedColumnSize = new int[(idx + 1) * 4];
                    System.arraycopy(this.definedColumnSize, 0, n_definedColumnSize, 0, this.definedColumnSize.length);
                    this.definedColumnSize = n_definedColumnSize;
                }
            }
            this.definedColumnSize[idx] = size;
            if (this.definedColumnFormOfUse == null || this.definedColumnFormOfUse.length <= idx) {
                if (this.definedColumnFormOfUse == null) {
                    this.definedColumnFormOfUse = new int[(idx + 1) * 4];
                } else {
                    int[] n_definedColumnFormOfUse = new int[(idx + 1) * 4];
                    System.arraycopy(this.definedColumnFormOfUse, 0, n_definedColumnFormOfUse, 0, this.definedColumnFormOfUse.length);
                    this.definedColumnFormOfUse = n_definedColumnFormOfUse;
                }
            }
            this.definedColumnFormOfUse[idx] = form;
            if (this.accessors != null && idx < this.accessors.length && this.accessors[idx] != null) {
                this.accessors[idx].definedColumnSize = size;
                if (!(this.accessors[idx].internalType != 96 && this.accessors[idx].internalType != 1 || type != 1 && type != 12 || size > this.accessors[idx].oacmxl)) {
                    this.needToPrepareDefineBuffer = true;
                    this.columnsDefinedByUser = true;
                    this.accessors[idx].initForDataAccess(type, size, null);
                    this.accessors[idx].calculateSizeTmpByteArray();
                }
            }
            Object var20_21 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var22_28 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var22_27 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var22_26 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var22_25 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearDefines() throws SQLException {
        var1_1 = this.connection;
        synchronized (var1_1) {
            try {
                if (T4CStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        var3_2 = null;
                    }
                    catch (Throwable var2_4) {
                        var3_3 = null;
                        OracleLog.recursiveExit();
                        throw var2_4;
                    }
                    OracleLog.recursiveExit();
                }
                super.clearDefines();
                this.definedColumnType = null;
                this.definedColumnSize = null;
                this.definedColumnFormOfUse = null;
                this.t4Connection.all8.definesAccessors = null;
                var5_5 = null;
                if (T4CStatement.TRACE == false) return;
                ** GOTO lbl40
            }
            catch (Throwable var4_13) {
                var5_6 = null;
                if (T4CStatement.TRACE == false) throw var4_13;
                if (OracleLog.recursiveEnter() == false) throw var4_13;
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var7_9 = null;
                }
                catch (Throwable var6_12) {
                    var7_10 = null;
                    OracleLog.recursiveExit();
                    throw var6_12;
                }
lbl40:
                // 1 sources

                if (OracleLog.recursiveEnter() == false) return;
                try {}
                catch (Throwable var6_11) {
                    var7_8 = null;
                    OracleLog.recursiveExit();
                    throw var6_11;
                }
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var7_7 = null;
                OracleLog.recursiveExit();
                OracleLog.recursiveExit();
                throw var4_13;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDefineBuffersIfRequired(char[] tmpDefineChars, byte[] tmpDefineBytes, short[] tmpDefineIndicators, boolean isIndicatorsReused) throws SQLException {
        try {
            int i2;
            boolean growing;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tmpDefineChars) + ", " + OracleLog.argument(tmpDefineBytes) + ", " + OracleLog.argument(tmpDefineIndicators) + ", " + OracleLog.argument(isIndicatorsReused));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl = growing = this.rowPrefetchInLastFetch < this.rowPrefetch;
            if (isIndicatorsReused) {
                int i3;
                tmpDefineIndicators = new short[this.defineIndicators.length];
                int lengthIndex = this.accessors[0].lengthIndexLastRow;
                int indicatorIndex = this.accessors[0].indicatorIndexLastRow;
                int n2 = i3 = growing ? this.accessors.length : 1;
                while (growing ? i3 >= 1 : i3 <= this.accessors.length) {
                    int length = lengthIndex + this.rowPrefetchInLastFetch * i3 - 1;
                    int indicator = indicatorIndex + this.rowPrefetchInLastFetch * i3 - 1;
                    tmpDefineIndicators[indicator] = this.defineIndicators[indicator];
                    tmpDefineIndicators[length] = this.defineIndicators[length];
                    i3 += growing ? -1 : 1;
                }
            }
            int n3 = i2 = growing ? this.accessors.length - 1 : 0;
            while (growing ? i2 > -1 : i2 < this.accessors.length) {
                this.accessors[i2].saveDataFromOldDefineBuffers(tmpDefineBytes, tmpDefineChars, tmpDefineIndicators, this.rowPrefetchInLastFetch != -1 ? this.rowPrefetchInLastFetch : this.rowPrefetch, this.rowPrefetch);
                i2 += growing ? -1 : 1;
            }
            super.saveDefineBuffersIfRequired(tmpDefineChars, tmpDefineBytes, tmpDefineIndicators, isIndicatorsReused);
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void doSetSnapshotSCN(long scn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(scn));
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.inScn = scn;
            Object var6_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_9 = null;
            }
            catch (Throwable throwable2) {
                Object var8_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Accessor allocateAccessor(int internal_type, int external_type, int col_index, int max_len, short form, String typeName, boolean forBind) throws SQLException {
        T4CCharAccessor t4CCharAccessor;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(col_index) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(forBind));
                    t4CCharAccessor = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Accessor result = null;
            switch (internal_type) {
                case 96: {
                    result = new T4CCharAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 8: {
                    if (!forBind) {
                        result = new T4CLongAccessor(this, col_index, max_len, form, external_type, this.t4Connection.mare);
                        break;
                    }
                }
                case 1: {
                    result = new T4CVarcharAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 2: {
                    result = new T4CNumberAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 6: {
                    result = new T4CVarnumAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 24: {
                    if (!forBind) {
                        result = new T4CLongRawAccessor(this, col_index, max_len, form, external_type, this.t4Connection.mare);
                        break;
                    }
                }
                case 23: {
                    SQLException __ex__;
                    if (forBind && typeName != null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                                Object var11_12 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var11_13 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (forBind) {
                        result = new T4COutRawAccessor(this, max_len, form, external_type, this.t4Connection.mare);
                        break;
                    }
                    result = new T4CRawAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 100: {
                    result = new T4CBinaryFloatAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 101: {
                    result = new T4CBinaryDoubleAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 104: {
                    if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
                        result = new T4CVarcharAccessor(this, 18, form, external_type, forBind, this.t4Connection.mare);
                        result.definedColumnType = -8;
                        break;
                    }
                    result = new T4CRowidAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 102: {
                    result = new T4CResultSetAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 12: {
                    result = new T4CDateAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 113: {
                    result = new T4CBlobAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 112: {
                    result = new T4CClobAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 114: {
                    result = new T4CBfileAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 109: {
                    result = new T4CNamedTypeAccessor(this, typeName, form, external_type, forBind, this.t4Connection.mare);
                    result.initMetadata();
                    break;
                }
                case 111: {
                    result = new T4CRefTypeAccessor(this, typeName, form, external_type, forBind, this.t4Connection.mare);
                    result.initMetadata();
                    break;
                }
                case 180: {
                    result = new T4CTimestampAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 181: {
                    result = new T4CTimestamptzAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 231: {
                    result = new T4CTimestampltzAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 182: {
                    result = new T4CIntervalymAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 183: {
                    result = new T4CIntervaldsAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 995: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 89);
                            Object var13_15 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var13_16 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var15_18 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var15_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            t4CCharAccessor = result;
            Object var17_21 = null;
            if (!TRACE) return t4CCharAccessor;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var19_26 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var19_25 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return t4CCharAccessor;
        try {
            T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var19_23 = null;
            OracleLog.recursiveExit();
            return t4CCharAccessor;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDescribe(boolean includeNames) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(includeNames));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!this.isOpen) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 144);
                        Object var5_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            try {
                this.t4Connection.needLine();
                this.t4Connection.sendPiggyBackedMessages();
                this.t4Connection.describe.doODNY(this, 0, this.accessors, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals));
                this.accessors = this.t4Connection.describe.getAccessors();
                this.numberOfDefinePositions = this.t4Connection.describe.numuds;
                for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                    this.accessors[i2].initMetadata();
                }
            }
            catch (IOException ex) {
                ((T4CConnection)this.connection).handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.describedWithNames = true;
            this.described = true;
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeForDescribe() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.execute_for_describe");
            try {
                block29: {
                    try {
                        if (this.t4Connection.useFetchSizeWithLongColumn) {
                            this.doOall8(true, true, true, true, false);
                            break block29;
                        }
                        this.doOall8(true, true, false, true, this.definedColumnType != null);
                    }
                    catch (SQLException e2) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "oracle.jdbc.driver.T4CStatement.parseExecuteDescribe: throwing " + e2);
                                Object var4_10 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_11 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        throw e2;
                    }
                    catch (IOException e3) {
                        ((T4CConnection)this.connection).handleIOException(e3);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e3);
                                Object var6_13 = null;
                            }
                            catch (Throwable throwable) {
                                Object var6_14 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e3);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                Object var8_8 = null;
                this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
                this.validRows = this.t4Connection.all8.getNumRows();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
                this.validRows = this.t4Connection.all8.getNumRows();
                throw throwable;
            }
            this.needToParse = false;
            if (this.connection.calculateChecksum) {
                if (this.validRows > 0) {
                    this.calculateCheckSum();
                } else if (this.rowsProcessed > 0) {
                    long _checkSum;
                    this.checkSum = _checkSum = CRC64.updateChecksum(this.checkSum, this.rowsProcessed);
                }
            }
            if (this.definedColumnType == null) {
                this.implicitDefineForLobPrefetchDone = false;
            }
            this.aFetchWasDoneDuringDescribe = false;
            if (this.t4Connection.all8.aFetchWasDone) {
                this.aFetchWasDoneDuringDescribe = true;
                this.rowPrefetchInLastFetch = this.rowPrefetch;
            }
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                this.accessors[i2].initMetadata();
            }
            this.needToPrepareDefineBuffer = false;
            Object var10_17 = null;
        }
        catch (Throwable throwable) {
            Object var10_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_19 = null;
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeForRows(boolean executed_for_describe) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(executed_for_describe));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            try {
                try {
                    boolean sendDefine = false;
                    if (this.columnsDefinedByUser) {
                        this.needToPrepareDefineBuffer = false;
                    } else if (this.t4Connection.useLobPrefetch && this.accessors != null && this.defaultLobPrefetchSize != -1 && !this.implicitDefineForLobPrefetchDone && !this.aFetchWasDoneDuringDescribe && this.definedColumnType == null) {
                        boolean oneColumnIsALob = false;
                        int[] tempDefinedColumnType = new int[this.accessors.length];
                        int[] tempDefinedColumnSize = new int[this.accessors.length];
                        for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                            tempDefinedColumnType[i2] = this.getJDBCType(this.accessors[i2].internalType);
                            if (this.accessors[i2].internalType != 113 && this.accessors[i2].internalType != 112 && this.accessors[i2].internalType != 114) continue;
                            oneColumnIsALob = true;
                            this.accessors[i2].lobPrefetchSizeForThisColumn = this.defaultLobPrefetchSize;
                            tempDefinedColumnSize[i2] = this.defaultLobPrefetchSize;
                        }
                        if (oneColumnIsALob) {
                            this.definedColumnType = tempDefinedColumnType;
                            this.definedColumnSize = tempDefinedColumnSize;
                            sendDefine = true;
                        }
                    }
                    this.doOall8(this.needToParse, !executed_for_describe, true, false, sendDefine);
                    this.needToParse = false;
                    if (sendDefine) {
                        this.implicitDefineForLobPrefetchDone = true;
                    }
                    Object var8_12 = null;
                    this.validRows = this.t4Connection.all8.getNumRows();
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    this.validRows = this.t4Connection.all8.getNumRows();
                    throw throwable;
                }
            }
            catch (SQLException e2) {
                throw e2;
            }
            catch (IOException e3) {
                ((T4CConnection)this.connection).handleIOException(e3);
                this.calculateCheckSum();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e3);
                        Object var10_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var12_18 = null;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_22 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_20 = null;
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetch() throws SQLException {
        try {
            SQLException __ex__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.streamList != null) {
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        ((T4CConnection)this.connection).handleIOException(exc);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + exc);
                                Object var4_6 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_7 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            try {
                this.doOall8(false, false, true, false, false);
                this.validRows = this.t4Connection.all8.getNumRows();
            }
            catch (IOException ex) {
                ((T4CConnection)this.connection).handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        this.calculateCheckSum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void continueReadRow(int start) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(start));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            try {
                if (!this.connection.useFetchSizeWithLongColumn) {
                    T4C8Oall all8 = this.t4Connection.all8;
                    all8.continueReadRow(start, this);
                }
            }
            catch (IOException ex) {
                ((T4CConnection)this.connection).handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        Object var5_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (SQLException ea) {
                if (ea.getErrorCode() == DatabaseError.getVendorCode(110)) {
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
                }
                throw ea;
            }
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * Exception decompiling
     */
    void doClose() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeQuery() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.closeQuery");
            if (this.streamList != null) {
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        ((T4CConnection)this.connection).handleIOException(exc);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + exc);
                                Object var4_5 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    T4CStatement(PhysicalConnection conn, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(conn, 1, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.nbPostPonedColumns = new int[1];
            this.nbPostPonedColumns[0] = 0;
            this.indexOfPostPonedColumn = new int[1][3];
            this.t4Connection = (T4CConnection)conn;
            Object var7_7 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_9 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeCursorOnPlainStatement() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.cursorId != 0 && this.t4Connection.isLoggedOn()) {
                this.t4Connection.closeCursor(this.cursorId);
                this.setCursorId(0);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

