/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.T4CMAREngine;

class T4CPlsqlIndexTableAccessor
extends PlsqlIndexTableAccessor {
    T4CMAREngine mare;
    final int[] meta = new int[1];
    final int[] tmp = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    T4CPlsqlIndexTableAccessor(OracleStatement stmt, int elemSqlType, int elemInternalType, int elemMaxLen, int maxNumOfElements, short form, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, elemSqlType, elemInternalType, elemMaxLen, maxNumOfElements, form, forBind);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(elemSqlType) + ", " + OracleLog.argument(elemInternalType) + ", " + OracleLog.argument(elemMaxLen) + ", " + OracleLog.argument(maxNumOfElements) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(_mare));
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.calculateSizeTmpByteArray();
            this.mare = _mare;
            Object var12_12 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T4CPlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_16 = null;
            }
            catch (Throwable throwable2) {
                Object var14_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T4CPlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            byte[] buff = new byte[16000];
            this.mare.unmarshalCLR(buff, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        byte[] ibtBindBytes = this.statement.ibtBindBytes;
        char[] ibtBindChars = this.statement.ibtBindChars;
        short[] ibtBindIndicators = this.statement.ibtBindIndicators;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int nbOfElements = (int)this.mare.unmarshalUB4();
        ibtBindIndicators[this.ibtMetaIndex + 4] = (short)((nbOfElements & 0xFFFF0000) >> 16 & 0xFFFF);
        ibtBindIndicators[this.ibtMetaIndex + 5] = (short)(nbOfElements & 0xFFFF);
        if (this.elementInternalType == 9 || this.elementInternalType == 96 || this.elementInternalType == 1) {
            byte[] bytesBuffer = this.statement.tmpByteArray;
            for (int i2 = 0; i2 < nbOfElements; ++i2) {
                int tmpSpaceCharOffset = this.ibtValueIndex + this.elementMaxLen * i2;
                this.mare.unmarshalCLR(bytesBuffer, 0, this.meta);
                this.tmp[0] = this.meta[0];
                int nbOfCharsConverted = this.statement.connection.conversion.CHARBytesToJavaChars(bytesBuffer, 0, ibtBindChars, tmpSpaceCharOffset + 1, this.tmp, ibtBindChars.length - tmpSpaceCharOffset - 1);
                ibtBindChars[tmpSpaceCharOffset] = (char)(nbOfCharsConverted * 2);
                this.processIndicator(this.meta[0]);
                if (this.meta[0] == 0) {
                    ibtBindIndicators[this.ibtIndicatorIndex + i2] = -1;
                    ibtBindIndicators[this.ibtLengthIndex + i2] = 0;
                    continue;
                }
                ibtBindIndicators[this.ibtLengthIndex + i2] = (short)(this.meta[0] * 2);
                ibtBindIndicators[this.ibtIndicatorIndex + i2] = 0;
            }
        } else {
            for (int i3 = 0; i3 < nbOfElements; ++i3) {
                int tmpSpaceByteOffset = this.ibtValueIndex + this.elementMaxLen * i3;
                this.mare.unmarshalCLR(ibtBindBytes, tmpSpaceByteOffset + 1, this.meta);
                ibtBindBytes[tmpSpaceByteOffset] = (byte)this.meta[0];
                this.processIndicator(this.meta[0]);
                if (this.meta[0] == 0) {
                    ibtBindIndicators[this.ibtIndicatorIndex + i3] = -1;
                    ibtBindIndicators[this.ibtLengthIndex + i3] = 0;
                    continue;
                }
                ibtBindIndicators[this.ibtLengthIndex + i3] = (short)this.meta[0];
                ibtBindIndicators[this.ibtIndicatorIndex + i3] = 0;
            }
        }
        ++this.lastRowProcessed;
        return false;
    }

    void calculateSizeTmpByteArray() {
        int maxNbBytes;
        if ((this.elementInternalType == 9 || this.elementInternalType == 96 || this.elementInternalType == 1) && this.statement.sizeTmpByteArray < (maxNbBytes = this.ibtCharLength * this.statement.connection.conversion.cMaxCharSize / this.maxNumberOfElements)) {
            this.statement.sizeTmpByteArray = maxNbBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getString(int currentRow) throws SQLException {
        String string;
        try {
            String ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((ret = super.getString(currentRow)) != null && this.definedColumnSize > 0 && ret.length() > this.definedColumnSize) {
                ret = ret.substring(0, this.definedColumnSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = ret;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CPlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CPlsqlIndexTableAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

