/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4C8TTILobd;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.sql.Datum;

abstract class T4C8TTILob
extends T4CTTIfun {
    static final int KPLOB_READ = 2;
    static final int KPLOB_WRITE = 64;
    static final int KPLOB_WRITE_APPEND = 8192;
    static final int KPLOB_PAGE_SIZE = 16384;
    static final int KPLOB_FILE_OPEN = 256;
    static final int KPLOB_FILE_ISOPEN = 1024;
    static final int KPLOB_FILE_EXISTS = 2048;
    static final int KPLOB_FILE_CLOSE = 512;
    static final int KPLOB_OPEN = 32768;
    static final int KPLOB_CLOSE = 65536;
    static final int KPLOB_ISOPEN = 69632;
    static final int KPLOB_TMP_CREATE = 272;
    static final int KPLOB_TMP_FREE = 273;
    static final int KPLOB_GET_LEN = 1;
    static final int KPLOB_TRIM = 32;
    static final int KOKL_ORDONLY = 1;
    static final int KOKL_ORDWR = 2;
    static final int KOLF_ORDONLY = 11;
    static final int DTYCLOB = 112;
    static final int DTYBLOB = 113;
    byte[] sourceLobLocator = null;
    byte[] destinationLobLocator = null;
    long sourceOffset = 0L;
    long destinationOffset = 0L;
    int destinationLength = 0;
    short characterSet = 0;
    long lobamt = 0L;
    boolean lobnull = false;
    long lobops = 0L;
    int[] lobscn = null;
    int lobscnl = 0;
    boolean nullO2U = false;
    boolean sendLobamt = false;
    byte[] inBuffer = null;
    long inBufferOffset;
    long inBufferNumBytes;
    byte[] outBuffer = null;
    int offsetInOutBuffer = 0;
    int rowsProcessed = 0;
    long lobBytesRead = 0L;
    boolean littleEndianClob = false;
    T4C8TTILobd lobd = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4C8TTILob(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)96);
        this.lobd = new T4C8TTILobd(_conn);
    }

    long read(byte[] lobLocator, long offset, long _numBytes, byte[] outBuffer, int _offsetInOutBuffer) throws SQLException, IOException {
        this.initializeLobdef();
        this.lobops = 2L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = _numBytes;
        this.sendLobamt = true;
        this.outBuffer = outBuffer;
        this.offsetInOutBuffer = _offsetInOutBuffer;
        this.doRPC();
        return this.lobBytesRead;
    }

    long write(byte[] lobLocator, long offset, byte[] _inBuffer, long _inBufferOffset, long _numBytes) throws SQLException, IOException {
        long bytesWritten = 0L;
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = _numBytes;
        this.sendLobamt = true;
        this.inBuffer = _inBuffer;
        this.inBufferOffset = _inBufferOffset;
        this.inBufferNumBytes = _numBytes;
        this.doRPC();
        bytesWritten = this.lobamt;
        return bytesWritten;
    }

    long getLength(byte[] lobLocator) throws SQLException, IOException {
        long lobLength = 0L;
        this.initializeLobdef();
        this.lobops = 1L;
        this.sourceLobLocator = lobLocator;
        this.sendLobamt = true;
        this.doRPC();
        lobLength = this.lobamt;
        return lobLength;
    }

    long getChunkSize(byte[] lobLocator) throws SQLException, IOException {
        long chunkSize = 0L;
        this.initializeLobdef();
        this.lobops = 16384L;
        this.sourceLobLocator = lobLocator;
        this.sendLobamt = true;
        this.doRPC();
        chunkSize = this.lobamt;
        return chunkSize;
    }

    long trim(byte[] lobLocator, long newLength) throws SQLException, IOException {
        long newLengthfromServer = 0L;
        this.initializeLobdef();
        this.lobops = 32L;
        this.sourceLobLocator = lobLocator;
        this.lobamt = newLength;
        this.sendLobamt = true;
        this.doRPC();
        newLengthfromServer = this.lobamt;
        return newLengthfromServer;
    }

    abstract Datum createTemporaryLob(Connection var1, boolean var2, int var3) throws SQLException, IOException;

    void freeTemporaryLob(byte[] lobLocator) throws SQLException, IOException {
        this.initializeLobdef();
        this.lobops = 273L;
        this.sourceLobLocator = lobLocator;
        this.doRPC();
    }

    abstract boolean open(byte[] var1, int var2) throws SQLException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _open(byte[] lobLocator, int mode, int lobops) throws SQLException, IOException {
        boolean didOpen = false;
        if ((lobLocator[7] & 1) == 1 || (lobLocator[4] & 0x40) == 64) {
            if ((lobLocator[7] & 8) == 8) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4C8TTILob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 445);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 445);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            lobLocator[7] = (byte)(lobLocator[7] | 8);
            if (mode == 2) {
                lobLocator[7] = (byte)(lobLocator[7] | 0x10);
            }
            didOpen = true;
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = lobLocator;
            this.lobops = lobops;
            this.lobamt = mode;
            this.sendLobamt = true;
            this.doRPC();
            if (this.lobamt != 0L) {
                didOpen = true;
            }
        }
        return didOpen;
    }

    abstract boolean close(byte[] var1) throws SQLException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _close(byte[] lobLocator, int lobops) throws SQLException, IOException {
        boolean isClosed = true;
        if ((lobLocator[7] & 1) == 1 || (lobLocator[4] & 0x40) == 64) {
            if ((lobLocator[7] & 8) != 8) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4C8TTILob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 446);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 446);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            lobLocator[7] = (byte)(lobLocator[7] & 0xFFFFFFE7);
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = lobLocator;
            this.lobops = lobops;
            this.doRPC();
        }
        return isClosed;
    }

    abstract boolean isOpen(byte[] var1) throws SQLException, IOException;

    boolean _isOpen(byte[] lobLocator, int lobops) throws SQLException, IOException {
        boolean lobOpen = false;
        if ((lobLocator[7] & 1) == 1 || (lobLocator[4] & 0x40) == 64) {
            if ((lobLocator[7] & 8) == 8) {
                lobOpen = true;
            }
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = lobLocator;
            this.lobops = lobops;
            this.nullO2U = true;
            this.doRPC();
            lobOpen = this.lobnull;
        }
        return lobOpen;
    }

    void initializeLobdef() {
        this.sourceLobLocator = null;
        this.destinationLobLocator = null;
        this.sourceOffset = 0L;
        this.destinationOffset = 0L;
        this.destinationLength = 0;
        this.characterSet = 0;
        this.lobamt = 0L;
        this.lobnull = false;
        this.lobops = 0L;
        this.lobscn = null;
        this.lobscnl = 0;
        this.inBuffer = null;
        this.outBuffer = null;
        this.nullO2U = false;
        this.sendLobamt = false;
        this.littleEndianClob = false;
        this.lobBytesRead = 0L;
    }

    void marshal() throws IOException {
        int slength = 0;
        if (this.sourceLobLocator != null) {
            slength = this.sourceLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(slength);
        if (this.destinationLobLocator != null) {
            this.destinationLength = this.destinationLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.destinationLength);
        if (this.connection.getTTCVersion() >= 3) {
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalUB4(this.sourceOffset);
        }
        if (this.connection.getTTCVersion() >= 3) {
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalUB4(this.destinationOffset);
        }
        if (this.characterSet != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.sendLobamt && this.connection.getTTCVersion() < 3) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.nullO2U) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUB4(this.lobops);
        if (this.lobscnl != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.lobscnl);
        if (this.connection.getTTCVersion() >= 3) {
            this.meg.marshalSB8(this.sourceOffset);
            this.meg.marshalSB8(this.destinationOffset);
            if (this.sendLobamt) {
                this.meg.marshalPTR();
            } else {
                this.meg.marshalNULLPTR();
            }
            if (this.connection.getTTCVersion() >= 4) {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
        }
        if (this.sourceLobLocator != null) {
            this.meg.marshalB1Array(this.sourceLobLocator);
        }
        if (this.destinationLobLocator != null) {
            this.meg.marshalB1Array(this.destinationLobLocator);
        }
        if (this.characterSet != 0) {
            this.meg.marshalUB2(this.characterSet);
        }
        if (this.sendLobamt && this.connection.getTTCVersion() < 3) {
            this.meg.marshalUB4(this.lobamt);
        }
        if (this.lobscnl != 0) {
            for (int i2 = 0; i2 < this.lobscnl; ++i2) {
                this.meg.marshalUB4(this.lobscn[i2]);
            }
        }
        if (this.sendLobamt && this.connection.getTTCVersion() >= 3) {
            this.meg.marshalSB8(this.lobamt);
        }
        if (this.lobops == 64L) {
            this.marshalData();
        }
    }

    void marshalData() throws IOException {
        boolean useZeroCopyIO = this.connection.isZeroCopyIOEnabled() & (this.sourceLobLocator[7] & 0xFFFFFF80) != 0;
        boolean varWidthChar = false;
        if ((this.sourceLobLocator[6] & 0x80) == 128) {
            varWidthChar = true;
        }
        if (this.connection.versionNumber < 10101 && varWidthChar) {
            this.lobd.marshalClobUB2_For9iDB(this.inBuffer, this.inBufferOffset, this.inBufferNumBytes);
        } else {
            this.lobd.marshalLobData(this.inBuffer, this.inBufferOffset, this.inBufferNumBytes, useZeroCopyIO);
        }
    }

    void readLOBD() throws IOException, SQLException {
        boolean useZeroCopyIO = this.connection.isZeroCopyIOEnabled() & (this.sourceLobLocator[7] & 0xFFFFFF80) != 0;
        boolean varWidthChar = false;
        if ((this.sourceLobLocator[6] & 0x80) == 128) {
            varWidthChar = true;
        }
        this.lobBytesRead = this.connection.versionNumber < 10101 && varWidthChar ? this.lobd.unmarshalClobUB2_For9iDB(this.outBuffer, this.offsetInOutBuffer) : this.lobd.unmarshalLobData(this.outBuffer, this.offsetInOutBuffer, useZeroCopyIO);
    }

    void processError() throws SQLException {
        this.rowsProcessed = this.oer.getCurRowNumber();
        if (this.oer.getRetCode() != 1403) {
            this.oer.processError();
        }
    }

    void readRPA() throws SQLException, IOException {
        short isNull;
        int length;
        if (this.sourceLobLocator != null) {
            length = this.sourceLobLocator.length;
            this.meg.getNBytes(this.sourceLobLocator, 0, length);
        }
        if (this.destinationLobLocator != null) {
            length = this.meg.unmarshalSB2();
            this.destinationLobLocator = this.meg.unmarshalNBytes(length);
        }
        if (this.characterSet != 0) {
            this.characterSet = this.meg.unmarshalSB2();
        }
        if (this.sendLobamt) {
            this.lobamt = this.connection.getTTCVersion() >= 3 ? this.meg.unmarshalSB8() : this.meg.unmarshalUB4();
        }
        if (this.nullO2U && (isNull = (short)this.meg.unmarshalSB1()) != 0) {
            this.lobnull = true;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4C8TTILob"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

