/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class OracleResultSetImpl
extends BaseResultSet {
    PhysicalConnection connection;
    OracleStatement statement;
    boolean explicitly_closed;
    boolean m_emptyRset;
    boolean isServerCursorPeeked = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleResultSetImpl(PhysicalConnection c2, OracleStatement s2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(c2) + ", " + OracleLog.argument(s2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.connection = c2;
            this.statement = s2;
            this.close_statement_on_close = false;
            this.explicitly_closed = false;
            this.m_emptyRset = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23 + "getCursorName");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.internal_close(false);
                this.statement.totalRowsVisited = 0;
                this.statement.closeCursorOnPlainStatement();
                if (this.close_statement_on_close) {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.explicitly_closed = true;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.explicitly_closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10 + "wasNull");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "wasNull");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.statement.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9 + "wasNull");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "wasNull");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                boolean __result__ = this.statement.wasNullValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetMetaData oracleResultSetMetaData;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.explicitly_closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10 + "getMetaData");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getMetaData");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.statement.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9 + "getMetaData");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getMetaData");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (!this.statement.isOpen) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 144 + "getMetaData");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144, "getMetaData");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                OracleResultSetMetaData __result__ = new OracleResultSetMetaData(this.connection, this.statement);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleResultSetMetaData = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleResultSetMetaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            oracle.jdbc.internal.OracleStatement oracleStatement;
            try {
                oracle.jdbc.internal.OracleStatement __result__;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracle.jdbc.internal.OracleStatement oracleStatement2 = __result__ = this.statement.wrapper == null ? this.statement : this.statement.wrapper;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleStatement = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleStatement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleStatement getOracleStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleStatement __result__ = this.statement;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleStatement = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleStatement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            PhysicalConnection l_connection;
            boolean result;
            block70: {
                block67: {
                    boolean bl;
                    try {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        result = true;
                        this.isServerCursorPeeked = true;
                        l_connection = this.statement.connection;
                        if (this.explicitly_closed) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10 + "next");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "next");
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        if (l_connection == null || l_connection.lifecycle != 1) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8 + "next");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "next");
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        if (this.statement.closed) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9 + "next");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "next");
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        if (this.statement.sqlKind.isPlsqlOrCall()) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 166 + "next");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 166, "next");
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleResultSetImpl.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "closed=" + this.closed + ", statement.currentRow=" + this.statement.currentRow + ", statement.totalRowsVisited=" + this.statement.totalRowsVisited + ", statement.maxRows=" + this.statement.maxRows + ", statement.validRows=" + this.statement.validRows + ", statement.gotLastBatch=" + this.statement.gotLastBatch);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (!this.closed) break block67;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        bl = false;
                        if (!TRACE) return bl;
                    }
                    catch (Throwable throwable) {
                        if (!TRACE) throw throwable;
                        if (!OracleLog.recursiveEnter()) throw throwable;
                        try {
                            OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            throw throwable;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (!OracleLog.recursiveEnter()) return bl;
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    return bl;
                }
                ++this.statement.currentRow;
                ++this.statement.totalRowsVisited;
                if (this.statement.maxRows == 0 || this.statement.totalRowsVisited <= this.statement.maxRows) break block70;
                this.internal_close(false);
                --this.statement.currentRow;
                this.statement.totalRowsVisited = 0;
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 275);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                if (!TRACE) return bl;
                if (!OracleLog.recursiveEnter()) return bl;
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return bl;
            }
            if (this.statement.currentRow >= this.statement.validRows) {
                result = this.close_or_fetch_from_next(false);
            }
            if (result && l_connection.useFetchSizeWithLongColumn) {
                this.statement.reopenStreams();
            }
            if (!result) {
                --this.statement.currentRow;
                this.statement.totalRowsVisited = 0;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = result;
            if (!TRACE) return bl;
            if (!OracleLog.recursiveEnter()) return bl;
            try {
                OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean close_or_fetch_from_next(boolean close) throws SQLException {
        if (close) {
            this.internal_close(false);
            return false;
        }
        if (this.statement.gotLastBatch) {
            this.internal_close(false);
            return false;
        }
        this.statement.check_row_prefetch_changed();
        PhysicalConnection l_connection = this.statement.connection;
        if (l_connection.protocolId == 3) {
            this.sqlWarning = null;
        } else {
            if (this.statement.streamList != null) {
                while (this.statement.nextStream != null) {
                    try {
                        this.statement.nextStream.close();
                    }
                    catch (IOException exc) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + exc);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.statement.nextStream = this.statement.nextStream.nextStream;
                }
            }
            this.clearWarnings();
            l_connection.registerHeartbeat();
            l_connection.needLine();
        }
        PhysicalConnection physicalConnection = l_connection;
        synchronized (physicalConnection) {
            try {
                this.statement.cancelLock.enterExecuting();
                this.statement.fetch();
            }
            finally {
                this.statement.cancelLock.exitExecuting();
            }
        }
        if (this.statement.validRows == 0) {
            this.internal_close(false);
            return false;
        }
        this.statement.currentRow = 0;
        this.statement.checkValidRowsStatus();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.explicitly_closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.statement.connection.protocolId == 3 && this.statement.serverCursor) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl2 = __result__ = !this.isEmptyResultSet() && this.statement.currentRow == -1 && !this.closed;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.explicitly_closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl2 = __result__ = !this.isEmptyResultSet() && this.closed;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.explicitly_closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl2 = __result__ = this.getRow() == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.explicitly_closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 75 + "isLast");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "isLast");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.explicitly_closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int __result__ = this.statement.totalRowsVisited;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ARRAY __result__ = this.getARRAY(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                aRRAY = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                BigDecimal __result__ = this.statement.accessors[columnIndex - 1].getBigDecimal(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bigDecimal = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int columnIndex, int y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(y));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                BigDecimal __result__ = this.statement.accessors[columnIndex - 1].getBigDecimal(current_row, y);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bigDecimal = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BLOB __result__ = this.getBLOB(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bLOB = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                boolean __result__ = this.statement.accessors[columnIndex - 1].getBoolean(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte by;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                byte __result__ = this.statement.accessors[columnIndex - 1].getByte(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                by = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte[] byArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                byte[] __result__ = this.statement.accessors[columnIndex - 1].getBytes(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byArray = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CLOB __result__ = this.getCLOB(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cLOB = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                Date __result__ = this.statement.accessors[columnIndex - 1].getDate(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                date = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int columnIndex, Calendar y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(y));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                Date __result__ = this.statement.accessors[columnIndex - 1].getDate(current_row, y);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                date = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            double d2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                double __result__ = this.statement.accessors[columnIndex - 1].getDouble(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                d2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            float f2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                float __result__ = this.statement.accessors[columnIndex - 1].getFloat(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                f2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                int __result__ = this.statement.accessors[columnIndex - 1].getInt(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long l2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                long __result__ = this.statement.accessors[columnIndex - 1].getLong(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                l2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                Object __result__ = this.statement.accessors[columnIndex - 1].getObject(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int columnIndex, Map y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(y));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                Object __result__ = this.statement.accessors[columnIndex - 1].getObject(current_row, y);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                REF __result__ = this.getREF(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rEF = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            short s2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                short __result__ = this.statement.accessors[columnIndex - 1].getShort(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                s2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            String string;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                String __result__ = this.statement.accessors[columnIndex - 1].getString(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                string = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                Time __result__ = this.statement.accessors[columnIndex - 1].getTime(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                time = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int columnIndex, Calendar y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(y));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                Time __result__ = this.statement.accessors[columnIndex - 1].getTime(current_row, y);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                time = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                Timestamp __result__ = this.statement.accessors[columnIndex - 1].getTimestamp(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                timestamp = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int columnIndex, Calendar y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(y));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                Timestamp __result__ = this.statement.accessors[columnIndex - 1].getTimestamp(current_row, y);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                timestamp = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            URL uRL;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                URL __result__ = this.statement.accessors[columnIndex - 1].getURL(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                uRL = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY getARRAY(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                ARRAY __result__ = this.statement.accessors[columnIndex - 1].getARRAY(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                aRRAY = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBFILE(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                BFILE __result__ = this.statement.accessors[columnIndex - 1].getBFILE(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bFILE = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBfile(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BFILE __result__ = this.getBFILE(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bFILE = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLOB getBLOB(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                BLOB __result__ = this.statement.accessors[columnIndex - 1].getBLOB(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bLOB = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHAR getCHAR(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CHAR cHAR;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                CHAR __result__ = this.statement.accessors[columnIndex - 1].getCHAR(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cHAR = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cHAR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB getCLOB(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                CLOB __result__ = this.statement.accessors[columnIndex - 1].getCLOB(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cLOB = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ResultSet resultSet;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                ResultSet __result__ = this.statement.accessors[columnIndex - 1].getCursor(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                resultSet = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CustomDatum customDatum;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(y));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                CustomDatum __result__ = this.statement.accessors[columnIndex - 1].getCustomDatum(current_row, y);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                customDatum = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DATE getDATE(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            DATE dATE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                DATE __result__ = this.statement.accessors[columnIndex - 1].getDATE(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                dATE = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return dATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            INTERVALDS iNTERVALDS;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                INTERVALDS __result__ = this.statement.accessors[columnIndex - 1].getINTERVALDS(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                iNTERVALDS = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return iNTERVALDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            INTERVALYM iNTERVALYM;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                INTERVALYM __result__ = this.statement.accessors[columnIndex - 1].getINTERVALYM(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                iNTERVALYM = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return iNTERVALYM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NUMBER getNUMBER(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            NUMBER nUMBER;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                NUMBER __result__ = this.statement.accessors[columnIndex - 1].getNUMBER(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                nUMBER = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return nUMBER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OPAQUE oPAQUE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                OPAQUE __result__ = this.statement.accessors[columnIndex - 1].getOPAQUE(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oPAQUE = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oPAQUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum getOracleObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                Datum __result__ = this.statement.accessors[columnIndex - 1].getOracleObject(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                datum = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return datum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORAData getORAData(int columnIndex, ORADataFactory y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ORAData oRAData;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(y));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                ORAData __result__ = this.statement.accessors[columnIndex - 1].getORAData(current_row, y);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oRAData = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oRAData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int columnIndex, OracleDataFactory y) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(y));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                Object __result__ = this.statement.accessors[columnIndex - 1].getObject(current_row, y);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW getRAW(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            RAW rAW;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                RAW __result__ = this.statement.accessors[columnIndex - 1].getRAW(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rAW = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rAW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF getREF(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                REF __result__ = this.statement.accessors[columnIndex - 1].getREF(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rEF = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID getROWID(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ROWID rOWID;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                ROWID __result__ = this.statement.accessors[columnIndex - 1].getROWID(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rOWID = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rOWID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT getSTRUCT(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            STRUCT sTRUCT;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                STRUCT __result__ = this.statement.accessors[columnIndex - 1].getSTRUCT(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                sTRUCT = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return sTRUCT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMPLTZ tIMESTAMPLTZ;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                TIMESTAMPLTZ __result__ = this.statement.accessors[columnIndex - 1].getTIMESTAMPLTZ(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                tIMESTAMPLTZ = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return tIMESTAMPLTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMPTZ tIMESTAMPTZ;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                TIMESTAMPTZ __result__ = this.statement.accessors[columnIndex - 1].getTIMESTAMPTZ(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                tIMESTAMPTZ = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return tIMESTAMPTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMP tIMESTAMP;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                TIMESTAMP __result__ = this.statement.accessors[columnIndex - 1].getTIMESTAMP(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                tIMESTAMP = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return tIMESTAMP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                InputStream __result__ = this.statement.accessors[columnIndex - 1].getAsciiStream(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                InputStream __result__ = this.statement.accessors[columnIndex - 1].getBinaryStream(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Reader reader;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                Reader __result__ = this.statement.accessors[columnIndex - 1].getCharacterStream(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                reader = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                InputStream __result__ = this.statement.accessors[columnIndex - 1].getUnicodeStream(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSet.AuthorizationIndicator authorizationIndicator;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.statement.accessors[columnIndex - 1].getAuthorizationIndicator(current_row)));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                authorizationIndicator = this.statement.accessors[columnIndex - 1].getAuthorizationIndicator(current_row);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return authorizationIndicator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] privateGetBytes(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte[] byArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numberOfDefinePositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int current_row = this.statement.currentRow;
                if (current_row < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.statement.lastIndex = columnIndex;
                if (this.statement.streamList != null) {
                    this.statement.closeUsedStreams(columnIndex);
                }
                byte[] __result__ = this.statement.accessors[columnIndex - 1].privateGetBytes(current_row);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byArray = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int rows) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rows));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.statement.setPrefetchInternal(rows, false, false);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int __result__ = this.statement.getPrefetchInternal(false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internal_close(boolean from_prepare_for_new_result) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(from_prepare_for_new_result));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            super.close();
            if (this.statement.gotLastBatch && this.statement.validRows == 0) {
                this.m_emptyRset = true;
            }
            PhysicalConnection l_connection = this.statement.connection;
            try {
                l_connection.registerHeartbeat();
                l_connection.needLine();
                PhysicalConnection physicalConnection = l_connection;
                synchronized (physicalConnection) {
                    this.statement.closeQuery();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.statement.endOfResultSet(from_prepare_for_new_result);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String columnName) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int __result__ = this.statement.getColumnIndex(columnName);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmptyResultSet() throws SQLException {
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.statement != null && !this.statement.closed && this.statement.serverCursor && this.statement.connection.protocolId != 3 && !this.isServerCursorPeeked && !this.closed) {
                this.close_or_fetch_from_next(false);
                if (this.statement.validRows > 0) {
                    this.statement.currentRow = -1;
                } else {
                    this.m_emptyRset = true;
                }
                this.isServerCursorPeeked = true;
            }
            boolean bl = __result__ = this.m_emptyRset || !this.m_emptyRset && this.statement.gotLastBatch && this.statement.validRows == 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getValidRows() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.statement.validRows);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.statement.validRows;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PhysicalConnection physicalConnection = this.connection;
            return physicalConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetImpl.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleResultSetImpl"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

