/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.EventListener;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQNotificationListener;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.XSEventListener;

class NTFEventListener {
    private final AQNotificationListener aqlistener;
    private final DatabaseChangeListener dcnlistener;
    private final XSEventListener xslistener;
    private Executor executor = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFEventListener(DatabaseChangeListener _listener) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_listener));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (_listener == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFEventListener.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 246);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.dcnlistener = _listener;
            this.aqlistener = null;
            this.xslistener = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFEventListener(AQNotificationListener _listener) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_listener));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (_listener == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFEventListener.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 246);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.aqlistener = _listener;
            this.dcnlistener = null;
            this.xslistener = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFEventListener(XSEventListener _listener) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_listener));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (_listener == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFEventListener.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 246);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.aqlistener = null;
            this.dcnlistener = null;
            this.xslistener = _listener;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExecutor(Executor _executor) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_executor));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.executor = _executor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Executor getExecutor() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.executor);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Executor executor = this.executor;
            return executor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventListener getListener() {
        try {
            EventListener listener;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((listener = this.dcnlistener) == null) {
                listener = this.aqlistener;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + listener);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            EventListener eventListener = listener;
            return eventListener;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AQNotificationListener getAQListener() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.aqlistener);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            AQNotificationListener aQNotificationListener = this.aqlistener;
            return aQNotificationListener;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseChangeListener getDCNListener() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.dcnlistener);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DatabaseChangeListener databaseChangeListener = this.dcnlistener;
            return databaseChangeListener;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XSEventListener getXSEventListener() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.xslistener);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            XSEventListener xSEventListener = this.xslistener;
            return xSEventListener;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFEventListener"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

