/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.StringUtil;
import com.crystaldecisions.reports.common.value.DTSParseStrategy;
import java.util.Locale;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EnglishParseStrategy
implements DTSParseStrategy {
    private final Locale case;
    private final boolean char;
    private final boolean goto;
    private final boolean else;

    public EnglishParseStrategy(Locale locale) {
        this.case = locale;
        this.char = !locale.equals(Locale.US) && !StringUtil.equalsIgnoreCaseEng(locale.getCountry(), "ZA") && !StringUtil.equalsIgnoreCaseEng(locale.getCountry(), "PH") && !StringUtil.equalsIgnoreCaseEng(locale.getCountry(), "ZW");
        this.else = this.goto = !StringUtil.equalsIgnoreCaseEng(locale.getCountry(), "ZA");
    }

    public Locale getLocale() {
        return this.case;
    }

    public String getDelimiters() {
        return " ,./-:";
    }

    public boolean isValidDateDelimiter(String string) {
        return string.equals(" ") || string.equals(",") || string.equals(".") || string.equals("/") || string.equals("-");
    }

    public boolean isValidTimeDelimiter(String string) {
        return string.equals(":") || string.equals(" ") || string.equals(".");
    }

    public boolean preferDayBeforeMonth() {
        return this.char;
    }

    public boolean preferDayBeforeYear() {
        return this.goto;
    }

    public boolean preferMonthBeforeYear() {
        return this.else;
    }

    public boolean canIgnore(String string) {
        return false;
    }
}

