/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.filemanagement.BufferedRandomAccessFile;
import com.crystaldecisions.reports.common.filemanagement.DataRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.RandomAccessStorage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DataPump {
    private static final int do = 8192;
    private static final int for = 0x800000;
    private static final int if = 65536;
    private static ThreadLocal<byte[]> a = new ThreadLocal<byte[]>(){

        @Override
        protected synchronized byte[] initialValue() {
            return new byte[8192];
        }
    };

    private DataPump() {
    }

    private static byte[] a() {
        return a.get();
    }

    public static int pump(Source source, Sink sink, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Number of bytes cannot be negative.");
        }
        if (n <= 0x800000) {
            return DataPump.a(source, sink, n);
        }
        long l = n;
        return (int)DataPump.a(source, sink, l);
    }

    public static long pump(Source source, Sink sink, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Number of bytes cannot be negative.");
        }
        if (l <= 0x800000L) {
            return DataPump.a(source, sink, (int)l);
        }
        return DataPump.a(source, sink, l);
    }

    private static int a(Source source, Sink sink, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        byte[] byArray = DataPump.a();
        for (n3 = n; n3 > 0 && (n4 = source.read(byArray, n2 = Math.min(byArray.length, n3))) > 0; n3 -= n4) {
            sink.write(byArray, n4);
        }
        return n - n3;
    }

    private static long a(Source source, Sink sink, long l) throws IOException {
        int n;
        long l2;
        int n2;
        byte[] byArray = new byte[65536];
        for (l2 = l; l2 > 0L && (n2 = source.read(byArray, n = (long)byArray.length < l2 ? byArray.length : (int)l2)) > 0; l2 -= (long)n2) {
            sink.write(byArray, n2);
        }
        return l - l2;
    }

    public static long pump(Source source, Sink sink) throws IOException {
        int n;
        byte[] byArray = DataPump.a();
        long l = 0L;
        while ((n = source.read(byArray, byArray.length)) > 0) {
            sink.write(byArray, n);
            l += (long)n;
        }
        return l;
    }

    public static Source createSource(final InputStream inputStream) {
        return new Source(){

            public int read(byte[] byArray, int n) throws IOException {
                return inputStream.read(byArray, 0, n);
            }
        };
    }

    public static Source createSource(final byte[] byArray) {
        return new Source(){
            int curPos = 0;

            public int read(byte[] byArray2, int n) throws IOException {
                int n2 = byArray.length - this.curPos;
                if (n2 < n) {
                    return -1;
                }
                System.arraycopy(byArray, this.curPos, byArray2, 0, n);
                this.curPos += n;
                return n;
            }
        };
    }

    public static Source createSource(final ByteBuffer byteBuffer) {
        return new Source(){
            int curPos = 0;

            public int read(byte[] byArray, int n) throws IOException {
                int n2 = byteBuffer.capacity() - this.curPos;
                if (n2 < n) {
                    return -1;
                }
                byteBuffer.get(byArray, 0, n);
                this.curPos += n;
                return n;
            }
        };
    }

    public static Source createSource(final RandomAccessFile randomAccessFile) {
        return new Source(){

            public int read(byte[] byArray, int n) throws IOException {
                return randomAccessFile.read(byArray, 0, n);
            }
        };
    }

    public static Source createSource(final RandomAccessStorage randomAccessStorage) {
        return new Source(){

            public int read(byte[] byArray, int n) throws IOException {
                return randomAccessStorage.read(byArray, 0, n);
            }
        };
    }

    public static Source createSource(DataRandomAccessStorage dataRandomAccessStorage) {
        return DataPump.createSource((RandomAccessStorage)dataRandomAccessStorage);
    }

    public static Source createSource(final BufferedRandomAccessFile bufferedRandomAccessFile) {
        return new Source(){

            public int read(byte[] byArray, int n) throws IOException {
                bufferedRandomAccessFile.readFully(byArray, 0, n);
                return n;
            }
        };
    }

    public static Source createSource(final DataInput dataInput) {
        return new Source(){

            public int read(byte[] byArray, int n) throws IOException {
                dataInput.readFully(byArray, 0, n);
                return n;
            }
        };
    }

    public static Sink createSink(final OutputStream outputStream) {
        return new Sink(){

            public void write(byte[] byArray, int n) throws IOException {
                outputStream.write(byArray, 0, n);
            }
        };
    }

    public static Sink createSink(final byte[] byArray) {
        return new Sink(){
            int curPos = 0;

            public void write(byte[] byArray2, int n) throws IOException {
                int n2 = byArray.length - this.curPos;
                if (n2 < n) {
                    throw new EOFException();
                }
                System.arraycopy(byArray2, 0, byArray, this.curPos, n);
                this.curPos += n;
            }
        };
    }

    public static Sink createSink(final ByteBuffer byteBuffer) {
        return new Sink(){
            int curPos = 0;

            public void write(byte[] byArray, int n) throws IOException {
                int n2 = byteBuffer.capacity() - this.curPos;
                if (n2 < n) {
                    throw new EOFException();
                }
                byteBuffer.put(byArray, 0, n);
                this.curPos += n;
            }
        };
    }

    public static Sink createSink(final RandomAccessFile randomAccessFile) {
        return new Sink(){

            public void write(byte[] byArray, int n) throws IOException {
                randomAccessFile.write(byArray, 0, n);
            }
        };
    }

    public static Sink createSink(final RandomAccessStorage randomAccessStorage) {
        return new Sink(){

            public void write(byte[] byArray, int n) throws IOException {
                randomAccessStorage.write(byArray, 0, n);
            }
        };
    }

    public static Sink createSink(DataRandomAccessStorage dataRandomAccessStorage) {
        return DataPump.createSink((RandomAccessStorage)dataRandomAccessStorage);
    }

    public static Sink createSink(final BufferedRandomAccessFile bufferedRandomAccessFile) {
        return new Sink(){

            public void write(byte[] byArray, int n) throws IOException {
                bufferedRandomAccessFile.write(byArray, 0, n);
            }
        };
    }

    public static Sink createSink(final DataOutput dataOutput) {
        return new Sink(){

            public void write(byte[] byArray, int n) throws IOException {
                dataOutput.write(byArray, 0, n);
            }
        };
    }

    public static int pump(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        return DataPump.pump(DataPump.createSource(inputStream), DataPump.createSink(outputStream), n);
    }

    public static int pump(InputStream inputStream, byte[] byArray, int n) throws IOException {
        return DataPump.pump(DataPump.createSource(inputStream), DataPump.createSink(byArray), n);
    }

    public static int pump(RandomAccessStorage randomAccessStorage, byte[] byArray, int n) throws IOException {
        return DataPump.pump(DataPump.createSource(randomAccessStorage), DataPump.createSink(byArray), n);
    }

    public static int pump(InputStream inputStream, ByteBuffer byteBuffer, int n) throws IOException {
        return DataPump.pump(DataPump.createSource(inputStream), DataPump.createSink(byteBuffer), n);
    }

    public static int pump(InputStream inputStream, RandomAccessFile randomAccessFile, int n) throws IOException {
        return DataPump.pump(DataPump.createSource(inputStream), DataPump.createSink(randomAccessFile), n);
    }

    public static int pump(InputStream inputStream, BufferedRandomAccessFile bufferedRandomAccessFile, int n) throws IOException {
        return DataPump.pump(DataPump.createSource(inputStream), DataPump.createSink(bufferedRandomAccessFile), n);
    }

    public static long pump(InputStream inputStream, BufferedRandomAccessFile bufferedRandomAccessFile) throws IOException {
        return DataPump.pump(DataPump.createSource(inputStream), DataPump.createSink(bufferedRandomAccessFile));
    }

    public static int pump(RandomAccessFile randomAccessFile, OutputStream outputStream, int n) throws IOException {
        return DataPump.pump(DataPump.createSource(randomAccessFile), DataPump.createSink(outputStream), n);
    }

    public static int pump(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, int n) throws IOException {
        return DataPump.pump(DataPump.createSource(randomAccessFile), DataPump.createSink(randomAccessFile2), n);
    }

    public static long pump(InputStream inputStream, OutputStream outputStream) throws IOException {
        return DataPump.pump(DataPump.createSource(inputStream), DataPump.createSink(outputStream));
    }

    public static long pump(InputStream inputStream, RandomAccessFile randomAccessFile) throws IOException {
        return DataPump.pump(DataPump.createSource(inputStream), DataPump.createSink(randomAccessFile));
    }

    public static long pump(RandomAccessFile randomAccessFile, OutputStream outputStream) throws IOException {
        return DataPump.pump(DataPump.createSource(randomAccessFile), DataPump.createSink(outputStream));
    }

    public static long pump(RandomAccessStorage randomAccessStorage, RandomAccessStorage randomAccessStorage2) throws IOException {
        return DataPump.pump(DataPump.createSource(randomAccessStorage), DataPump.createSink(randomAccessStorage2));
    }

    public static long pump(RandomAccessStorage randomAccessStorage, RandomAccessStorage randomAccessStorage2, long l) throws IOException {
        return DataPump.pump(DataPump.createSource(randomAccessStorage), DataPump.createSink(randomAccessStorage2), l);
    }

    public static long pump(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, long l) throws IOException {
        return DataPump.pump(DataPump.createSource(randomAccessFile), DataPump.createSink(randomAccessFile2), l);
    }

    public static long pumpDirect(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, long l) throws IOException {
        long l2 = randomAccessFile.getFilePointer();
        long l3 = randomAccessFile2.getFilePointer();
        long l4 = randomAccessFile2.getChannel().transferFrom(randomAccessFile.getChannel(), l2, l);
        randomAccessFile2.seek(l3 + l4);
        assert (l2 + l4 == randomAccessFile.getFilePointer());
        return l4;
    }

    public static interface Sink {
        public void write(byte[] var1, int var2) throws IOException;
    }

    public static interface Source {
        public int read(byte[] var1, int var2) throws IOException;
    }
}

