/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.collection;

import com.crystaldecisions.reports.common.collection.ICollectionBase;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionBase<T>
extends ArrayList<T>
implements ICollectionBase<T> {
    protected boolean readOnly = false;

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : this) {
            stringBuilder.append("[" + e + "]");
        }
        return stringBuilder.toString();
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    protected abstract boolean isValidObjectType(Object var1);

    protected boolean canRemoveItem(Object object) {
        return true;
    }

    @Override
    public boolean add(T t) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot modify a read-only collection.");
        }
        return this.addObject(t);
    }

    public boolean addObject(T t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isValidObjectType(t)) {
            throw new ClassCastException();
        }
        return super.add(t);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot modify a read-only collection.");
        }
        return super.addAll(collection);
    }

    @Override
    public void clear() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot modify a read-only collection.");
        }
        super.clear();
    }

    @Override
    public T get(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int n) {
        Object e = this.get(n);
        if (!this.remove(e)) {
            return null;
        }
        return (T)e;
    }

    @Override
    public boolean remove(Object object) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot modify a read-only collection.");
        }
        if (!this.canRemoveItem(object)) {
            throw new UnsupportedOperationException("This object cannot be removed from the collection.");
        }
        int n = super.indexOf(object);
        if (n == -1) {
            return false;
        }
        super.remove(n);
        return true;
    }

    @Override
    public T removeByName(String string) {
        throw new UnsupportedOperationException();
    }
}

