/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CrystalResources {
    private final ResourceBundle a;
    private final Map<String, MessageFormat> if = new ConcurrentHashMap<String, MessageFormat>();

    protected CrystalResources(ResourceBundle resourceBundle) {
        this.a = resourceBundle;
    }

    public String loadString(String string) {
        try {
            return this.a.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            String string2 = "Failed to load the resource '" + string + "' from the bundle " + this.a + ".";
            Logger logger = Logger.getLogger((String)"com.crystaldecisions.reports.common");
            logger.error((Object)string2, (Throwable)missingResourceException);
            return string;
        }
    }

    public Enumeration<String> getKeys() {
        return this.a.getKeys();
    }

    public String loadMessage(String string, int n) {
        return this.loadMessage(string, new Object[]{n});
    }

    public String loadMessage(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return this.loadString(string);
        }
        MessageFormat messageFormat = this.if.get(string);
        if (messageFormat == null) {
            String string2 = this.loadString(string);
            if (string2 == null || string2.length() == 0) {
                CrystalAssert.ASSERT(false, "Failed to load a valid resource string");
                return string;
            }
            messageFormat = new MessageFormat(this.loadString(string));
            this.if.put(string, messageFormat);
        }
        return messageFormat.format(objectArray);
    }
}

