/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.window;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.DataRange;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataRange;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataWindow;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.window.MeasureRange;
import com.businessobjects.visualization.window.WindowSize;
import java.util.ArrayList;
import java.util.Iterator;

public final class DataWindow
implements IXMLDelegator {
    private final DataRange[] dataRangeByAxis_;
    private final MeasureRange measureRange_;

    private DataWindow(DataRange[] dataRangeByAxisList, MeasureRange measureRange) {
        if (dataRangeByAxisList == null || dataRangeByAxisList.length == 0) {
            this.dataRangeByAxis_ = new DataRange[]{DataRange.FULL_RANGE, DataRange.FULL_RANGE, DataRange.FULL_RANGE};
        } else {
            int length = dataRangeByAxisList.length;
            this.dataRangeByAxis_ = new DataRange[length];
            System.arraycopy(dataRangeByAxisList, 0, this.dataRangeByAxis_, 0, length);
        }
        this.measureRange_ = measureRange == null ? MeasureRange.FULL_RANGE : measureRange;
    }

    private DataWindow(int[] windowStartIndexes, int measureStartIndex, WindowSize windowSize) {
        if (windowStartIndexes == null || windowSize == null || windowStartIndexes.length != windowSize.getCountByAxis().length) {
            throw new VisualizationRuntimeException("VIZ_00066_ERR_INVALID_PARAMETERS_F");
        }
        this.dataRangeByAxis_ = new DataRange[windowStartIndexes.length];
        for (int i = 0; i < windowStartIndexes.length; ++i) {
            if (windowSize.getCountByAxis()[i] == -1) {
                throw new VisualizationRuntimeException("VIZ_00138_ERR_CANNOT_SET_WINDOW__S", new Object[]{new Integer(i)});
            }
            this.dataRangeByAxis_[i] = windowSize.getCountByAxis()[i] == -3 ? DataRange.FULL_RANGE : new DataRange(windowStartIndexes[i], windowStartIndexes[i] + windowSize.getCountByAxis()[i] - 1);
        }
        this.measureRange_ = windowSize.getMeasureCount() == -3 ? MeasureRange.FULL_RANGE : new MeasureRange(measureStartIndex, measureStartIndex + windowSize.getMeasureCount() - 1, windowSize.getDataset());
    }

    public DataWindow(XMLDataWindow xmlDataWindow, SerializationHelper sh, DatasetDescriptor dataset) {
        Iterator iter = xmlDataWindow.m_list_dataRangeList.iterator();
        ArrayList<DataRange> dataRangeList = new ArrayList<DataRange>();
        while (iter.hasNext()) {
            dataRangeList.add(new DataRange((XMLDataRange)iter.next(), sh));
        }
        this.dataRangeByAxis_ = dataRangeList.toArray(new DataRange[0]);
        this.measureRange_ = xmlDataWindow.m_measureRange.m_a_lower == MeasureRange.FULL_RANGE.getLower() && xmlDataWindow.m_measureRange.m_a_upper == MeasureRange.FULL_RANGE.getUpper() ? MeasureRange.FULL_RANGE : new MeasureRange(xmlDataWindow.m_measureRange.m_a_lower, xmlDataWindow.m_measureRange.m_a_upper, dataset);
    }

    public WindowSize getWindowSize() {
        int[] axisWindowSize = new int[this.dataRangeByAxis_.length];
        for (int i = 0; i < this.dataRangeByAxis_.length; ++i) {
            axisWindowSize[i] = this.dataRangeByAxis_[i].equals(DataRange.FULL_RANGE) ? -3 : this.dataRangeByAxis_[i].getUpper() - this.dataRangeByAxis_[i].getLower() + 1;
        }
        int measureCount = 0;
        DatasetDescriptor dd = null;
        if (!this.measureRange_.equals(MeasureRange.FULL_RANGE)) {
            measureCount = this.measureRange_.getUpper() - this.measureRange_.getLower() + 1;
            dd = this.measureRange_.getDataset();
        } else {
            measureCount = -3;
        }
        return new WindowSize(axisWindowSize, measureCount, dd);
    }

    public int[] getWindowStartIndexes() {
        int[] windowStartIndexes = new int[this.dataRangeByAxis_.length];
        for (int i = 0; i < this.dataRangeByAxis_.length; ++i) {
            windowStartIndexes[i] = this.dataRangeByAxis_[i].getLower();
        }
        return windowStartIndexes;
    }

    public DataRange[] getDataRangeByAxis() {
        return this.dataRangeByAxis_;
    }

    public MeasureRange getMeasureRange() {
        return this.measureRange_;
    }

    public int getMeasuresStartIndex() {
        if (!this.measureRange_.equals(MeasureRange.FULL_RANGE)) {
            return this.measureRange_.getLower();
        }
        return 0;
    }

    public boolean isFullRange() {
        if (!this.measureRange_.equals(MeasureRange.FULL_RANGE)) {
            return false;
        }
        for (int i = 0; i < this.dataRangeByAxis_.length; ++i) {
            if (this.dataRangeByAxis_[i].equals(DataRange.FULL_RANGE)) continue;
            return false;
        }
        return true;
    }

    public static DataWindow getNewWindow(int[] windowStartIndexes, int measureStartIndex, WindowSize windowSize) {
        return new DataWindow(windowStartIndexes, measureStartIndex, windowSize);
    }

    public static DataWindow getNewWindow(DataRange[] dataRangesByAxis, MeasureRange measureRange) {
        return new DataWindow(dataRangesByAxis, measureRange);
    }

    public Object getXMLDelegate() {
        XMLDataWindow xmlDataWindow = new XMLDataWindow();
        for (int i = 0; i < this.dataRangeByAxis_.length; ++i) {
            xmlDataWindow.m_list_dataRangeList.add((XMLDataRange)this.dataRangeByAxis_[i].getXMLDelegate());
        }
        xmlDataWindow.m_measureRange = (XMLDataRange)this.measureRange_.getXMLDelegate();
        return xmlDataWindow;
    }
}

