/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicNode;
import com.businessobjects.visualization.graphic.IRegion;
import com.businessobjects.visualization.graphic.Property;
import com.businessobjects.visualization.graphic.PropertyDefVisibilityType;
import com.businessobjects.visualization.graphic.PropertyTree;
import com.businessobjects.visualization.graphic.Region;
import com.businessobjects.visualization.graphic.SettingsTree;
import com.businessobjects.visualization.graphic.VisuBool;
import java.util.ArrayList;

public class RegionTree
extends SettingsTree {
    private Region region_;

    RegionTree(Region region, SettingsTree parent, PropertyDefVisibilityType visibility) {
        super(region.getRegionDef(), parent, region.getValue(), visibility);
        this.region_ = region;
        this.updateChilds();
    }

    public IRegion getRegion() {
        return this.region_;
    }

    private void addChild(IRegion region, PropertyDefVisibilityType visibility) {
        if (region.getRegionDef().containsChildWithVisibility(visibility)) {
            RegionTree childTree = new RegionTree((Region)region, this, visibility);
            this.getChildVector().add(childTree);
        }
    }

    public void update() {
        this.updateValue(this.region_.getValue());
        this.cleanChilds();
        this.updateChilds();
    }

    private void updateChilds() {
        if (this.region_.getValue().equals(VisuBool.TRUE)) {
            IGraphicNode[] childrens = this.region_.getChildren();
            for (int i = 0; i < childrens.length; ++i) {
                if (childrens[i].getDef().getNodeType() == IGraphicDefNode.GraphicDefNodeType.REGION) {
                    Region subReg = (Region)childrens[i];
                    this.addChild(subReg, this.getVisibility());
                    continue;
                }
                if (childrens[i].getDef().getNodeType() == IGraphicDefNode.GraphicDefNodeType.PROPERTY) {
                    Property subProp = (Property)childrens[i];
                    if (subProp.getPropertyDef().getVisibility() != this.getVisibility() && !subProp.getPropertyDef().containsChildWithVisibility(this.getVisibility())) continue;
                    PropertyTree pt = new PropertyTree(subProp, this, this.getVisibility());
                    this.getChildVector().add(pt);
                    continue;
                }
                throw new VisualizationInternalException("Invalid Tree");
            }
        }
    }

    public ArrayList getAllChildren() {
        ArrayList<SettingsTree> children = new ArrayList<SettingsTree>();
        IRegion region = this.getRegion();
        IGraphicNode[] childrens = region.getChildren();
        for (int i = 0; i < childrens.length; ++i) {
            Property subProp;
            if (childrens[i].getDef().getNodeType() == IGraphicDefNode.GraphicDefNodeType.REGION) {
                Region subReg = (Region)childrens[i];
                RegionTree rt = new RegionTree(subReg, this, this.getVisibility());
                children.add(rt);
                continue;
            }
            if (childrens[i].getDef().getNodeType() != IGraphicDefNode.GraphicDefNodeType.PROPERTY || (subProp = (Property)childrens[i]).getPropertyDef().getVisibility() != this.getVisibility() && !subProp.getPropertyDef().containsChildWithVisibility(this.getVisibility())) continue;
            PropertyTree pt = new PropertyTree(subProp, this, this.getVisibility());
            children.add(pt);
        }
        return children;
    }
}

