/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.feed;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.ExceptionParameters;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.definition.DataContainer;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.feed.Feed;
import com.businessobjects.visualization.feed.FeedStrategy;
import com.businessobjects.visualization.feed.FeedStrategyOption;
import com.businessobjects.visualization.feed.FeedStructureHelper;
import com.businessobjects.visualization.feed.IFeedMediator;
import com.businessobjects.visualization.feed.definition.DataContainerType;
import com.businessobjects.visualization.feed.definition.DataFeedDefinition;
import com.businessobjects.visualization.feed.definition.FeedDef;
import com.businessobjects.visualization.feed.generated.XMLDataFeed;
import com.businessobjects.visualization.feed.generated.XMLFeed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DataFeed
implements IXMLDelegator {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$feed$DataFeed == null ? (class$com$businessobjects$visualization$feed$DataFeed = DataFeed.class$("com.businessobjects.visualization.feed.DataFeed")) : class$com$businessobjects$visualization$feed$DataFeed));
    private final transient DataFeedDefinition dataFeedDef_;
    private transient IFeedMediator internalMediator_;
    private String id_;
    private ArrayList feedList_;
    private FeedStructureHelper feedStructureHelper_;
    private static long staticIndexCounter;
    static /* synthetic */ Class class$com$businessobjects$visualization$feed$DataFeed;

    DataFeed(IFeedMediator mediator, DataFeedDefinition specification) {
        this.internalMediator_ = mediator;
        this.dataFeedDef_ = specification;
        this.feedList_ = new ArrayList();
        this.id_ = this.dataFeedDef_.getId() + DataFeed.getNextDefId();
    }

    public DataFeed(IFeedMediator mediator, DataFeedDefinition dataDef, DataDescriptor dd, XMLDataFeed xmlDataFeed, SerializationHelper sh) {
        this(mediator, dataDef);
        if (!xmlDataFeed.m_a_DefId.equals(this.dataFeedDef_.getId())) {
            throw new VisualizationInternalException("Mismatch in FeedDef:" + this.dataFeedDef_.getId() + " vs. " + xmlDataFeed.m_a_DefId);
        }
        this.id_ = xmlDataFeed.m_a_Id;
        Iterator iter = xmlDataFeed.m_list_Feed.iterator();
        while (iter.hasNext()) {
            XMLFeed xmlFeed = (XMLFeed)iter.next();
            Feed newFeed = new Feed(this.internalMediator_, this.dataFeedDef_.findById(xmlFeed.m_a_DefId));
            newFeed.init(dd, xmlFeed, sh);
            this.feedList_.add(newFeed);
        }
    }

    public ArrayList init(DataDescriptor dd) {
        LOGGER.debug((Object)"entering: default init for feed");
        this.feedStructureHelper_ = new FeedStructureHelper(dd);
        this.feedList_.clear();
        DatasetDescriptor currentDataset = dd.getDatasetDescriptor();
        if (currentDataset == null) {
            throw new VisualizationInternalException("Need to hava a non null DatasetDescriptor for auto-feed!");
        }
        ArrayList dataContainerList = currentDataset.getAllDataContainers();
        FeedStrategy.FeedAdder feedStrategy = new FeedStrategy.FeedAdder(FeedStrategyOption.ONLY_MANDATORY, new FeedStrategy.FeedAdder(FeedStrategyOption.ONLY_OPTIONAL, new FeedStrategy.FeedAdder(FeedStrategyOption.ONLY_MANDATORY_IGNORE_STRUCTURE, new FeedStrategy.FeedAdder(FeedStrategyOption.ONLY_OPTIONAL_IGNORE_STRUCTURE, new FeedStrategy.FeedAdder(FeedStrategyOption.ONLY_MANDATORY_IGNORE_DIMTYPE, new FeedStrategy.FeedAdder(FeedStrategyOption.ONLY_OPTIONAL_IGNORE_DIMTYPE, new FeedStrategy.FeedAdder(FeedStrategyOption.ONLY_MANDATORY_IGNORE_BOTH, new FeedStrategy.FeedAdder(FeedStrategyOption.ONLY_OPTIONAL_IGNORE_BOTH, null))))))));
        feedStrategy.feed(this, dataContainerList, currentDataset);
        if (currentDataset.getAxisList().length > 0) {
            new FeedStrategy.FeedMeasureNames(null).feed(this, dataContainerList, currentDataset);
        }
        LOGGER.debug((Object)"exiting: default init for feed");
        return dataContainerList;
    }

    public Object getXMLDelegate() {
        XMLDataFeed xmlDataFeed = new XMLDataFeed();
        xmlDataFeed.m_a_Id = this.id_;
        xmlDataFeed.m_a_DefId = this.dataFeedDef_.getId();
        Iterator iter = this.feedList_.iterator();
        while (iter.hasNext()) {
            xmlDataFeed.m_list_Feed.add((XMLFeed)((Feed)iter.next()).getXMLDelegate());
        }
        return xmlDataFeed;
    }

    public Feed[] getFeeds() {
        return this.feedList_.toArray(new Feed[0]);
    }

    public Feed[] getFeedsByDef(FeedDef feedDef) {
        if (feedDef == null) {
            return new Feed[0];
        }
        ArrayList<Feed> newFeedList = new ArrayList<Feed>();
        Iterator iter = this.getFullFeedArrayList(false).iterator();
        while (iter.hasNext()) {
            Feed element = (Feed)iter.next();
            if (!element.getFeedDef().getId().equals(feedDef.getId())) continue;
            newFeedList.add(element);
        }
        return newFeedList.toArray(new Feed[0]);
    }

    public boolean accepts(Feed feed) {
        return Feed.accepts(feed, this.getFullFeedArrayList(false), this.dataFeedDef_.getRootFeedDefList());
    }

    public boolean removeAllFeeds(FeedDef feedDef) {
        boolean bWasRemoved = false;
        Iterator iter = this.feedList_.iterator();
        while (iter.hasNext()) {
            Feed feed = (Feed)iter.next();
            if (!feed.getFeedDef().getId().equals(feedDef.getId())) continue;
            bWasRemoved = true;
            iter.remove();
        }
        return bWasRemoved;
    }

    public Feed detach(String feedDefId, DataContainer dc) {
        Iterator iter = this.feedList_.iterator();
        while (iter.hasNext()) {
            Feed feed = (Feed)iter.next();
            Feed[] feeds = feed.searchFeedsByDefId(feedDefId);
            for (int i = 0; i < feeds.length; ++i) {
                if (!feeds[i].contains(dc)) continue;
                feeds[i].removeDataContainer(dc);
                iter.remove();
                return feeds[i];
            }
        }
        throw new VisualizationRuntimeException("VIZ_00030_ERR_COULD_NOT_FIND_FEEDD", new Object[]{feedDefId, dc});
    }

    public boolean addFeed(Feed newFeed) {
        if (!newFeed.isNested() && newFeed.getFeedDef().isNested()) {
            FeedDef parentFeedDef = newFeed.getFeedDef().getParent();
            Feed[] parentFeedList = this.findByDefId(parentFeedDef.getId());
            if (parentFeedList.length != 0) {
                for (int i = 0; i < parentFeedList.length; ++i) {
                    if (!parentFeedList[i].accepts(newFeed)) continue;
                    parentFeedList[i].addNestedFeed(newFeed);
                    return true;
                }
            }
            Feed parentFeed = new Feed(this.internalMediator_, parentFeedDef);
            parentFeed.addNestedFeed(newFeed);
            this.addFeed(parentFeed);
        } else if (newFeed.isNested()) {
            this.addFeed(newFeed.getParent());
        } else if (!newFeed.getFeedDef().isNested()) {
            ExceptionParameters vre = Feed.check(newFeed, this.feedList_, this.dataFeedDef_.getRootFeedDefList());
            if (vre != null) {
                throw new VisualizationRuntimeException(vre);
            }
            this.feedList_.add(newFeed);
        }
        return true;
    }

    public Feed createFeed(String feedDefId, DataContainer dc) {
        FeedDef currentFeedDef = this.dataFeedDef_.findById(feedDefId);
        if (currentFeedDef == null) {
            throw new VisualizationRuntimeException("VIZ_00148_ERR_FEEDDEF_NOT_FOUND", new Object[]{feedDefId, this.dataFeedDef_.getId()});
        }
        Feed createdFeed = new Feed(this.internalMediator_, currentFeedDef);
        if (dc == null && currentFeedDef.hasDataContainerDefs()) {
            throw new VisualizationInternalException("Need to bind a DataContainer to this FeedDef:" + currentFeedDef.getId());
        }
        if (dc != null) {
            createdFeed.addDataContainer(dc);
        }
        this.addFeed(createdFeed);
        return createdFeed;
    }

    public Feed attach(String feedDefId, DataContainer dc) {
        FeedDef currentFeedDef = this.dataFeedDef_.findById(feedDefId);
        if (currentFeedDef == null) {
            throw new VisualizationRuntimeException("VIZ_00148_ERR_FEEDDEF_NOT_FOUND", new Object[]{feedDefId, this.dataFeedDef_.getId()});
        }
        Feed[] existingFeeds = this.findByDefId(feedDefId);
        for (int i = 0; i < existingFeeds.length; ++i) {
            if (!existingFeeds[i].accepts(dc)) continue;
            existingFeeds[i].addDataContainer(dc);
            return existingFeeds[i];
        }
        int nFeedCount = existingFeeds.length;
        if (!this.internalMediator_.checkRestrictions(nFeedCount + 1, feedDefId)) {
            throw new VisualizationRuntimeException("VIZ_00147_ERR_RESTRICTION_VIOLATION", new Object[]{dc, feedDefId});
        }
        Feed currentFeed = this.createFeed(feedDefId, dc);
        if (this.internalMediator_ != null) {
            this.internalMediator_.notifyFeedAdded(currentFeed);
        }
        return currentFeed;
    }

    public Iterator getFeedsIterator() {
        return this.feedList_.iterator();
    }

    public Feed[] findByDefId(String feedDefId) {
        return this.findByDefId(feedDefId, null);
    }

    public Feed[] findByDefId(String feedDefId, DataContainerType dcTypeName) {
        ArrayList fullList = new ArrayList();
        Iterator iter = this.feedList_.iterator();
        while (iter.hasNext()) {
            ((Feed)iter.next()).recurseAndSearchNestedFeeds(fullList, feedDefId, dcTypeName);
        }
        return fullList.toArray(new Feed[0]);
    }

    public Feed findByUid(String feedUid) {
        Iterator iter = this.feedList_.iterator();
        Feed foundFeed = null;
        while (iter.hasNext() && foundFeed == null) {
            foundFeed = ((Feed)iter.next()).searchFeedByUid(feedUid);
        }
        return foundFeed;
    }

    private ArrayList getFullFeedArrayList(boolean bOnlyDataContainersHolders) {
        ArrayList<Feed> fullList = new ArrayList<Feed>();
        Iterator iter = this.feedList_.iterator();
        while (iter.hasNext()) {
            Feed aFeed = (Feed)iter.next();
            aFeed.getFullNestedFeedList(fullList, bOnlyDataContainersHolders);
            if (bOnlyDataContainersHolders && !aFeed.getFeedDef().hasDataContainerDefs()) continue;
            fullList.add(aFeed);
        }
        return fullList;
    }

    public Feed[] getFullFeedList(boolean bOnlyDataContainerHolders) {
        ArrayList fullList = this.getFullFeedArrayList(bOnlyDataContainerHolders);
        return fullList.toArray(new Feed[0]);
    }

    public void setMediator(IFeedMediator mediator) {
        this.internalMediator_ = mediator;
    }

    public DataFeedDefinition getDataFeedDef() {
        return this.dataFeedDef_;
    }

    public Collection getBaseFeeds() {
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        Iterator feedIter = this.feedList_.iterator();
        while (feedIter.hasNext()) {
            Feed feed = (Feed)feedIter.next();
            if (!feed.getFeedDef().isBaseFeed()) continue;
            feeds.add(feed);
        }
        return feeds;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataFeed[");
        buffer.append("id = ").append(this.id_);
        buffer.append("  DefId = ").append(this.dataFeedDef_.getId());
        buffer.append(", feedList = ").append(this.feedList_);
        buffer.append("]");
        return buffer.toString();
    }

    IFeedMediator getMediator() {
        return this.internalMediator_;
    }

    protected static synchronized String getNextDefId() {
        return "Def" + ++staticIndexCounter;
    }

    FeedStructureHelper getFeedStructureHelper() {
        return this.feedStructureHelper_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

