/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.definition;

import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.common.DataStructure;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.common.DimensionType;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.definition.ClientInfoHolder;
import com.businessobjects.visualization.dataexchange.definition.DataContainer;
import com.businessobjects.visualization.dataexchange.definition.Helper;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLDimensionLabels;
import com.businessobjects.visualization.formatting.FormatHelper;
import com.businessobjects.visualization.formatting.IFormatPattern;

public class DimensionLabels
extends DataContainer {
    public static final DimensionLabels MEASURENAMES_DIMENSION = new DimensionLabels("MeasureNamesDimension", DataType.STRING, DataStructure.SIMPLE, "MND_UID");
    private DataType dataType_;
    private DataStructure dataStructure_;
    private DimensionType dimType_;

    public DimensionLabels(String title, DataType dataType, DataStructure dataStructure) {
        this(title, DataContainer.UNDEFINED_CLIENTINFOHOLDER, FormatHelper.UNDEFINED_FORMAT, dataType, dataStructure, DimensionType.STANDARD);
    }

    public DimensionLabels(String title, ClientInfoHolder clientInfo, IFormatPattern formatPattern, DataType dataType, DataStructure dataStructure) {
        this.setTitle(title);
        this.setClientInfoHolder(clientInfo);
        this.setFormat(formatPattern);
        this.dataType_ = dataType;
        this.dataStructure_ = dataStructure;
        this.dimType_ = DimensionType.STANDARD;
    }

    public DimensionLabels(String title, ClientInfoHolder clientInfo, IFormatPattern formatPattern, DataType dataType, DataStructure dataStructure, DimensionType dimType) {
        this.setTitle(title);
        this.setClientInfoHolder(clientInfo);
        this.setFormat(formatPattern);
        this.dataType_ = dataType;
        this.dataStructure_ = dataStructure;
        this.dimType_ = dimType;
    }

    DimensionLabels(XMLDimensionLabels dimLabels, SerializationHelper sh) {
        super.fromXMLDelegate(dimLabels, sh);
        this.dataType_ = Helper.fromXML(dimLabels.m_dataType);
        this.dataStructure_ = Helper.fromXML(dimLabels.m_dataStructure);
        this.dimType_ = Helper.fromXML(dimLabels.m_a_dimensionType);
    }

    DimensionLabels(String title, DataType dataType, DataStructure dataStructure, String uid) {
        this(title, dataType, dataStructure);
        this.serialId_ = uid;
    }

    public DataType getDataType() {
        return this.dataType_;
    }

    public DataStructure getDataStructure() {
        return this.dataStructure_;
    }

    public DimensionType getDimensionType() {
        return this.dimType_;
    }

    DimensionLabelsAdapter getLabelAdapter() {
        return new DimensionLabelsAdapter(this.getClientInfoHolder().getAdapter(), this.getUid(), this.getId());
    }

    public Object getXMLDelegate() {
        XMLDimensionLabels xmlDimensionLabels = new XMLDimensionLabels();
        xmlDimensionLabels.m_dataType = Helper.toXML(this.dataType_);
        xmlDimensionLabels.m_dataStructure = Helper.toXML(this.dataStructure_);
        xmlDimensionLabels.m_a_dimensionType = Helper.toXML(this.dimType_);
        super.toXMLDelegate(xmlDimensionLabels);
        return xmlDimensionLabels;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof DimensionLabels)) {
            return false;
        }
        DimensionLabels that = (DimensionLabels)oThat;
        if (!super.equals(that)) {
            return false;
        }
        if (!this.dataType_.equals(that.dataType_)) {
            return false;
        }
        if (!this.dataStructure_.equals(that.dataStructure_)) {
            return false;
        }
        return this.dimType_.equals(that.dimType_);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = HashCodeHelper.hash(result, this.dataStructure_);
        result = HashCodeHelper.hash(result, this.dataType_);
        result = HashCodeHelper.hash(result, this.dimType_);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DimensionLabels[");
        buffer.append("dataContainer = ").append(super.toString());
        buffer.append(", dataStructure = ").append(this.dataStructure_);
        buffer.append(", dataType = ").append(this.dataType_);
        buffer.append(", dimType = ").append(this.dimType_);
        buffer.append("]");
        return buffer.toString();
    }
}

