/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.definition;

import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.CalculationAdapter;
import com.businessobjects.visualization.dataexchange.definition.ClientInfoHolder;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLCalculation;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLClientInfoHolder;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLMeasureValuesRef;

public class Calculation
implements IXMLDelegator {
    public static final int NONE = 0;
    public static final int SUM = 1;
    public static final int AVERAGE = 2;
    public static final int MIN = 5;
    public static final int MAX = 6;
    public static final int PERCENTAGE = 7;
    public static final int OTHER = 8;
    public static final int MEDIAN = 9;
    public static final int FIRST_QUARTILE = 10;
    public static final int THIRD_QUARTILE = 11;
    private String title_;
    private ClientInfoHolder clientInfoHolder_;
    private int type_ = 0;
    private MeasureValues measureValueRef_;
    private int groupingDimensionsIndex_;
    private int analysisAxisIndex_;

    public Calculation(String title, ClientInfoHolder clientInfo, int type, MeasureValues measureValueRef, int groupingDimensionsIndex, int analysisAxisIndex) {
        this.title_ = title;
        this.clientInfoHolder_ = clientInfo;
        this.type_ = type;
        this.measureValueRef_ = measureValueRef;
        this.groupingDimensionsIndex_ = groupingDimensionsIndex;
        this.analysisAxisIndex_ = analysisAxisIndex;
    }

    protected Calculation(XMLCalculation xmlCalculation, SerializationHelper sh) {
        this(xmlCalculation.m_a_title, new ClientInfoHolder(xmlCalculation.m_clientInfoHolder, sh), xmlCalculation.m_a_type, (MeasureValues)sh.getObjectFromSerialUid(xmlCalculation.m_measureValuesRef.m_a_dataContainerId.id), xmlCalculation.m_a_groupingDimensionsIndex, xmlCalculation.m_a_analysisAxisIndex);
    }

    public Object getXMLDelegate() {
        XMLCalculation xmlCalculation = new XMLCalculation();
        xmlCalculation.m_a_type = this.type_;
        xmlCalculation.m_a_title = this.title_;
        xmlCalculation.m_clientInfoHolder = (XMLClientInfoHolder)this.clientInfoHolder_.getXMLDelegate();
        XMLMeasureValuesRef aRef = new XMLMeasureValuesRef();
        aRef.m_a_dataContainerId.id = this.measureValueRef_.getUid();
        xmlCalculation.m_measureValuesRef = aRef;
        xmlCalculation.m_a_groupingDimensionsIndex = this.groupingDimensionsIndex_;
        xmlCalculation.m_a_analysisAxisIndex = this.analysisAxisIndex_;
        return xmlCalculation;
    }

    public int getType() {
        return this.type_;
    }

    public void setType(int type) {
        this.type_ = type;
    }

    public String getTitle() {
        return this.title_;
    }

    public ClientInfoHolder getClientInfoHolder() {
        return this.clientInfoHolder_;
    }

    public MeasureValues getMeasureValueRef() {
        return this.measureValueRef_;
    }

    public int getGroupingDimensionsIndex() {
        return this.groupingDimensionsIndex_;
    }

    public int getAnalysisAxisIndex() {
        return this.analysisAxisIndex_;
    }

    protected CalculationAdapter getCalculationAdapter() {
        return new CalculationAdapter(this.clientInfoHolder_.getAdapter());
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof Calculation)) {
            return false;
        }
        Calculation that = (Calculation)oThat;
        return this.type_ == that.type_ && this.title_.equals(that.title_) && this.clientInfoHolder_.equals(that.clientInfoHolder_) && this.measureValueRef_.equals(that.measureValueRef_) && this.groupingDimensionsIndex_ == that.groupingDimensionsIndex_ && this.analysisAxisIndex_ == that.analysisAxisIndex_;
    }
}

