/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.impl;

import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IMember;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.InvalidDataTypeException;
import com.businessobjects.visualization.dataexchange.data.impl.DimensionLabelsBaseIterator;
import com.businessobjects.visualization.formatting.IDateFormatter;
import com.businessobjects.visualization.formatting.IFormatter;
import com.businessobjects.visualization.formatting.INumericFormatter;
import java.util.Date;
import java.util.Properties;

public class SimpleMemberImpl
implements IMember {
    private final Object value_;
    private final DataType dataType_;
    private final Properties properties_;
    private final IDimensionLabelsIterator dimIterator_;
    private int startIndex_;
    private int indexRange_;
    private IDimensionLabelsIterator memberChildIterator_;

    public SimpleMemberImpl(Object value, DataType dataType, Properties props, IDimensionLabelsIterator dimIterator) {
        this.value_ = value;
        this.dataType_ = dataType;
        this.properties_ = props;
        this.dimIterator_ = dimIterator;
    }

    public Object getValue() {
        return this.value_;
    }

    public DataType getDataType() {
        return this.dataType_;
    }

    public int getLevel() {
        return 0;
    }

    public int getDimensionIndex() {
        return this.dimIterator_.getDimensionIndex();
    }

    public int getStartIndex() {
        return this.startIndex_;
    }

    public int getIndexRange() {
        return this.indexRange_;
    }

    public boolean isLeaf() {
        return this.dimIterator_.getChildDimensionLabelsIterator() == null;
    }

    public IDimensionLabelsIterator getNextStackedDimensionIterator() {
        if (this.memberChildIterator_ == null && this.dimIterator_.getChildDimensionLabelsIterator() != null) {
            this.memberChildIterator_ = ((DimensionLabelsBaseIterator)this.dimIterator_.getChildDimensionLabelsIterator()).createFramedIterator(this.startIndex_, this.indexRange_);
        }
        return this.memberChildIterator_;
    }

    public IMember getParentMember() {
        return null;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public void setIndexRange(int indexRange) {
        this.indexRange_ = indexRange;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex_ = startIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormattedValue(IFormatter formatter) {
        if (this.dataType_.equals(DataType.DOUBLE) && !(formatter instanceof INumericFormatter)) {
            throw new InvalidDataTypeException("VIZ_00023_ERR_FORMATTER_REQUIRED_S");
        }
        if (this.dataType_.equals(DataType.DATE) && !(formatter instanceof IDateFormatter)) {
            throw new InvalidDataTypeException("VIZ_00024_ERR_FORMATTER_REQUIRED_S");
        }
        if (this.dataType_.equals(DataType.STRING) || this.dataType_.equals(DataType.UNKNOWN)) {
            throw new InvalidDataTypeException("VIZ_00025_ERR_THIS_MEMBER_TYPE_DOE");
        }
        Object object = this.value_;
        synchronized (object) {
            if (formatter instanceof INumericFormatter) {
                ((INumericFormatter)formatter).format((Double)this.value_);
            } else if (formatter instanceof IDateFormatter) {
                ((IDateFormatter)formatter).format((Date)this.value_);
            }
            return formatter.out();
        }
    }

    public Object getArrayValueImpl() {
        return this.getValue();
    }
}

