/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.impl;

import com.businessobjects.visualization.common.exceptions.SerializationException;
import com.businessobjects.visualization.common.internal.Base64Coder;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.common.DataStructure;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.InvalidDataTypeException;
import com.businessobjects.visualization.dataexchange.data.generated.XMLData;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataType;
import com.businessobjects.visualization.dataexchange.data.impl.Helper;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;

public class DoubleValueData
implements Data {
    public static final double NoValue = 1.7E308;
    private Object values_;
    private int cardinality_;
    private int[] valuesCount_ = new int[3];

    public DoubleValueData(double[] values) {
        this.setValues(values, DataType.DOUBLE, 1);
    }

    public DoubleValueData(double[][] values) {
        this.setValues(values, DataType.DOUBLE, 2);
    }

    public DoubleValueData(double[][][] values) {
        this.setValues(values, DataType.DOUBLE, 3);
    }

    public DoubleValueData(Collection values, int cardinality) {
        this.setValues(values, DataType.DOUBLE, cardinality);
    }

    public DoubleValueData(XMLData xmlValues, SerializationHelper sh) {
        this.cardinality_ = xmlValues.m_a_cardinality == -1 ? 1 : xmlValues.m_a_cardinality;
        try {
            JSONArray startArray;
            if (xmlValues.m_encodedvalues.charAt(0) != '[') {
                this.values_ = SerializationHelper.bytesToObject(Base64Coder.decode(xmlValues.m_encodedvalues));
                if (this.values_ instanceof double[]) {
                    this.valuesCount_[0] = ((double[])this.values_).length;
                } else if (this.values_ instanceof double[][]) {
                    this.valuesCount_[0] = ((double[][])this.values_).length;
                    this.valuesCount_[1] = ((double[][])this.values_)[0].length;
                } else if (this.values_ instanceof double[][][]) {
                    this.valuesCount_[0] = ((double[][][])this.values_).length;
                    this.valuesCount_[1] = ((double[][][])this.values_)[0].length;
                    this.valuesCount_[2] = ((double[][][])this.values_)[0][0].length;
                }
                return;
            }
            JSONArray jsonArray = startArray = new JSONArray(xmlValues.m_encodedvalues);
            int valCountIndex = 0;
            while (valCountIndex <= 3) {
                this.valuesCount_[valCountIndex++] = jsonArray.length();
                if (!(jsonArray.get(0) instanceof JSONArray)) break;
                jsonArray = (JSONArray)jsonArray.get(0);
            }
            if (this.cardinality_ == 1) {
                this.values_ = new double[this.valuesCount_[0]];
                for (int i = 0; i < this.valuesCount_[0]; ++i) {
                    ((double[])this.values_)[i] = startArray.getDouble(i);
                }
            } else if (this.cardinality_ == 2) {
                this.values_ = new double[this.valuesCount_[0]][this.valuesCount_[1]];
                for (int i = 0; i < this.valuesCount_[0]; ++i) {
                    for (int j = 0; j < this.valuesCount_[1]; ++j) {
                        ((double[][])this.values_)[i][j] = startArray.getJSONArray(i).getDouble(j);
                    }
                }
            } else {
                this.values_ = new double[this.valuesCount_[0]][this.valuesCount_[1]][this.valuesCount_[2]];
                for (int i = 0; i < this.valuesCount_[0]; ++i) {
                    for (int j = 0; j < this.valuesCount_[1]; ++j) {
                        for (int k = 0; k < this.valuesCount_[2]; ++k) {
                            ((double[][][])this.values_)[i][j][k] = startArray.getJSONArray(i).getJSONArray(j).getDouble(k);
                        }
                    }
                }
            }
        }
        catch (JSONException e) {
            throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", e);
        }
        catch (IOException e) {
            throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", e);
        }
    }

    public Object getValues() {
        return this.values_;
    }

    public void setValues(Object values, DataType aType, int iCardinality) throws InvalidDataTypeException {
        if (values instanceof double[] && iCardinality == 1 && aType == DataType.DOUBLE) {
            this.cardinality_ = 1;
            this.valuesCount_[0] = ((double[])values).length;
            this.values_ = values;
        } else if (values instanceof double[][] && iCardinality == 2 && aType == DataType.DOUBLE) {
            this.cardinality_ = 2;
            this.valuesCount_[0] = ((double[][])values).length;
            this.valuesCount_[1] = ((double[][])values)[0].length;
            this.values_ = values;
        } else if (values instanceof double[][][] && iCardinality == 3 && aType == DataType.DOUBLE) {
            this.cardinality_ = 3;
            this.valuesCount_[0] = ((double[][][])values).length;
            this.valuesCount_[1] = ((double[][][])values)[0].length;
            this.valuesCount_[2] = ((double[][][])values)[0][0].length;
            this.values_ = values;
        } else if (values instanceof Collection && iCardinality == 1 && aType == DataType.DOUBLE) {
            this.cardinality_ = 1;
            double[] dvalues = new double[((Collection)values).size()];
            int i = 0;
            Iterator iter = ((Collection)values).iterator();
            while (iter.hasNext()) {
                try {
                    dvalues[i++] = (Double)iter.next();
                }
                catch (NullPointerException ex) {
                    throw new InvalidDataTypeException("VIZ_00149_ERR_DOUBLEVALUEDATA_NOT_SUPPORTED");
                }
            }
            this.valuesCount_[0] = i;
            this.values_ = dvalues;
        } else if (values instanceof Collection && iCardinality == 2 && aType == DataType.DOUBLE) {
            this.cardinality_ = 2;
            double[][] dvalues = null;
            int i = 0;
            int j = 0;
            Iterator rowIterator = ((Collection)values).iterator();
            while (rowIterator.hasNext()) {
                Collection column = (Collection)rowIterator.next();
                if (i == 0) {
                    dvalues = new double[((Collection)values).size()][column.size()];
                }
                j = 0;
                Iterator columnIterator = column.iterator();
                while (columnIterator.hasNext()) {
                    if (j >= dvalues[i].length) {
                        throw new InvalidDataTypeException("VIZ_00150_ERR_NOT_SAME_COLUMN_LENGHT", new Object[]{new Integer(dvalues[i].length)});
                    }
                    try {
                        dvalues[i][j++] = (Double)columnIterator.next();
                    }
                    catch (NullPointerException ex) {
                        throw new InvalidDataTypeException("VIZ_00149_ERR_DOUBLEVALUEDATA_NOT_SUPPORTED");
                    }
                }
                ++i;
            }
            this.valuesCount_[0] = i;
            this.valuesCount_[1] = j;
            this.values_ = dvalues;
        } else {
            throw new InvalidDataTypeException("VIZ_00149_ERR_DOUBLEVALUEDATA_NOT_SUPPORTED");
        }
    }

    public int getValuesCount(int iCardinality) {
        if (iCardinality > 3 || iCardinality < 1) {
            throw new InvalidDataTypeException("VIZ_00022_ERR_IMPROPER_CARDINALITY");
        }
        return this.valuesCount_[iCardinality - 1];
    }

    public DataType getType() {
        return DataType.DOUBLE;
    }

    public int getCardinality() {
        return this.cardinality_;
    }

    public Object getXMLDelegate() {
        XMLData data = new XMLData();
        data.m_a_cardinality = this.cardinality_;
        data.m_dataType = new XMLDataType(1);
        data.m_dataStructure = Helper.toXML(DataStructure.SIMPLE);
        try {
            data.m_encodedvalues = this.toJSONString();
        }
        catch (JSONException e) {
            throw new SerializationException("VIZ_00003_ERR_SERIALIZATION_ERROR", e);
        }
        return data;
    }

    public DataStructure getStructure() {
        return DataStructure.SIMPLE;
    }

    public boolean supportProperties() {
        return false;
    }

    public Object getProperties() {
        return null;
    }

    public void setProperties(Object properties) {
        throw new InvalidDataTypeException("VIZ_00021_ERR_DOUBLEVALUEDATA_DOES");
    }

    public String toJSONString() throws JSONException {
        return new JSONArray(this.values_).toString();
    }
}

