/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.graph.impl;

import com.businessobjects.visualization.common.exceptions.NotImplementedException;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.graph.INode;
import com.businessobjects.visualization.formatting.IFormatter;
import java.util.Properties;

public class NodeImpl
implements INode {
    private final int absoluteIndex_;
    private final DataType dataType_;
    private final int dimensionIndex_;
    private final int dimLevel_;
    private final Object value_;
    private final Properties properties_;
    transient int internalIndex_;

    public NodeImpl(int absoluteIndex, DataType dataType, int dimensionIndex, Object value, Properties properties, int dimLevel) {
        if (absoluteIndex < -1) {
            throw new IllegalArgumentException("cannot take < -1 abs index values");
        }
        if (dimensionIndex < -1) {
            throw new IllegalArgumentException("cannot take < -1 dim Index values");
        }
        if (dimLevel < 0) {
            throw new IllegalArgumentException("cannot take < 0 dim level values");
        }
        this.absoluteIndex_ = absoluteIndex;
        this.dataType_ = dataType;
        this.dimensionIndex_ = dimensionIndex;
        this.value_ = value;
        this.properties_ = properties;
        this.internalIndex_ = -1;
        this.dimLevel_ = dimLevel;
    }

    public int getAbsoluteIndex() {
        return this.absoluteIndex_;
    }

    public DataType getDataType() {
        return this.dataType_;
    }

    public int getDimensionIndex() {
        return this.dimensionIndex_;
    }

    public String getFormattedValue(IFormatter formatter) {
        throw new NotImplementedException();
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public Object getValue() {
        return this.value_;
    }

    public String toString() {
        return "NodeImpl[value:" + this.value_ + " dimIdx:" + this.dimensionIndex_ + " absIdx:" + this.absoluteIndex_ + "]";
    }

    public int getDimensionBasedLevel() {
        return this.dimLevel_;
    }
}

