/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.consumer;

import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.dataexchange.DataHolder;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.common.DataStructure;
import com.businessobjects.visualization.dataexchange.consumer.DataHandler;
import com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.DataRange;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.graph.IAxisTree;
import com.businessobjects.visualization.dataexchange.definition.AnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.feed.Feed;
import java.util.ArrayList;
import java.util.HashMap;

public class FeedDimensionsHandler
extends DataHandler {
    private String[] labels_;
    private int dlabels_;
    private final Feed axisFeed_;
    private AnalysisAxis analysisAxis_;
    private int axisIndex_ = -1;
    private DataRange windowRange_;

    public FeedDimensionsHandler(Feed feed, DataHolder dh, DataRange windowRange) {
        this.init(dh, feed.getDataContainers()[0]);
        this.axisFeed_ = feed;
        this.windowRange_ = windowRange;
    }

    public FeedDimensionsHandler(Feed feed, GraphicInstance context) {
        this(feed, new DataHolder(context.getDataDescriptor(), context.getDataAdapter()), null);
        this.windowRange_ = FeedDimensionsHandler.getWindowRange(context, this.getAnalysisAxisIndex());
    }

    public String[] getLabels() {
        return this.getLabels(-1);
    }

    public DataRange getWindowRange() {
        return this.windowRange_;
    }

    public String[] getLabels(int depth) {
        if (this.labels_ == null || this.dlabels_ != depth) {
            this.labels_ = FeedDimensionsHandler.getLabels(this.getIterator(), "", depth);
            this.dlabels_ = depth;
        }
        return this.labels_;
    }

    public void getLegendInfos(ArrayList legendItems, HashMap legendGroups) {
        this.getLegendInfos(-1, legendItems, legendGroups);
    }

    public void getLegendInfos(int depth, ArrayList legendItems, HashMap legendGroups) {
        FeedDimensionsHandler.getLegendInfos(this.getIterator(), legendItems, legendGroups, "", depth);
    }

    public AnalysisAxis getAnalysisAxis() {
        if (this.analysisAxis_ == null && this.getAnalysisAxisIndex() != -1) {
            this.analysisAxis_ = this.getDataHolder().getDataDescriptor().getDatasetDescriptor().getAxisList()[this.getAnalysisAxisIndex()];
        }
        return this.analysisAxis_;
    }

    public IAxisTree getAxisTree() {
        if (this.getAnalysisAxisIndex() != -1) {
            AnalysisAxisAdapter analysisAxisAdapter = this.getDataHolder().getDataAdapter().getDataset().getAxisList()[this.getAnalysisAxisIndex()];
            return analysisAxisAdapter.getAxisTree();
        }
        return null;
    }

    public boolean isHierarchical() {
        return ((DimensionLabels)this.getDataContainer()).getDataStructure().equals(DataStructure.TREE) || this.axisFeed_.getDataContainers().length > 1;
    }

    public Feed getFeed() {
        return this.axisFeed_;
    }

    public IDimensionLabelsIterator getIterator() {
        return FeedDimensionsHandler.getDimensionLabelsCallBack(this.getDataHolder(), this.axisFeed_, -1, -1, this.getWindowRange());
    }

    public IDimensionLabelsIterator getIterator(int maxLevel, int maxDimIndex) {
        return FeedDimensionsHandler.getDimensionLabelsCallBack(this.getDataHolder(), this.axisFeed_, maxDimIndex, maxLevel, this.getWindowRange());
    }

    public int getAnalysisAxisIndex() {
        if (this.axisIndex_ < 0 && !this.isMeasureNameDimension()) {
            DatasetDescriptor dset = this.getDataHolder().getDataDescriptor().getDatasetDescriptor();
            this.axisIndex_ = dset.getAxisIndex((DimensionLabels)this.getDataContainer());
        }
        return this.axisIndex_;
    }

    public String getTitle() {
        String title = "";
        int dimIndex = this.getAnalysisAxis().getDimensionLabelsIndex((DimensionLabels)this.getDataContainer());
        if (dimIndex == 0) {
            DimensionLabelsAdapter[] dlList = this.getDataHolder().getDataAdapter().getDataset().getAxisList()[this.getAnalysisAxisIndex()].getDimensionLabelsList();
            DimensionLabels[] dimList = this.getDataHolder().getDataDescriptor().getDatasetDescriptor().getAxisList()[this.getAnalysisAxisIndex()].getDimensionLabelsList();
            title = dlList[0].getTitle();
            if (title == null) {
                title = dimList[0].getId();
            }
            if (dlList.length > 1 && title != null) {
                StringBuffer sb = new StringBuffer();
                sb.append(title);
                for (int i = 1; i < dlList.length; ++i) {
                    sb.append(" / ");
                    if (dlList[i].getTitle() != null) {
                        sb.append(dlList[i].getTitle());
                        continue;
                    }
                    if (dimList[i].getId() == null) continue;
                    sb.append(dimList[i].getId());
                }
                title = sb.toString();
            }
        } else {
            title = this.getDataContainerAdapter().getTitle() != null ? this.getDataContainerAdapter().getTitle() : this.getDataContainer().getId();
        }
        return title;
    }

    public boolean isMeasureNameDimension() {
        return this.getDataContainer().equals(DimensionLabels.MEASURENAMES_DIMENSION);
    }
}

