/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.common.internal;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.MigrationRegion;
import com.businessobjects.visualization.common.internal.ParentRegionKey;
import com.businessobjects.visualization.common.internal.VersionHelper;
import com.businessobjects.visualization.common.internal.VisuVersion;
import java.util.ArrayList;
import java.util.HashMap;

public class VisuVersionManager {
    private VisuVersion currentVersion_;
    private HashMap migMap_ = new HashMap();

    public VisuVersionManager(String xmlContentVersion) {
        this.currentVersion_ = VersionHelper.getCurrentVersion(xmlContentVersion);
    }

    public VisuVersion getCurrentVersion() {
        return this.currentVersion_;
    }

    public MigrationRegion addRegionVersion(String xmlVersion, String parentRegionUid, String oldRegionId) {
        ParentRegionKey prk;
        MigrationRegion mr;
        ArrayList<MigrationRegion> migrationRegionList = (ArrayList<MigrationRegion>)this.migMap_.get(xmlVersion);
        if (migrationRegionList == null) {
            migrationRegionList = new ArrayList<MigrationRegion>();
            this.migMap_.put(xmlVersion, migrationRegionList);
        }
        if (migrationRegionList.contains(mr = new MigrationRegion(prk = new ParentRegionKey(parentRegionUid, oldRegionId)))) {
            throw new VisualizationRuntimeException("VIZ_00075_ERR_DUPLICATE_KEY_IN_VIS", new Object[]{prk});
        }
        migrationRegionList.add(mr);
        return mr;
    }

    public String getCurrentRegionId(String xmlVersion, String parentRegionUid, String regionId) {
        String result = regionId;
        MigrationRegion mr = this.getMigrationRegion(xmlVersion, parentRegionUid, regionId);
        if (mr != null) {
            result = mr.getCurrentRegionId(regionId);
        }
        return result;
    }

    public String getCurrentPropertyId(String version, String parentRegionUid, String regId, String propId) {
        String result = propId;
        MigrationRegion mr = this.getMigrationRegion(version, parentRegionUid, regId);
        if (mr != null) {
            result = mr.getCurrentPropertyId(propId);
        }
        return result;
    }

    public MigrationRegion getMigrationRegion(String version, String parentUid, String regionId) {
        MigrationRegion result = null;
        String ver = version == null || version.length() == 0 ? "1.0.0.0.0.0" : version;
        VisuVersion vv = new VisuVersion(ver);
        if (!this.currentVersion_.equals(vv) && this.migMap_.containsKey(vv.getXmlVersion())) {
            ArrayList migrationRegionList = (ArrayList)this.migMap_.get(vv.getXmlVersion());
            ParentRegionKey prk = new ParentRegionKey(parentUid, regionId);
            for (int i = 0; i < migrationRegionList.size(); ++i) {
                MigrationRegion mr = (MigrationRegion)migrationRegionList.get(i);
                if (!mr.getKey().equals(prk)) continue;
                result = mr;
                break;
            }
        }
        return result;
    }
}

