/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization;

import com.businessobjects.visualization.Helper;
import com.businessobjects.visualization.LocalizedEngine;
import com.businessobjects.visualization.VisuXmlRoot;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.dataexchange.data.DataSamplesManager;
import com.businessobjects.visualization.feed.definition.generated.XMLDataFeedDefinitionList;
import com.businessobjects.visualization.formatting.IFormatFactory;
import com.businessobjects.visualization.formatting.defaultimpl.SimpleFormatFactory;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.resource.GraphicResource;
import com.businessobjects.visualization.graphic.resource.GraphicResourcePalette;
import com.businessobjects.visualization.graphic.resource.GraphicResources;
import com.businessobjects.visualization.graphic.xml.migration.generated.XMLMigrations;
import com.businessobjects.visualization.graphic.xml.scoring.generated.XMLScoringRules;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLDefaultValue;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLDefaultValues;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLGraphic;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLVisualizationLibrary;
import com.businessobjects.visualization.rendering.formats.OutputType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.xml.generated.XMLFile;
import com.businessobjects.visualization.xml.generated.XMLProvider;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public final class VisualizationEngine {
    public static final String MSG_RESOURCES_BASENAME = "com.businessobjects.visualization.common.exceptions.generated.VisuGeneratedMessages";
    private static VisualizationEngine instance = new VisualizationEngine();
    private ArrayList engines_;
    private VisuProvider[] visuProviders_;
    private Object lock_ = new Object();
    public static final String XMLPATH = "com/businessobjects/visualization/resources/";
    private String definitionFile_;
    private int languages_;
    private int outputs_;
    private String[] providersUid_;
    private boolean bDefsLoaded_;
    private GraphicResources resources_ = new GraphicResources();
    private IFormatFactory formatFactory_;

    private VisualizationEngine() {
    }

    public static VisualizationEngine getInstance() {
        return instance;
    }

    public static VisualizationEngine getInstance(String definitionFile) {
        instance.loadAvailableGraphics(definitionFile);
        return VisualizationEngine.getInstance();
    }

    public static VisualizationEngine getInstance(String definitionFile, IFormatFactory formatFactory) {
        if (VisualizationEngine.instance.formatFactory_ != formatFactory) {
            VisualizationEngine.instance.formatFactory_ = formatFactory;
        }
        return definitionFile != null ? VisualizationEngine.getInstance(definitionFile) : VisualizationEngine.getInstance();
    }

    private void loadPalette() {
        this.addResource(new GraphicResourcePalette("basic", "Palette basic", "com/businessobjects/visualization/resources/palette_Basic.txt"));
        this.addResource(new GraphicResourcePalette("hue1", "Palette Hue1", "com/businessobjects/visualization/resources/palette_Hue1.txt"));
        this.addResource(new GraphicResourcePalette("hue2", "Palette Hue2", "com/businessobjects/visualization/resources/palette_Hue2.txt"));
        this.addResource(new GraphicResourcePalette("hue3", "Palette Hue3", "com/businessobjects/visualization/resources/palette_Hue3.txt"));
        this.addResource(new GraphicResourcePalette("violet", "Palette violet", "com/businessobjects/visualization/resources/palette_Violet.txt"));
        this.addResource(new GraphicResourcePalette("red", "Palette red", "com/businessobjects/visualization/resources/palette_Red.txt"));
        this.addResource(new GraphicResourcePalette("orange", "Palette orange", "com/businessobjects/visualization/resources/palette_Orange.txt"));
        this.addResource(new GraphicResourcePalette("green", "Palette green", "com/businessobjects/visualization/resources/palette_Green.txt"));
        this.addResource(new GraphicResourcePalette("blue", "Palette blue", "com/businessobjects/visualization/resources/palette_Blue.txt"));
        this.addResource(new GraphicResourcePalette("black&white", "Palette black&white", "com/businessobjects/visualization/resources/palette_Black_White.txt"));
    }

    public static VisualizationEngine getInstance(String definitionFile, int languages, int outputs, String[] providersUid) {
        instance.loadAvailableGraphics(definitionFile, languages, outputs, providersUid);
        return instance;
    }

    public void loadAvailableGraphics(String definitionFile) {
        this.loadAvailableGraphics(definitionFile, 65535, 65535, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAvailableGraphics(String definitionFile, int languages, int outputs, String[] providersUid) {
        if (this.bDefsLoaded_ && (this.definitionFile_ == definitionFile || this.definitionFile_ != null && this.definitionFile_.equals(definitionFile)) && this.languages_ == languages && this.outputs_ == outputs && (this.providersUid_ == providersUid || this.providersUid_ != null && this.providersUid_.equals(providersUid))) {
            return;
        }
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.engines_ = null;
                String strRootPackagePath = Helper.getPackagePath(definitionFile, XMLPATH);
                XmlReader reader = Helper.file2Reader(Helper.buildResourcePaths(definitionFile, strRootPackagePath));
                VisuXmlRoot root = new VisuXmlRoot();
                root.unmarshall(reader, null);
                reader.close();
                ArrayList<VisuProvider> list = new ArrayList<VisuProvider>();
                for (int i = 0; i < root.m_cvom.m_list_Provider.size(); ++i) {
                    XMLProvider xmlp = (XMLProvider)root.m_cvom.m_list_Provider.get(i);
                    if (providersUid != null && !this.strIsInList(xmlp.m_a_Id, providersUid)) continue;
                    int outputType = OutputType.decodeOutputType(xmlp.m_a_Output);
                    int supportedLanguage = Helper.decodeSupportedLanguage(xmlp.m_a_SupportedLanguage);
                    if ((outputs & outputType) == 0 || (languages & supportedLanguage) == 0) continue;
                    VisuProvider xp = new VisuProvider(xmlp, strRootPackagePath, outputs & outputType);
                    list.add(xp);
                }
                this.visuProviders_ = new VisuProvider[list.size()];
                list.toArray(this.visuProviders_);
                this.bDefsLoaded_ = true;
            }
            catch (XmlException xe) {
                throw new VisualizationRuntimeException("VIZ_00136_ERR_XML_PROBLEM_LOADING_", new Object[]{definitionFile}, xe);
            }
        }
    }

    private boolean strIsInList(String s, String[] list) {
        boolean result = false;
        if (s == null || list == null) {
            return false;
        }
        for (int i = 0; i < list.length && !result; ++i) {
            if (!s.equals(list[i])) continue;
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalizedEngine getLocalizedEngine(Locale locale) {
        if (!this.bDefsLoaded_) {
            this.loadAvailableGraphics("cvomroot.xml");
        }
        LocalizedEngine le = null;
        Object object = this.lock_;
        synchronized (object) {
            if (this.engines_ == null) {
                this.engines_ = new ArrayList();
            } else {
                for (int i = 0; i < this.engines_.size(); ++i) {
                    le = (LocalizedEngine)this.engines_.get(i);
                    if (le == null || !le.getLocale().equals(locale)) continue;
                    return le;
                }
            }
            le = new LocalizedEngine(this, locale);
            this.engines_.add(le);
        }
        return le;
    }

    VisuProvider[] getVisuProviders() {
        return this.visuProviders_;
    }

    public void addResource(GraphicResource resource) {
        this.resources_.addResource(resource);
    }

    public GraphicResources getResources() {
        return this.resources_;
    }

    public IFormatFactory getFormatFactory() {
        if (this.formatFactory_ == null) {
            this.formatFactory_ = new SimpleFormatFactory();
        }
        return this.formatFactory_;
    }

    static {
        instance.loadPalette();
    }

    class VisuProvider {
        private XMLProvider provider_;
        private XMLVisualizationLibrary xlibtemplate_;
        private XMLDataFeedDefinitionList xdatafeedspeclist_;
        private XMLScoringRules xscoringrules_;
        private XMLMigrations xmigrations_;
        private String[] locFiles_;
        private String rootPackagePath_;
        private int outputs_;
        private DataSamplesManager dataSamplesManager_ = new DataSamplesManager();
        private ArrayList graphicList_ = new ArrayList();
        private Hashtable defaultValues_ = new Hashtable();

        VisuProvider(XMLProvider provider, String rootPackagePath, int outputs) {
            XMLFile xf;
            int i;
            this.rootPackagePath_ = rootPackagePath;
            this.provider_ = provider;
            this.locFiles_ = new String[provider.m_list_Loc.size()];
            this.outputs_ = outputs;
            for (i = 0; i < provider.m_list_Loc.size(); ++i) {
                xf = (XMLFile)provider.m_list_Loc.get(i);
                this.locFiles_[i] = xf.m_a_File;
            }
            for (i = 0; i < provider.m_list_Def.size(); ++i) {
                xf = (XMLFile)provider.m_list_Def.get(i);
                this.loadProvider(Helper.buildResourcePaths(xf.m_a_File, rootPackagePath));
            }
            this.xlibtemplate_ = new XMLVisualizationLibrary();
            for (i = 0; i < provider.m_list_CommonDef.size(); ++i) {
                xf = (XMLFile)provider.m_list_CommonDef.get(i);
                this.loadTemplate(Helper.buildResourcePaths(xf.m_a_File, rootPackagePath));
            }
            this.xdatafeedspeclist_ = new XMLDataFeedDefinitionList();
            for (i = 0; i < provider.m_list_FeedsDef.size(); ++i) {
                xf = (XMLFile)provider.m_list_FeedsDef.get(i);
                this.loadDataFeed(Helper.buildResourcePaths(xf.m_a_File, rootPackagePath));
            }
            this.xscoringrules_ = new XMLScoringRules();
            for (i = 0; i < provider.m_list_ScoringRules.size(); ++i) {
                xf = (XMLFile)provider.m_list_ScoringRules.get(i);
                this.loadScoring(Helper.buildResourcePaths(xf.m_a_File, rootPackagePath));
            }
            this.xmigrations_ = new XMLMigrations();
            for (i = 0; i < provider.m_list_Migration.size(); ++i) {
                xf = (XMLFile)provider.m_list_Migration.get(i);
                this.loadMigration(Helper.buildResourcePaths(xf.m_a_File, rootPackagePath));
            }
            for (i = 0; i < provider.m_list_DataSamplesDef.size(); ++i) {
                xf = (XMLFile)provider.m_list_DataSamplesDef.get(i);
                this.dataSamplesManager_.readFromXmlReader(Helper.file2Reader(Helper.buildResourcePaths(xf.m_a_File, rootPackagePath)));
            }
        }

        XMLProvider getXmlProvider() {
            return this.provider_;
        }

        void addGraphic(XMLGraphic xg) {
            this.graphicList_.add(xg);
        }

        XMLGraphic[] getXmlGraphics() {
            XMLGraphic[] result = new XMLGraphic[this.graphicList_.size()];
            this.graphicList_.toArray(result);
            return result;
        }

        VisuObject[] getXmlDefaultValues(Locale loc) {
            VisuObject[] result = null;
            if (this.defaultValues_.containsKey(loc)) {
                ArrayList list = (ArrayList)this.defaultValues_.get(loc);
                result = new VisuObject[list.size()];
                list.toArray(result);
            } else {
                result = new VisuObject[]{};
            }
            return result;
        }

        XMLScoringRules getScoringRules() {
            return this.xscoringrules_;
        }

        XMLDataFeedDefinitionList getDataFeedSpecList() {
            return this.xdatafeedspeclist_;
        }

        XMLVisualizationLibrary getXLibTemplate() {
            return this.xlibtemplate_;
        }

        XMLMigrations getXMigrations() {
            return this.xmigrations_;
        }

        DataSamplesManager getDataSamplesManager() {
            return this.dataSamplesManager_;
        }

        private void loadProvider(String[] fullNames) {
            int i;
            VisuXmlRoot rootProvider = Helper.file2Root(fullNames);
            XMLVisualizationLibrary xvlp = rootProvider.m_MyVisualizationLibraries.m_Library;
            for (i = 0; i < xvlp.m_list_Graphic.size(); ++i) {
                this.addGraphic((XMLGraphic)xvlp.m_list_Graphic.get(i));
            }
            for (i = 0; i < xvlp.m_list_DefaultValues.size(); ++i) {
                this.addDefaultValues((XMLDefaultValues)xvlp.m_list_DefaultValues.get(i));
            }
        }

        private void addDefaultValues(XMLDefaultValues xdvs) {
            Locale loc = new Locale(xdvs.m_a_language, xdvs.m_a_country);
            if (this.defaultValues_.containsKey(loc)) {
                throw new VisualizationRuntimeException("VIZ_00137_ERR_DEFAULT_VALUES_ALREA", new Object[]{loc});
            }
            ArrayList<VisuObject> list = new ArrayList<VisuObject>();
            for (int i = 0; i < xdvs.m_list_DefaultValue.size(); ++i) {
                XMLDefaultValue xdv = (XMLDefaultValue)xdvs.m_list_DefaultValue.get(i);
                if (xdv == null) continue;
                list.add(VisuObject.create(xdv.m_a_type, xdv.m_a_value));
            }
            this.defaultValues_.put(loc, list);
        }

        private void loadTemplate(String[] fullNames) {
            int i;
            VisuXmlRoot xr = Helper.file2Root(fullNames);
            XMLVisualizationLibrary xvl = xr.m_MyVisualizationLibraries.m_Library;
            for (i = 0; i < xvl.m_list_DefaultValues.size(); ++i) {
                this.xlibtemplate_.m_list_DefaultValues.add(xvl.m_list_DefaultValues.get(i));
            }
            for (i = 0; i < xvl.m_list_PropertyTemplate.size(); ++i) {
                this.xlibtemplate_.m_list_PropertyTemplate.add(xvl.m_list_PropertyTemplate.get(i));
            }
            for (i = 0; i < xvl.m_list_RegionTemplate.size(); ++i) {
                this.xlibtemplate_.m_list_RegionTemplate.add(xvl.m_list_RegionTemplate.get(i));
            }
            for (i = 0; i < xvl.m_list_Graphic.size(); ++i) {
                this.xlibtemplate_.m_list_Graphic.add(xvl.m_list_Graphic.get(i));
            }
        }

        private void loadMigration(String[] fullNames) {
            VisuXmlRoot xr = Helper.file2Root(fullNames);
            XMLMigrations xms = xr.m_Migrations;
            for (int i = 0; i < xms.m_list_Migration.size(); ++i) {
                this.xmigrations_.m_list_Migration.add(xms.m_list_Migration.get(i));
            }
        }

        private void loadDataFeed(String[] fullNames) {
            VisuXmlRoot xr = Helper.file2Root(fullNames);
            XMLDataFeedDefinitionList xdffl = xr.m_DataFeedDefinitionList;
            for (int i = 0; i < xdffl.m_list_DataFeedDefinition.size(); ++i) {
                this.xdatafeedspeclist_.m_list_DataFeedDefinition.add(xdffl.m_list_DataFeedDefinition.get(i));
            }
        }

        private void loadScoring(String[] fullNames) {
            VisuXmlRoot xr = Helper.file2Root(fullNames);
            XMLScoringRules xsr = xr.m_ScoringRules;
            this.xscoringrules_.m_a_DefaultFeedValueScore = xsr.m_a_DefaultFeedValueScore;
            this.xscoringrules_.m_a_DefaultIncompleteFeedValueScore = xsr.m_a_DefaultIncompleteFeedValueScore;
            for (int i = 0; i < xsr.m_list_CategoryScoringRules.size(); ++i) {
                this.xscoringrules_.m_list_CategoryScoringRules.add(xsr.m_list_CategoryScoringRules.get(i));
            }
        }

        public String[] getLocFiles() {
            return this.locFiles_;
        }

        public String getRootPackagePath() {
            return this.rootPackagePath_;
        }

        public int getOutputTypeMask() {
            return this.outputs_;
        }
    }
}

