/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.lib;

import com.crystaldecisions.client.helper.CloneUtil;
import com.crystaldecisions.sdk.occa.report.lib.ControllableList;
import com.crystaldecisions.sdk.occa.report.lib.IClone;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayListMerger<E> {
    final ControllableList<E> m_originalList;
    final ControllableList<E> m_updatedList;
    ArrayList<E> m_newList;
    boolean[] m_isOriginalAlreadyMatched;
    boolean[] m_isUpdatedAlreadyMatched;
    int[] m_matchIndex;

    public ArrayListMerger(ControllableList<E> originalList, ControllableList<E> updatedList) {
        this.m_originalList = originalList;
        this.m_updatedList = updatedList;
    }

    public ArrayList<E> merge() {
        this.m_isOriginalAlreadyMatched = new boolean[this.m_originalList.size()];
        Arrays.fill(this.m_isOriginalAlreadyMatched, false);
        this.m_isUpdatedAlreadyMatched = new boolean[this.m_updatedList.size()];
        Arrays.fill(this.m_isUpdatedAlreadyMatched, false);
        this.m_matchIndex = new int[this.m_originalList.size()];
        this.m_newList = new ArrayList(this.m_updatedList.size());
        for (int i2 = 0; i2 < this.m_updatedList.size(); ++i2) {
            this.m_newList.add(null);
        }
        boolean matchByPosition = false;
        this.mergePass(matchByPosition);
        matchByPosition = true;
        this.mergePass(matchByPosition);
        this.clonePass();
        return this.m_newList;
    }

    private void mergePass(boolean matchByPosition) {
        int lastMatchIdx = -1;
        for (int originalListIdx = 0; originalListIdx < this.m_originalList.size(); ++originalListIdx) {
            if (!this.m_isOriginalAlreadyMatched[originalListIdx]) {
                int searchLength;
                Object originalObject = this.m_originalList.get(originalListIdx);
                int n2 = searchLength = matchByPosition ? 1 : this.m_updatedList.size();
                if (this.m_updatedList.isEmpty()) {
                    searchLength = 0;
                }
                for (int j2 = 0; j2 < searchLength && !this.m_isOriginalAlreadyMatched[originalListIdx]; ++j2) {
                    int updatedListIdx = (j2 + lastMatchIdx + 1) % this.m_updatedList.size();
                    if (this.m_isUpdatedAlreadyMatched[updatedListIdx]) continue;
                    Object updatedObject = this.m_updatedList.get(updatedListIdx);
                    if (!matchByPosition && !this.haveMatchingContent(originalObject, updatedObject)) continue;
                    this.m_newList.set(updatedListIdx, this.mergeObjects(originalObject, updatedObject));
                    this.m_isOriginalAlreadyMatched[originalListIdx] = true;
                    this.m_isUpdatedAlreadyMatched[updatedListIdx] = true;
                    this.m_matchIndex[originalListIdx] = updatedListIdx;
                }
            }
            if (!this.m_isOriginalAlreadyMatched[originalListIdx]) continue;
            lastMatchIdx = this.m_matchIndex[originalListIdx];
        }
    }

    private void clonePass() {
        for (int updatedListIdx = 0; updatedListIdx < this.m_updatedList.size(); ++updatedListIdx) {
            if (this.m_isUpdatedAlreadyMatched[updatedListIdx]) continue;
            Object updatedObject = this.m_updatedList.get(updatedListIdx);
            this.m_newList.set(updatedListIdx, this.cloneObject(updatedObject));
        }
    }

    private E mergeObjects(E originalObject, E updatedObject) {
        IClone originalCloneable;
        IClone updatedCloneable;
        if (this.m_originalList.isOwner(originalObject) && originalObject instanceof IClone && updatedObject instanceof IClone && CloneUtil.canCopyTo(updatedCloneable = (IClone)updatedObject, originalCloneable = (IClone)originalObject)) {
            updatedCloneable.copyTo(originalCloneable, true);
            return originalObject;
        }
        return this.cloneObject(updatedObject);
    }

    private E cloneObject(E object) {
        if (object instanceof IClone) {
            return (E)((IClone)object).clone(true);
        }
        return object;
    }

    private boolean haveMatchingContent(E objA, E objB) {
        Object uniqueIDOfA = this.m_originalList.getUniqueID(objA);
        Object uniqueIDOfB = this.m_originalList.getUniqueID(objB);
        if (uniqueIDOfA != null) {
            return uniqueIDOfA.equals(uniqueIDOfB);
        }
        if (objA instanceof IClone && objB instanceof IClone) {
            IClone cloneableA = (IClone)objA;
            IClone cloneableB = (IClone)objB;
            return objA.getClass() == objB.getClass() && cloneableA.hasContent(cloneableB);
        }
        if (objA != null) {
            return objA.equals(objB);
        }
        return objB == null;
    }
}

