/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas.functions.typeconversion;

import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.value.DTSParser;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.formulas.FormulaEnvironment;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions.reports.formulas.FormulaInfo;
import com.crystaldecisions.reports.formulas.FormulaResources;
import com.crystaldecisions.reports.formulas.FormulaValueReference;
import com.crystaldecisions.reports.formulas.functions.dateandtime.DateTimeHelper;
import java.util.Locale;

class d
extends FormulaFunctionBase {
    public d(String string, String string2, FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
        super(string, string2, formulaFunctionArgumentDefinitionArray);
    }

    public d(String string, String string2, FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray, FormulaInfo.Syntax syntax) {
        super(string, string2, formulaFunctionArgumentDefinitionArray, false, syntax, true);
    }

    public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        if (formulaValueReferenceArray.length == 3 && formulaValueReferenceArray[0].getFormulaValue() != null && formulaValueReferenceArray[1].getFormulaValue() != null && formulaValueReferenceArray[2].getFormulaValue() != null) {
            int n2 = ((NumberValue)formulaValueReferenceArray[0].getFormulaValue()).getInt();
            int n3 = ((NumberValue)formulaValueReferenceArray[1].getFormulaValue()).getInt();
            int n4 = ((NumberValue)formulaValueReferenceArray[2].getFormulaValue()).getInt();
            if (n2 != 0 || n3 != 0 || n4 != 0) {
                DateTimeHelper.if(n2, n3, n4);
            }
        }
        return FormulaValueType.date;
    }

    public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        this.validate(formulaValueReferenceArray, formulaEnvironment);
        if (formulaValueReferenceArray.length == 3) {
            int n2 = ((NumberValue)formulaValueReferenceArray[0].getFormulaValue()).getInt();
            int n3 = ((NumberValue)formulaValueReferenceArray[1].getFormulaValue()).getInt();
            int n4 = ((NumberValue)formulaValueReferenceArray[2].getFormulaValue()).getInt();
            if (n2 == 0 && n3 == 0 && n4 == 0) {
                return null;
            }
            return DateValue.fromYMD((int)n2, (int)n3, (int)n4);
        }
        FormulaValue formulaValue = formulaValueReferenceArray[0].getFormulaValue();
        if (formulaValue.getFormulaValueType() == FormulaValueType.number) {
            double d10 = Math.floor(((NumberValue)formulaValue).getDouble());
            try {
                return DateValue.fromOleDate((double)d10);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FormulaFunctionArgumentException("JRC00002501", "", FormulaResources.a(), "DateYearOutOfRange", 0);
            }
        }
        if (formulaValue.getFormulaValueType() == FormulaValueType.string) {
            String string = ((StringValue)formulaValue).getString();
            if (string.length() == 0) {
                return null;
            }
            DateTimeValue dateTimeValue = DTSParser.parse((Locale)formulaEnvironment.getFormulaContext().getLocale(), (String)string, (boolean)true, (boolean)false);
            if (dateTimeValue == null) {
                throw new FormulaFunctionArgumentException("JRC00002502", "", FormulaResources.a(), "BadDateTimeString", 0);
            }
            return dateTimeValue.getDateValue();
        }
        if (formulaValue.getFormulaValueType() == FormulaValueType.dateTime) {
            DateTimeValue dateTimeValue = (DateTimeValue)formulaValue;
            return dateTimeValue.getDateValue();
        }
        CrystalAssert.ASSERT((boolean)false);
        return formulaValue;
    }
}

