/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas.functions.financial;

import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.formulas.FormulaEnvironment;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions.reports.formulas.FormulaResources;
import com.crystaldecisions.reports.formulas.FormulaValueReference;
import com.crystaldecisions.reports.formulas.functions.CommonArguments;
import com.crystaldecisions.reports.formulas.functions.FormulaFunctionFactory;
import com.crystaldecisions.reports.formulas.functions.financial.ae;
import com.crystaldecisions.reports.formulas.functions.financial.an;

class p
implements FormulaFunctionFactory {
    private static final p fT = new p();
    private static final FormulaFunctionArgumentDefinition[][] fU = new FormulaFunctionArgumentDefinition[][]{{CommonArguments.settlementDate, CommonArguments.maturityDate, CommonArguments.price, CommonArguments.redemptionValue}, {CommonArguments.settlementDate, CommonArguments.maturityDate, CommonArguments.price, CommonArguments.redemptionValue, CommonArguments.basis}};
    private static final FormulaFunctionDefinition[] fV = new FormulaFunctionDefinition[]{new a(fU[0]), new a(fU[1])};

    private p() {
    }

    public static p aU() {
        return fT;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        return fV[n2];
    }

    public int getNFunctionInstances() {
        return fV.length;
    }

    private static class a
    extends FormulaFunctionBase {
        public a(FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
            super("YieldDisc", "yielddisc", formulaFunctionArgumentDefinitionArray);
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            int n2;
            double d10;
            double d11;
            if (formulaValueReferenceArray[0].getFormulaValue() != null && formulaValueReferenceArray[1].getFormulaValue() != null) {
                DateValue dateValue = ((DateTimeValue)formulaValueReferenceArray[0].getFormulaValue()).getDateValue();
                DateValue dateValue2 = ((DateTimeValue)formulaValueReferenceArray[1].getFormulaValue()).getDateValue();
                if (dateValue.getCRDate() >= dateValue2.getCRDate()) {
                    String[] stringArray = new String[]{"maturityDate", "settlementDate"};
                    throw new FormulaFunctionArgumentException("JRC00002338", "", FormulaResources.a(), "BadOrder", stringArray, 1);
                }
            }
            if (formulaValueReferenceArray[2].getFormulaValue() != null && (d11 = ((NumericValue)formulaValueReferenceArray[2].getFormulaValue()).getDouble()) <= 0.0) {
                throw new FormulaFunctionArgumentException("JRC00002339", "", FormulaResources.a(), "ArgumentOutOfRange", 2);
            }
            if (formulaValueReferenceArray[3].getFormulaValue() != null && (d10 = ((NumericValue)formulaValueReferenceArray[3].getFormulaValue()).getDouble()) <= 0.0) {
                throw new FormulaFunctionArgumentException("JRC00002340", "", FormulaResources.a(), "ArgumentOutOfRange", 3);
            }
            if (formulaValueReferenceArray.length == 5 && formulaValueReferenceArray[4].getFormulaValue() != null && ((n2 = ((NumberValue)formulaValueReferenceArray[4].getFormulaValue()).getInt()) < 0 || n2 > 4)) {
                throw new FormulaFunctionArgumentException("JRC00002341", "", FormulaResources.a(), "ArgumentOutOfRange", 4);
            }
            return FormulaValueType.number;
        }

        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            this.validate(formulaValueReferenceArray, formulaEnvironment);
            DateValue dateValue = ((DateTimeValue)formulaValueReferenceArray[0].getFormulaValue()).getDateValue();
            DateValue dateValue2 = ((DateTimeValue)formulaValueReferenceArray[1].getFormulaValue()).getDateValue();
            double d10 = ((NumericValue)formulaValueReferenceArray[2].getFormulaValue()).getScaledDouble();
            double d11 = ((NumericValue)formulaValueReferenceArray[3].getFormulaValue()).getScaledDouble();
            an an2 = an.do;
            if (formulaValueReferenceArray.length == 5) {
                int n2 = ((NumberValue)formulaValueReferenceArray[4].getFormulaValue()).getInt();
                an2 = an.a(n2);
            }
            double[] dArray = ae.a(dateValue, dateValue2, an2);
            int n3 = (int)dArray[0];
            double d12 = dArray[1];
            double d13 = (d11 - d10) / d10 * d12 / (double)n3;
            return NumberValue.fromDouble((double)d13);
        }
    }
}

