/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formattedlinemodel;

import com.crystaldecisions.reports.common.enums.AreaPairKind;

public class LMTypes {

    public static final class LMOptionStrings {
        public static final String verticalDelta = "VerticalDelta";
        public static final String useShortestObjectForDelta = "UseShortestObjectForDelta";
        public static final String alignToBaseLine = "AlignToBaseLine";
        public static final String includeImages = "IncludeImages";
        public static final String minimumBaseLineInterval = "MinimumBaseLineInterval";
        public static final String includeSuppressedObjects = "IncludeSuppressedObjects";
        public static final String minimumObjectWidth = "MinimumObjectWidth";
        public static final String minimumObjectHeight = "MinimumObjectHeight";
        public static final String resolveOverlaps = "ResolveOverlaps";
        public static final String constrainSubreportToBoundary = "ConstrainSubreport";
        public static final String useObjectGrouping = "UseObjectGrouping";
        public static final String characterWidth = "CharacterWidth";
        public static final String lineHeight = "LineHeight";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LMSectionType {
        LMST_UNKNOWN,
        LMST_PAGEHEADER,
        LMST_PAGEFOOTER,
        LMST_PAGEBODY,
        LMST_REPORTHEADER,
        LMST_REPORTFOOTER;


        public static final LMSectionType fromAreaPairKind(AreaPairKind areaPairKind, boolean bl2) {
            if (areaPairKind == AreaPairKind.detail || areaPairKind == AreaPairKind.group) {
                return LMST_PAGEBODY;
            }
            if (areaPairKind == AreaPairKind.page && bl2) {
                return LMST_PAGEHEADER;
            }
            if (areaPairKind == AreaPairKind.page && !bl2) {
                return LMST_PAGEFOOTER;
            }
            if (areaPairKind == AreaPairKind.report && bl2) {
                return LMST_REPORTHEADER;
            }
            if (areaPairKind == AreaPairKind.report && !bl2) {
                return LMST_REPORTFOOTER;
            }
            return LMST_UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LMAreaType {
        LMPageHeader,
        LMPageFooter,
        LMReportHeader,
        LMReportFooter,
        LMPageBody;

    }

    public static final class LMModelPageFlags {
        public static final int _processPageBody = 0;
        public static final int _processPageArea = 1;
        public static final int _separatePageArea = 2;
        public static final int _processReportArea = 4;
        public static final int _separateReportArea = 8;
        public static final int _processAllTogether = 5;
        public static final LMModelPageFlags processPageBody = new LMModelPageFlags(0);
        public static final LMModelPageFlags processPageArea = new LMModelPageFlags(1);
        public static final LMModelPageFlags separatePageArea = new LMModelPageFlags(2);
        public static final LMModelPageFlags processReportArea = new LMModelPageFlags(4);
        public static final LMModelPageFlags separateReportArea = new LMModelPageFlags(8);
        public static final LMModelPageFlags processAllTogether = new LMModelPageFlags(5);
        private final int a;

        private LMModelPageFlags(int n2) {
            this.a = n2;
        }

        public int value() {
            return this.a;
        }

        public static final LMModelPageFlags fromInt(int n2) {
            switch (n2) {
                case 0: {
                    return processPageBody;
                }
                case 1: {
                    return processPageArea;
                }
                case 2: {
                    return separatePageArea;
                }
                case 4: {
                    return processReportArea;
                }
                case 8: {
                    return separateReportArea;
                }
                case 5: {
                    return processAllTogether;
                }
            }
            throw new IndexOutOfBoundsException("invalid enum index");
        }

        public final String toString() {
            switch (this.a) {
                case 0: {
                    return "processPageBody";
                }
                case 1: {
                    return "processPageArea";
                }
                case 2: {
                    return "separatePageArea";
                }
                case 4: {
                    return "processReportArea";
                }
                case 8: {
                    return "separateReportArea";
                }
                case 5: {
                    return "processAllTogether";
                }
            }
            return "unknown";
        }
    }

    public static final class LMPageContentDescriptionFlags {
        public static final int LMPAGE_HAS_PAGE_HEADER = 1;
        public static final int LMPAGE_HAS_PAGE_FOOTER = 2;
        public static final int LMPAGE_HAS_REPORT_HEADER = 4;
        public static final int LMPAGE_HAS_REPORT_FOOTER = 8;
        public static final int LMPAGE_HAS_PAGE_BODY = 16;
    }
}

