/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.archive;

import com.crystaldecisions.reports.common.CommonResources;
import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IGetIdForObject;
import com.crystaldecisions.reports.common.archive.ITslvOutputRecordArchive;
import com.crystaldecisions.reports.common.archive.OutputRecordArchive;
import com.crystaldecisions.reports.common.archive.RecordType;
import com.crystaldecisions.reports.common.archive.TslvRecord;
import com.crystaldecisions.reports.common.encryption.EncryptionInfo;
import com.crystaldecisions.reports.common.encryption.RijndaelEncryptionOutputStream;
import com.crystaldecisions.reports.common.filemanagement.RandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.RandomAccessStorages;
import com.crystaldecisions.reports.common.filemanagement.SeekableDataOutput;
import com.crystaldecisions.reports.common.filemanagement.StreamBuilder;
import com.crystaldecisions.reports.common.filemanagement.UTF8Codec;
import com.crystaldecisions.reports.common.value.ColourValue;
import com.crystaldecisions.reports.common.value.DateValue;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TslvOutputRecordArchive
extends OutputRecordArchive
implements ITslvOutputRecordArchive {
    protected int d = 0;
    protected SeekableDataOutput g = null;
    protected boolean i = false;
    protected boolean m = false;
    protected boolean h = false;
    protected byte b = 0;
    private boolean void = false;
    protected boolean j = true;
    protected StreamBuilder.StreamOptions l = null;
    protected long f = 0L;
    private static final byte[] c = new byte[]{0, 0, 0, 1, 0};
    private byte[] e = new byte[2048];
    private static final Logger k = Logger.getLogger((String)"com.crystaldecisions.reports.common.archive");

    public TslvOutputRecordArchive(SeekableDataOutput seekableDataOutput, int n2) {
        this.g = seekableDataOutput;
        this.d = n2;
        this.l = new StreamBuilder.StreamOptions();
    }

    protected TslvOutputRecordArchive() {
    }

    public void setAlwaysWriteSchema(boolean bl2) {
        this.i = bl2;
    }

    public boolean getAlwaysWriteSchema() {
        return this.i;
    }

    public boolean getWriteStringsUsingEnhancedFormat() {
        return true;
    }

    public void setUseSimpleEncryption(boolean bl2) {
        this.m = bl2;
    }

    public boolean getUseSimpleEncryption() {
        return this.m;
    }

    public boolean getWriteObjectIDs() {
        return this.h;
    }

    public void setWriteObjectIDs(boolean bl2) {
        this.h = bl2;
    }

    public boolean get32bitEnums() {
        return this.void;
    }

    public void set32bitEnums(boolean bl2) {
        this.void = bl2;
    }

    public boolean getAllowShortLengthFields() {
        return this.j;
    }

    public void setAllowShortLengthFields(boolean bl2) {
        this.j = bl2;
    }

    protected TslvRecord do() throws ArchiveException {
        if (this.goto.empty()) {
            assert (false);
            throw new ArchiveException("JRC00001535", "", CommonResources.getFactory(), "NoCurrentRecord");
        }
        assert (this.goto.peek() instanceof TslvRecord);
        return (TslvRecord)this.goto.peek();
    }

    public int getDefaultSchema() {
        return this.d;
    }

    public void close() throws ArchiveException {
        super.close();
        try {
            if (this.g != null) {
                this.g.close();
            }
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001536", "", iOException);
        }
    }

    public void startRecord(RecordType recordType, int n2, int n3, int n4) throws ArchiveException {
        if (recordType == null) {
            throw new NullPointerException();
        }
        assert (recordType.if != 0);
        this.a(recordType.if, n2, n3, n4);
    }

    public void startRecord(int n2, int n3, int n4) throws ArchiveException {
        this.a(n2, n3, n4, 0);
    }

    protected void a(int n2, int n3, int n4, int n5) throws ArchiveException {
        boolean bl2;
        boolean bl3 = false;
        if (n4 < 0 || n4 > 4 || n4 == 3) {
            throw new IllegalArgumentException();
        }
        if (!(n4 != 1 && n4 != 2 || this.j)) {
            n4 = 4;
        }
        if (n2 > 1023) {
            bl3 = true;
        }
        int n6 = 0xFF & n2 >> 8;
        int n7 = 0xFF & n2;
        int n8 = 0;
        boolean bl4 = false;
        if (n4 == 4) {
            n8 |= 0xC0;
        } else if (n4 == 2) {
            n8 |= 0x80;
        } else if (n4 == 1) {
            n8 |= 0x40;
        }
        boolean bl5 = bl2 = n3 != this.getDefaultSchema() || this.getAlwaysWriteSchema();
        if (bl2) {
            n8 |= 0x20;
        }
        if (this.getWriteStringsUsingEnhancedFormat()) {
            n8 |= 0x10;
        }
        if (this.getUseSimpleEncryption()) {
            n8 |= 8;
        }
        if (bl3) {
            n8 |= 4;
        } else {
            n6 |= n8;
        }
        if (bl3) {
            this.storeInt8u(null, n8);
            this.storeInt8u(null, 0);
        }
        this.storeInt8u(null, n6);
        this.storeInt8u(null, n7);
        if (bl2) {
            this.storeInt16u(null, n3);
        }
        switch (n4) {
            case 1: {
                this.storeInt8u(null, 0);
                break;
            }
            case 2: {
                this.storeInt16u(null, 0);
                break;
            }
            case 4: {
                this.storeInt32(null, 0);
            }
        }
        if (this.getUseSimpleEncryption()) {
            this.b = (byte)(this.b ^ (byte)n2);
        }
        long l2 = 0L;
        try {
            l2 = this.g.getFilePointer();
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001537", "", iOException);
        }
        TslvRecord tslvRecord = this.a(n3);
        tslvRecord.if = l2;
        tslvRecord.int = n4;
        tslvRecord.do = this.getUseSimpleEncryption() ? (byte)n2 : (byte)0;
        this.if(tslvRecord);
        if (this.h) {
            this.storeInt32(null, n5);
        }
    }

    public void endRecord() throws ArchiveException {
        try {
            long l2 = 0L;
            int n2 = 0;
            long l3 = 0L;
            int n3 = 0;
            TslvRecord tslvRecord = this.do();
            l2 = tslvRecord.if;
            n2 = tslvRecord.int;
            this.b = (byte)(this.b ^ tslvRecord.do);
            l3 = this.g.getFilePointer();
            assert (l3 - l2 < Integer.MAX_VALUE);
            n3 = (int)(l3 - l2);
            if (n2 == 0) {
                if (this.h ? !long && n3 != 4 : !long && n3 != 0) {
                    throw new AssertionError();
                }
            } else {
                this.g.seek(l2 - (long)n2);
                switch (n2) {
                    case 1: {
                        assert (n3 < 255);
                        this.storeInt8u(null, n3);
                        break;
                    }
                    case 2: {
                        assert (n3 < 65535);
                        this.storeInt16u(null, n3);
                        break;
                    }
                    case 4: {
                        this.storeInt32(null, n3);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.g.seek(l3);
            }
            this.if();
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001538", "", iOException);
        }
    }

    public void startCollection(RecordType recordType, int n2, int n3) throws ArchiveException {
        this.storeInt32(null, n2);
    }

    public void endCollection() throws ArchiveException {
    }

    public void storeString(String string, String string2) throws ArchiveException {
        this.storeString(string2);
    }

    public void storeString(String string) throws ArchiveException {
        if (this.g == null) {
            throw new ArchiveException("JRC00001539", "", CommonResources.getFactory(), "InvalidOutputStream");
        }
        try {
            if (string == null) {
                this.g.writeInt(0);
            } else if (string.length() == 0) {
                this.g.write(c);
            } else {
                int n2 = string.length();
                byte[] byArray = this.e;
                if (this.e.length < n2 * 3) {
                    byArray = new byte[n2 * 3];
                }
                int n3 = UTF8Codec.encode((String)string, (byte[])byArray, (int)0);
                this.g.writeInt(n3 + 1);
                this.g.write(byArray, 0, n3);
                this.g.writeByte(0);
            }
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001540", "", iOException);
        }
    }

    public void storeInt8s(String string, int n2) throws ArchiveException {
        this.storeInt8s(n2);
    }

    public void storeInt8s(int n2) throws ArchiveException {
        if (this.g == null) {
            throw new ArchiveException("JRC00001541", "", CommonResources.getFactory(), "InvalidOutputStream");
        }
        try {
            this.g.writeByte(n2);
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001542", "", iOException);
        }
    }

    public void storeInt8u(String string, int n2) throws ArchiveException {
        this.storeInt8u(n2);
    }

    public void storeInt8u(int n2) throws ArchiveException {
        if (this.g == null) {
            throw new ArchiveException("JRC00001543", "", CommonResources.getFactory(), "InvalidOutputStream");
        }
        try {
            this.g.writeByte(n2);
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001544", "", iOException);
        }
    }

    public void storeInt16s(String string, int n2) throws ArchiveException {
        this.storeInt16s(n2);
    }

    public void storeInt16s(int n2) throws ArchiveException {
        if (this.g == null) {
            throw new ArchiveException("JRC00001545", "", CommonResources.getFactory(), "InvalidOutputStream");
        }
        try {
            this.g.writeShort(n2);
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001546", "", iOException);
        }
    }

    public void storeInt16u(String string, int n2) throws ArchiveException {
        this.storeInt16u(n2);
    }

    public void storeInt16u(int n2) throws ArchiveException {
        if (this.g == null) {
            throw new ArchiveException("JRC00001547", "", CommonResources.getFactory(), "InvalidOutputStream");
        }
        try {
            this.g.writeShort(n2);
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001548", "", iOException);
        }
    }

    public void storeInt32(String string, int n2) throws ArchiveException {
        this.storeInt32(n2);
    }

    public void storeInt32(int n2) throws ArchiveException {
        if (this.g == null) {
            throw new ArchiveException("JRC00001549", "", CommonResources.getFactory(), "InvalidOutputStream");
        }
        try {
            this.g.writeInt(n2);
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001550", "", iOException);
        }
    }

    public void storeInt64(String string, long l2) throws ArchiveException {
        this.storeInt64(l2);
    }

    public void storeInt64(long l2) throws ArchiveException {
        if (this.g == null) {
            throw new ArchiveException("JRC00001551", "", CommonResources.getFactory(), "InvalidOutputStream");
        }
        try {
            this.g.writeLong(l2);
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001552", "", iOException);
        }
    }

    public void storeDouble(String string, double d10) throws ArchiveException {
        this.storeDouble(d10);
    }

    public void storeDouble(double d10) throws ArchiveException {
        if (this.g == null) {
            throw new ArchiveException("JRC00001553", "", CommonResources.getFactory(), "InvalidOutputStream");
        }
        try {
            this.g.writeDouble(d10);
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001554", "", iOException);
        }
    }

    public void storeBoolean(String string, boolean bl2) throws ArchiveException {
        this.storeBoolean(bl2);
    }

    public void storeBoolean(boolean bl2) throws ArchiveException {
        this.storeInt16u(bl2 ? 1 : 0);
    }

    public void storeBinary(String string, byte[] byArray) throws ArchiveException {
        this.storeInt32(byArray == null ? 0 : byArray.length);
        this.storeBlock(byArray);
    }

    public void storeBlock(byte[] byArray) throws ArchiveException {
        if (this.g == null) {
            throw new ArchiveException("JRC00001555", "", CommonResources.getFactory(), "InvalidOutputStream");
        }
        try {
            if (byArray != null && byArray.length > 0) {
                this.g.write(byArray);
            }
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001556", "", iOException);
        }
    }

    public void storeInt16Compressed(String string, int n2) throws ArchiveException {
        this.storeInt16Compressed(n2);
    }

    public void storeInt16Compressed(int n2) throws ArchiveException {
        if (n2 < 0) {
            if (k.isDebugEnabled()) {
                k.debug((Object)("storeInt16Compressed: value is < 0:  " + n2));
            }
            n2 = 0;
        }
        if (n2 > 127) {
            this.storeInt16u(n2 |= 0x8000);
        } else {
            this.storeInt8u(n2);
        }
    }

    public void storeInt32Compressed(String string, int n2) throws ArchiveException {
        this.storeInt32Compressed(n2);
    }

    public void storeInt32Compressed(int n2) throws ArchiveException {
        if (n2 < 0) {
            if (k.isDebugEnabled()) {
                k.debug((Object)("storeInt32Compressed: value is < 0:  " + n2));
            }
            n2 = 0;
        }
        if (n2 > Short.MAX_VALUE) {
            this.storeInt32(n2 |= Integer.MIN_VALUE);
        } else {
            this.storeInt16u(n2);
        }
    }

    public void storeEnum(int n2) throws ArchiveException {
        if (this.void) {
            this.storeInt32(null, n2);
        } else {
            this.storeInt16Compressed(null, n2);
        }
    }

    public void storeEnum(String string, int n2, Map map) throws ArchiveException {
        this.storeEnum(n2);
    }

    public void storeValue(String string, Object object, IGetIdForObject iGetIdForObject) throws ArchiveException {
        this.storeValue(object, iGetIdForObject);
    }

    public void storeValue(Object object, IGetIdForObject iGetIdForObject) throws ArchiveException {
        if (object == null) {
            this.storeInt16u(0);
        } else if (object instanceof String) {
            this.storeInt16u(8);
            this.storeString((String)object);
        } else if (object instanceof Short) {
            this.storeInt16u(2);
            this.storeInt16s(((Short)object).shortValue());
        } else if (object instanceof Integer) {
            this.storeInt16u(3);
            this.storeInt32((Integer)object);
        } else if (object instanceof Byte) {
            this.storeInt16u(16);
            this.storeInt8s(((Byte)object).byteValue());
        } else if (object instanceof Character) {
            this.storeInt16u(18);
            this.storeInt16u(((Character)object).charValue());
        } else if (object instanceof Long) {
            this.storeInt16u(20);
            this.storeInt64((Long)object);
        } else if (object instanceof Double) {
            this.storeInt16u(5);
            this.storeDouble((Double)object);
        } else if (object instanceof Float) {
            this.storeInt16u(4);
            this.storeDouble(((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            this.storeInt16u(11);
            this.storeBoolean((Boolean)object);
        } else if (object instanceof Date) {
            this.storeInt16u(7);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            double d10 = DateValue.fromCalendar((Calendar)calendar).getOleDate();
            this.storeDouble(d10);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            this.storeInt16u(14);
            this.storeInt8u(bigDecimal.scale());
            this.storeInt8u(bigDecimal.signum() < 0 ? 128 : 0);
            BigInteger bigInteger = bigDecimal.unscaledValue();
            if (bigInteger.signum() < 0) {
                bigInteger = bigInteger.negate();
            }
            if (bigInteger.bitLength() > 96) assert (false);
            assert (false) : "BigDecimal not supported.";
            this.storeInt32(0);
            this.storeInt64(0L);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.storeInt16u(8209);
            this.storeInt32(byArray.length);
            this.storeBlock(byArray);
        } else {
            int n2 = 0;
            if (iGetIdForObject != null) {
                n2 = iGetIdForObject.char(object);
            }
            this.storeInt16u(13);
            this.storeInt32(n2);
        }
    }

    public void storeColour(String string, Color color) throws ArchiveException {
        this.storeColour(color);
    }

    public void storeColour(Color color) throws ArchiveException {
        int n2 = ColourValue.getColorRefFromColor((Color)color);
        this.storeInt32(n2);
    }

    public byte[] UtfEncode(String string) {
        if (string == null) {
            return null;
        }
        return UTF8Codec.encode((String)string);
    }

    public EncryptionInfo storeStreamHeader() throws ArchiveException {
        this.startRecord(65535, 1792, 1);
        this.l.a.int = true;
        this.l.a.do = true;
        this.l.a.a = 256;
        this.l.a.a();
        this.storeBoolean(this.l.a.int);
        this.storeInt16u(this.l.a.a);
        this.storeBoolean(this.l.a.for);
        for (int i2 = 0; i2 < 16; ++i2) {
            this.storeInt8u(this.l.a.if[i2]);
        }
        this.storeBoolean(this.l.a.do);
        this.endRecord();
        try {
            this.f = this.g.getFilePointer();
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00003297", "", iOException);
        }
        return this.l.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToStream(RandomAccessStorage randomAccessStorage) throws IOException {
        InputStream inputStream = this.g.else();
        byte[] byArray = new byte[1024];
        long l2 = this.f;
        int n2 = this.f > (long)byArray.length ? byArray.length : (int)this.f;
        int n3 = inputStream.read(byArray, 0, n2);
        while (n3 != -1) {
            randomAccessStorage.write(byArray, 0, n3);
            if ((l2 -= (long)n3) <= 0L) break;
            n2 = l2 > (long)byArray.length ? byArray.length : (int)l2;
            n3 = inputStream.read(byArray, 0, n2);
        }
        OutputStream outputStream = RandomAccessStorages.asOutputStream((RandomAccessStorage)randomAccessStorage);
        if (this.l.a.int) {
            outputStream = new RijndaelEncryptionOutputStream(outputStream, this.l.a.new, this.l.a.if);
        }
        Deflater deflater = null;
        DeflaterOutputStream deflaterOutputStream = null;
        if (this.l.if) {
            deflater = new Deflater();
            deflaterOutputStream = new DeflaterOutputStream(outputStream, deflater);
            outputStream = deflaterOutputStream;
        }
        try {
            n3 = inputStream.read(byArray);
            while (n3 != -1) {
                outputStream.write(byArray, 0, n3);
                n3 = inputStream.read(byArray);
            }
        }
        finally {
            if (deflaterOutputStream != null) {
                deflaterOutputStream.finish();
            }
            outputStream.flush();
            if (deflater != null) {
                deflater.end();
            }
        }
    }
}

