/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.client.helper;

import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ResourceManager {
    private static Hashtable m_ResourceBundles = new Hashtable();

    public static ResourceBundle getResource(String baseName, Locale locale) {
        ResourceBundle res;
        String countryName;
        if (baseName == null) {
            return null;
        }
        Locale defaultLocale = Locale.ENGLISH;
        if (locale == null) {
            locale = defaultLocale;
        }
        String lanName = locale.getLanguage();
        String searchName = baseName + "_" + lanName;
        if (lanName != null && lanName.equalsIgnoreCase("zh") && (countryName = locale.getCountry()) != null && countryName.length() > 0) {
            if ((countryName = countryName.toUpperCase()).equals("TW") || countryName.equals("HK") || countryName.equals("MO") || countryName.equals("MY") || countryName.equals("HANT")) {
                searchName = searchName + "_TW";
                locale = Locale.TRADITIONAL_CHINESE;
            } else if (countryName.equals("CN") || countryName.equals("SG") || countryName.equals("HANS")) {
                searchName = searchName + "_CN";
                locale = Locale.SIMPLIFIED_CHINESE;
            }
        }
        if ((res = (ResourceBundle)m_ResourceBundles.get(searchName)) == null) {
            try {
                res = ResourceBundle.getBundle(baseName, locale);
            }
            catch (MissingResourceException e10) {
                res = ResourceBundle.getBundle(baseName, defaultLocale);
            }
            m_ResourceBundles.put(searchName, res);
        }
        return res;
    }

    public static String getString(String baseName, String key, Locale locale) throws MissingResourceException {
        ResourceBundle res = ResourceManager.getResource(baseName, locale);
        return res.getString(key);
    }
}

