/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.sdk.builder;

import com.businessobjects.reports.datamodel.IDFFieldLink;
import com.businessobjects.reports.datamodel.IDFTableJoin;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.RangeValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import com.crystaldecisions.sdk.occa.report.data.FieldLinkOperator;
import com.crystaldecisions.sdk.occa.report.data.FieldValueType;
import com.crystaldecisions.sdk.occa.report.data.IConstantValue;
import com.crystaldecisions.sdk.occa.report.data.IParameterFieldDiscreteValue;
import com.crystaldecisions.sdk.occa.report.data.IParameterFieldRangeValue;
import com.crystaldecisions.sdk.occa.report.data.RangeValueBoundType;
import com.crystaldecisions.sdk.occa.report.data.TableJoinEnforced;
import com.crystaldecisions.sdk.occa.report.data.TableJoinOperator;
import com.crystaldecisions.sdk.occa.report.data.Value;
import java.util.Calendar;
import java.util.Date;

public final class TypeConverter {
    private TypeConverter() {
    }

    public static ValueType a(FieldValueType fieldValueType) {
        switch (fieldValueType.value()) {
            case 0: {
                return ValueType.int8s;
            }
            case 1: {
                return ValueType.int8u;
            }
            case 2: {
                return ValueType.int16s;
            }
            case 3: {
                return ValueType.int16u;
            }
            case 4: {
                return ValueType.int32s;
            }
            case 5: {
                return ValueType.int32u;
            }
            case 6: {
                return ValueType.number;
            }
            case 7: {
                return ValueType.currency;
            }
            case 8: {
                return ValueType.bool;
            }
            case 9: {
                return ValueType.date;
            }
            case 10: {
                return ValueType.time;
            }
            case 15: {
                return ValueType.dateTime;
            }
            case 11: {
                return ValueType.string;
            }
            case 13: {
                return ValueType.memo;
            }
            case 14: {
                return ValueType.blob;
            }
            case 255: {
                return ValueType.unknown;
            }
        }
        assert (false) : "Unable to Map to value Type";
        throw new IllegalArgumentException();
    }

    public static IDFFieldLink.LinkType a(FieldLinkOperator fieldLinkOperator) {
        switch (fieldLinkOperator.value()) {
            case 4: {
                return IDFFieldLink.LinkType.new;
            }
            case 8: {
                return IDFFieldLink.LinkType.if;
            }
            case 16: {
                return IDFFieldLink.LinkType.byte;
            }
            case 32: {
                return IDFFieldLink.LinkType.void;
            }
            case 64: {
                return IDFFieldLink.LinkType.case;
            }
            case 128: {
                return IDFFieldLink.LinkType.goto;
            }
            case 1: {
                return IDFFieldLink.LinkType.int;
            }
            case 2: {
                return IDFFieldLink.LinkType.try;
            }
            case 256: {
                return IDFFieldLink.LinkType.long;
            }
            case 512: {
                return IDFFieldLink.LinkType.a;
            }
            case 1024: {
                return IDFFieldLink.LinkType.else;
            }
            case 2048: {
                return IDFFieldLink.LinkType.for;
            }
        }
        assert (false) : "Invalid FieldLinkOperator passed to conversion";
        throw new IllegalArgumentException();
    }

    public static CrystalValue a(FieldValueType fieldValueType, Object object) {
        if (object == null) {
            return null;
        }
        switch (fieldValueType.value()) {
            case 11: {
                return StringValue.fromString((String)((String)object));
            }
            case 6: {
                return NumberValue.fromDouble((double)((Number)object).doubleValue());
            }
            case 7: {
                return CurrencyValue.fromDouble((double)((Number)object).doubleValue());
            }
            case 8: {
                return BooleanValue.fromBoolean((boolean)((Boolean)object));
            }
            case 9: {
                Date date = (Date)object;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return DateValue.fromYMD((int)calendar.get(1), (int)(calendar.get(2) + 1), (int)calendar.get(5));
            }
            case 10: {
                Date date = (Date)object;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return TimeValue.fromHMSN((int)calendar.get(11), (int)calendar.get(12), (int)calendar.get(13), (long)(calendar.get(14) * 1000000));
            }
            case 15: {
                Date date = (Date)object;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                DateValue dateValue = DateValue.fromYMD((int)calendar.get(1), (int)(calendar.get(2) + 1), (int)calendar.get(5));
                TimeValue timeValue = TimeValue.fromHMSN((int)calendar.get(11), (int)calendar.get(12), (int)calendar.get(13), (long)(calendar.get(14) * 1000000));
                return DateTimeValue.fromDateAndTimeValues((DateValue)dateValue, (TimeValue)timeValue);
            }
        }
        assert (false) : "Unable to convert from CrystalValue";
        throw new IllegalArgumentException();
    }

    public static IDFTableJoin.EnforceType a(TableJoinEnforced tableJoinEnforced) {
        if (tableJoinEnforced == null) {
            return null;
        }
        switch (tableJoinEnforced.value()) {
            case 8: {
                return IDFTableJoin.EnforceType.if;
            }
            case 2: {
                return IDFTableJoin.EnforceType.int;
            }
            case 1: {
                return IDFTableJoin.EnforceType.a;
            }
            case 4: {
                return IDFTableJoin.EnforceType.for;
            }
        }
        assert (false) : "invalid TableJoinEnforced type";
        return null;
    }

    public static IDFTableJoin.JoinType a(TableJoinOperator tableJoinOperator) {
        if (tableJoinOperator == null) {
            return null;
        }
        switch (tableJoinOperator.value()) {
            case 32: {
                return IDFTableJoin.JoinType.try;
            }
            case 8: {
                return IDFTableJoin.JoinType.new;
            }
            case 1: {
                return IDFTableJoin.JoinType.if;
            }
            case 2: {
                return IDFTableJoin.JoinType.byte;
            }
            case 64: {
                return IDFTableJoin.JoinType.do;
            }
            case 256: {
                return IDFTableJoin.JoinType.for;
            }
            case 4: {
                return IDFTableJoin.JoinType.else;
            }
            case 128: {
                return IDFTableJoin.JoinType.case;
            }
            case 512: {
                return IDFTableJoin.JoinType.a;
            }
            case 16: {
                return IDFTableJoin.JoinType.goto;
            }
        }
        assert (false) : "invalid TableJoinOperator";
        return null;
    }

    public static CrystalValue a(Value value, FieldValueType fieldValueType) {
        if (value instanceof IParameterFieldDiscreteValue) {
            IParameterFieldDiscreteValue iParameterFieldDiscreteValue = (IParameterFieldDiscreteValue)((Object)value);
            CrystalValue crystalValue = TypeConverter.a(fieldValueType, iParameterFieldDiscreteValue.getValue());
            return crystalValue;
        }
        if (value instanceof IParameterFieldRangeValue) {
            IParameterFieldRangeValue iParameterFieldRangeValue = (IParameterFieldRangeValue)((Object)value);
            CrystalValue crystalValue = TypeConverter.a(fieldValueType, iParameterFieldRangeValue.getBeginValue());
            CrystalValue crystalValue2 = TypeConverter.a(fieldValueType, iParameterFieldRangeValue.getEndValue());
            RangeValue rangeValue = RangeValue.fromStartAndEndValues((FormulaValue)((FormulaValue)crystalValue), (FormulaValue)((FormulaValue)crystalValue2), (iParameterFieldRangeValue.getLowerBoundType() == RangeValueBoundType.inclusive ? 1 : 0) != 0, (iParameterFieldRangeValue.getUpperBoundType() == RangeValueBoundType.inclusive ? 1 : 0) != 0);
            return rangeValue;
        }
        if (value instanceof IConstantValue) {
            IConstantValue iConstantValue = (IConstantValue)((Object)value);
            CrystalValue crystalValue = TypeConverter.a(fieldValueType, iConstantValue.getValue());
            return crystalValue;
        }
        return null;
    }
}

