/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.Interpolation2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix4d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.Sphere3D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class SphereView {
    private boolean isVisible = false;
    private boolean m_bInverseProjectionOK = true;
    private JChart_3D m_chart;
    private transient Point3d sphereCenter;
    private double fViewRadius;
    private double fViewAngleCos;
    private double fViewAngleSin;
    private double fViewY;
    private Point3d viewerPoint;
    private transient Sphere3D sphere;
    private Point3d[] vertices = null;

    public SphereView(Sphere3D sphere, JChart_3D chart, Point3d bottomCenter) {
        this.sphere = sphere;
        this.m_chart = chart;
        this.sphereCenter = bottomCenter;
        this.sphereCenter.y += sphere.getRadius();
        Point3d viewer = this.m_chart.getViewerInWorldCoordinates();
        double fVX = viewer.x - this.sphereCenter.x;
        double fVY = viewer.y - this.sphereCenter.y;
        double fVZ = viewer.z - this.sphereCenter.z;
        this.viewerPoint = new Point3d(fVX, fVY, fVZ);
        double temp = fVX * fVX + fVZ * fVZ;
        double fViewRadius = Math.sqrt(temp);
        double fViewDist = Math.sqrt(temp + fVY * fVY);
        boolean isRadiusNonZero = FP.nonzero(fViewRadius);
        this.fViewAngleCos = isRadiusNonZero ? fVX / fViewRadius : 0.0;
        double d = this.fViewAngleSin = isRadiusNonZero ? fVZ / fViewRadius : 0.0;
        this.fViewY = isRadiusNonZero ? fVY / fViewRadius : (fVY >= 0.0 ? 1.0 : -1.0);
        this.fViewRadius = fViewRadius;
        double fSphereRadius = sphere.getRadius();
        boolean bl = this.isVisible = fViewDist > fSphereRadius;
        if (this.isVisible) {
            int nLength = sphere.getVerticesLength();
            this.vertices = new Point3d[nLength];
            Matrix3d trans = new Matrix3d();
            trans.rotZ(fVY / fViewDist, fViewRadius / fViewDist);
            trans.rotY(-this.fViewAngleCos, this.fViewAngleSin);
            double r2 = fSphereRadius * fSphereRadius;
            double fCircleDist = r2 / fViewDist;
            double fCircleRadius = Math.sqrt(r2 - fCircleDist * fCircleDist);
            Point3d p = null;
            for (int i = 0; i < nLength; ++i) {
                p = new Point3d(fCircleRadius * sphere.cos[i], fCircleDist, fCircleRadius * sphere.sin[i]);
                trans.transformPoint3d(p, p);
                this.transformUserToCamera(p);
                this.vertices[i] = p;
            }
        }
    }

    public final double getViewerDistance() {
        return this.fViewRadius;
    }

    public final Point3d[] getVertices() {
        return this.vertices;
    }

    public final double getSphereRadius() {
        return this.sphere.getRadius();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void getLightDirection(Point3d point) {
        point.x = this.fViewAngleCos * this.fViewRadius;
        point.y = this.fViewY * this.fViewRadius;
        point.z = this.fViewAngleSin * this.fViewRadius;
        SphereView.rotatePoint(point, 0.7853981633974483);
    }

    public final void getBrightestPoint(Point3d point) {
        this.getLightDirection(point);
        double r = this.sphere.getRadius() / point.norm();
        point.x *= r;
        point.y *= r;
        point.z *= r;
        this.transformUserToCamera(point);
    }

    public Point getBrightestPoint() {
        Point3d point = new Point3d();
        this.getBrightestPoint(point);
        return this.m_chart.projectPoint3d(point);
    }

    final void rotatePoint(Point3d point) {
        double fX = this.fViewAngleCos;
        double fZ = this.fViewAngleSin;
        double pointX = point.x;
        double pointZ = point.z;
        point.x = fX * pointX - fZ * pointZ;
        point.z = fZ * pointX + fX * pointZ;
    }

    static void rotatePoint(Point3d point, double angle) {
        double fX = Math.cos(angle);
        double fZ = Math.sin(angle);
        double pointX = point.x;
        double pointZ = point.z;
        point.x = fX * pointX - fZ * pointZ;
        point.z = fZ * pointX + fX * pointZ;
    }

    final void transformUserToWorld(Point3d point) {
        point.x += this.sphereCenter.x;
        point.y += this.sphereCenter.y;
        point.z += this.sphereCenter.z;
    }

    final void transformUserToCamera(Point3d point) {
        point.x += this.sphereCenter.x;
        point.y += this.sphereCenter.y;
        point.z += this.sphereCenter.z;
        this.m_chart.transformPoint3d(point);
    }

    public Shape calcContourEllipse() {
        int nLen = this.vertices.length;
        Point2D[] points = new Point2D[nLen];
        for (int i = 0; i < nLen; ++i) {
            points[i] = this.m_chart.projectPoint3dInDouble(this.vertices[i]);
        }
        GeneralPath path = new GeneralPath();
        Interpolation2D.createSmoothPath(path, Arrays.asList(points), true);
        return path;
    }

    public Shape[] calcThreeEquators() {
        Shape[] equators = new Shape[3];
        Point3d[][] points3d = this.sphere.calcThreeEquators();
        int nLen = this.sphere.getVerticesLength();
        for (int j = 0; j < 3; ++j) {
            Object[] points2d = new Point2D[nLen];
            for (int i = 0; i < nLen; ++i) {
                Point3d p = points3d[j][i];
                if (!this.isVisible(p)) continue;
                this.transformUserToCamera(p);
                points2d[i] = this.m_chart.projectPoint3dInDouble(p);
            }
            GeneralPath path = new GeneralPath();
            Interpolation2D.createPolygon(path, points2d, true);
            equators[j] = path;
        }
        return equators;
    }

    boolean isVisible(Point3d p) {
        double scalarProduct = p.x * (this.viewerPoint.x - p.x) + p.y * (this.viewerPoint.y - p.y) + p.z * (this.viewerPoint.z - p.z);
        return scalarProduct >= 0.0;
    }

    public void setInverseProjectionOK(boolean bOK) {
        this.m_bInverseProjectionOK = bOK;
    }

    public boolean isInverseProjectionOK() {
        return this.m_bInverseProjectionOK;
    }

    public boolean inverseProjection(double x, double y, Point3d point) {
        Point3d center = new Point3d(x, y, 0.0);
        Point3d vector = new Point3d();
        if (this.m_chart.isViewForceIsometric()) {
            Matrix4d m = new Matrix4d();
            boolean isOK = this.m_chart.getInverseMatrix(m);
            if (isOK) {
                m.transformPoint3d(center, center);
            }
            vector = new Point3d(0.0, 0.0, 1.0);
            this.m_chart.getMatrix().transformCovector3d(vector, vector);
        } else {
            center.copy(this.viewerPoint);
            this.m_chart.inverseProjection(x, y, vector);
        }
        vector.normalize();
        double cv = center.mult(vector);
        double cc = center.mult(center);
        double rr = this.sphere.getRadius2();
        double delta = cv * cv + rr - cc;
        if (delta < FP.TOLERANCE) {
            this.setInverseProjectionOK(false);
            return false;
        }
        if (delta < 0.0) {
            delta = 0.0;
        }
        double s = Math.sqrt(delta) - cv;
        point.x = center.x + s * vector.x;
        point.y = center.y + s * vector.y;
        point.z = center.z + s * vector.z;
        return true;
    }

    public void test1() {
        Point3d center = new Point3d();
        this.transformUserToCamera(center);
        Point center2d = this.m_chart.projectPoint3d(center);
        int x = center2d.x + 500;
        int y = center2d.y - 700;
        Point3d direction = new Point3d();
        boolean b = this.inverseProjection(x, y, direction);
        System.out.println("found = " + b + "\tSphere radius is " + (int)this.sphere.getRadius());
        System.out.println(" sphere point is " + direction + " with norm " + (int)direction.norm());
        Point3d p = new Point3d();
        p.x = direction.x + this.sphereCenter.x;
        p.y = direction.y + this.sphereCenter.y;
        p.z = direction.z + this.sphereCenter.z;
        this.m_chart.transformPoint3d(p);
        Point2D p2D = this.m_chart.projectPoint3dInDouble(p);
        System.out.println("SphereView: screen point is " + p2D + "\nSphereView: If true - it should be " + new Point(x, y) + "\n");
    }
}

