/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.Interpolation2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;

public class Sphere3D {
    private double fRadius;
    private double fRadius2;
    private int nVerticesLength;
    protected double[] cos;
    protected double[] sin;
    protected double[] Rxcos;
    protected double[] Rxsin;

    public Sphere3D(double radius) {
        this(radius, Interpolation2D.getDefaultPointsCount());
    }

    public Sphere3D(double radius, int n) {
        this.fRadius2 = radius * radius;
        this.fRadius = radius;
        int nLen = 2 * n;
        this.cos = new double[nLen];
        this.sin = new double[nLen];
        this.Rxcos = new double[nLen];
        this.Rxsin = new double[nLen];
        double deltaAngle = Math.PI / (double)n;
        double angle = 0.0;
        for (int i = 0; i < nLen; ++i) {
            this.cos[i] = Math.cos(angle);
            this.sin[i] = Math.sin(angle);
            this.Rxcos[i] = radius * this.cos[i];
            this.Rxsin[i] = radius * this.sin[i];
            angle += deltaAngle;
        }
        this.nVerticesLength = nLen;
    }

    public final double getRadius() {
        return this.fRadius;
    }

    public final double getRadius2() {
        return this.fRadius2;
    }

    public final int getVerticesLength() {
        return this.nVerticesLength;
    }

    public Point3d[][] calcThreeEquators() {
        int nLen = this.getVerticesLength();
        Point3d[][] points = new Point3d[3][nLen];
        int i = 0;
        for (i = 0; i < nLen; ++i) {
            points[0][i] = new Point3d(0.0, this.Rxcos[i], this.Rxsin[i]);
        }
        for (i = 0; i < nLen; ++i) {
            points[1][i] = new Point3d(this.Rxcos[i], 0.0, this.Rxsin[i]);
        }
        for (i = 0; i < nLen; ++i) {
            points[2][i] = new Point3d(this.Rxcos[i], this.Rxsin[i], 0.0);
        }
        return points;
    }
}

