/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.math;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.Cubic;
import java.awt.Polygon;

public class NatCubic {
    static final int STEPS = 12;

    private NatCubic() {
    }

    static Cubic[] calcNaturalCubic(int n, int[] x) {
        int i;
        double[] gamma = new double[n + 1];
        double[] delta = new double[n + 1];
        double[] D = new double[n + 1];
        gamma[0] = 0.5;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[n] = 1.0 / (2.0 - gamma[n - 1]);
        delta[0] = (double)(3 * (x[1] - x[0])) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = ((double)(3 * (x[i + 1] - x[i - 1])) - delta[i - 1]) * gamma[i];
        }
        delta[n] = ((double)(3 * (x[n] - x[n - 1])) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], (double)(3 * (x[i + 1] - x[i])) - 2.0 * D[i] - D[i + 1], (double)(2 * (x[i] - x[i + 1])) + D[i] + D[i + 1]);
        }
        return C;
    }

    public static Polygon interpolate(Polygon polyIn) {
        Polygon polyOut = new Polygon();
        if (polyIn.npoints >= 2) {
            Cubic[] X = NatCubic.calcNaturalCubic(polyIn.npoints - 1, polyIn.xpoints);
            Cubic[] Y = NatCubic.calcNaturalCubic(polyIn.npoints - 1, polyIn.ypoints);
            polyOut.addPoint((int)Math.round(X[0].eval(0.0)), (int)Math.round(Y[0].eval(0.0)));
            for (int i = 0; i < X.length; ++i) {
                for (int j = 1; j <= 12; ++j) {
                    double u = (double)j / 12.0;
                    polyOut.addPoint((int)Math.round(X[i].eval(u)), (int)Math.round(Y[i].eval(u)));
                }
            }
        }
        return polyOut;
    }
}

