/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics;

import com.businessobjects.visualization.pfjgraphics.rendering.common.CheckParam;
import com.businessobjects.visualization.pfjgraphics.rendering.common.FontCache;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillGradientObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.SimpleBlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.IStandardDraw;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.IStandardLook;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Attr;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.ObjectID;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;

public class StandardDrawPFJ
implements IStandardDraw {
    private boolean wantOffScreen;
    private Rectangle m_rBounds;
    protected Rectangle m_rBoundsVC;
    private boolean m_bDropShadowMode;
    private boolean m_bOffscreenDirty;
    private final Set<ObjectID> m_detObjSet = new HashSet<ObjectID>();
    private int m_nGroupID = -1;
    private Perspective m_Perspective;

    public StandardDrawPFJ(boolean bWantOffScreen, Perspective p) {
        this.wantOffScreen = bWantOffScreen;
        this.m_bDropShadowMode = false;
        this.m_Perspective = p;
    }

    public boolean isOffScreenDirty() {
        return this.m_bOffscreenDirty || !this.wantOffScreen;
    }

    public void setOffScreenDirty(boolean bDirty) {
        this.m_bOffscreenDirty = bDirty;
    }

    public void drawBegin(Rectangle rBounds, IStandardLook stdLook) {
        this.m_rBoundsVC = rBounds;
        this.m_rBounds = this.m_Perspective.getVC().virtToDest(rBounds);
    }

    public void drawEnd() {
        this.setOffScreenDirty(false);
    }

    public void drawOffScreen() {
    }

    public void drawShape(Object objID, Shape shape, IStandardLook stdLook) throws IllegalArgumentException {
        this.drawShape(objID, shape, stdLook, true);
    }

    private void drawShape(Object objID, Shape shape, IStandardLook stdLook, boolean bDetectable) throws IllegalArgumentException {
        CheckParam.checkObjectID(objID);
        CheckParam.checkShape(shape);
        IdentObj id = this.setUpIdentObj(objID, bDetectable);
        IBlackBox bb = this.setUpBlackBox(objID, id, stdLook, bDetectable);
        Shape shapeVC = this.m_Perspective.getVC().destToVirtShape(shape);
        DrawFactory.createShape(this.m_Perspective.getDetectiv(), id, shapeVC, bb);
    }

    private IdentObj setUpIdentObj(Object objID, boolean bDetectable) throws ClassCastException {
        ObjectID oid = (ObjectID)objID;
        IdentObj id = bDetectable ? new IdentObj(oid.getObjectID()) : new IdentObj(oid.getObjectID());
        return id;
    }

    private IBlackBox setUpBlackBox(Object objID, IdentObj id, IStandardLook stdLook, boolean bDetectable) throws ClassCastException {
        ObjectID oid = (ObjectID)objID;
        Attr attr = (Attr)stdLook.getAttr("FillType");
        Object fillTypeObj = stdLook.getAttrValue(oid, attr);
        int fillType = (Integer)fillTypeObj;
        Attr attrDirection = (Attr)stdLook.getAttr("GradientDirection");
        Object directionObj = stdLook.getAttrValue(oid, attrDirection);
        int direction = (Integer)directionObj;
        IBlackBox bb = null;
        switch (fillType) {
            case 1: {
                bb = new BlackBoxObj(this.m_Perspective, id);
                Color fillColor = this.getFillColor(oid, stdLook);
                Color borderColor = this.getBorderColor(oid, stdLook);
                bb.setFillColor(fillColor);
                bb.setBorderColor(borderColor);
                break;
            }
            case 2: {
                FillGradientObj fillGradObj = new FillGradientObj(direction);
                Color outerColor = (Color)stdLook.getAttrValue(oid, stdLook.getAttr("FillColor"));
                fillGradObj.insertPin(0.0, outerColor, outerColor);
                Color innerColor = (Color)stdLook.getAttrValue(oid, stdLook.getAttr("BorderColor"));
                fillGradObj.insertPin(1.0, innerColor, innerColor);
                bb = new BlackBoxObj(fillGradObj, true, false, this.m_Perspective, id);
                break;
            }
            case 3: {
                bb = new BlackBoxObj(this.m_Perspective, id);
                break;
            }
            default: {
                System.out.println("unknown fill type " + fillType);
                bb = new SimpleBlackBoxObj(this.m_Perspective, id, true);
            }
        }
        return bb;
    }

    public void drawPolygon(Object objID, Polygon polygon, IStandardLook stdLook) throws IllegalArgumentException {
        CheckParam.checkObjectID(objID);
        CheckParam.checkPolygon(polygon);
        ObjectID oid = (ObjectID)objID;
        Color fillColor = this.getFillColor(oid, stdLook);
        Color borderColor = this.getBorderColor(oid, stdLook);
        IdentObj id = new IdentObj(oid.getObjectID());
        SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, id, true);
        bb.setFillColor(fillColor);
        bb.setBorderColor(borderColor);
        Polygon polygonVC = this.m_Perspective.getVC().destToVirt(polygon);
        DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), id, polygonVC, bb, null, 1.0);
    }

    public void drawRectangle(Object objID, Rectangle rect, IStandardLook stdLook) throws IllegalArgumentException {
        CheckParam.checkObjectID(objID);
        CheckParam.checkRectangle(rect);
        ObjectID oid = (ObjectID)objID;
        IdentObj id = new IdentObj(oid.getObjectID(), -3, this.getGroupID());
        SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, id, true);
        Rectangle rectVC = this.m_Perspective.getVC().destToVirt(rect);
        DrawFactory.createRectangle(this.m_Perspective.getDetectiv(), id, bb, rectVC.x, rectVC.y, rectVC.width, rectVC.height);
    }

    public void drawOval(Object objID, Rectangle rect, IStandardLook stdLook) throws IllegalArgumentException {
        CheckParam.checkObjectID(objID);
        CheckParam.checkRectangle(rect);
        ObjectID oid = (ObjectID)objID;
        Color fillColor = this.getFillColor(oid, stdLook);
        Color borderColor = this.getBorderColor(oid, stdLook);
        IdentObj id = new IdentObj(oid.getObjectID(), -3, this.getGroupID());
        BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, id);
        bb.setFillColor(fillColor);
        bb.setBorderColor(borderColor);
        Rectangle rectVC = this.m_Perspective.getVC().destToVirt(rect);
        DrawFactory.createOval(this.m_Perspective.getDetectiv(), id, rectVC.x, rectVC.y, rectVC.width, rectVC.height, bb);
    }

    public void drawLine(Object objID, int x1, int y1, int x2, int y2, IStandardLook stdLook) throws IllegalArgumentException {
        CheckParam.checkObjectID(objID);
        ObjectID oid = (ObjectID)objID;
        Color borderColor = this.getBorderColor(oid, stdLook);
        IdentObj id = new IdentObj(oid.getObjectID());
        SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, id, true);
        bb.setBorderColor(borderColor);
        Point pt1VC = this.m_Perspective.getVC().destToVirt(x1, y1);
        Point pt2VC = this.m_Perspective.getVC().destToVirt(x2, y2);
        Java2DLine line2D = new Java2DLine(this.m_Perspective);
        line2D.createLine(id, id, pt1VC.x, pt1VC.y, pt2VC.x, pt2VC.y, bb, null, this.m_Perspective.getLineWidth(id));
    }

    public void drawText(Object objID, String szText, Rectangle rect, IStandardLook stdLook) throws IllegalArgumentException {
        CheckParam.checkObjectID(objID);
        CheckParam.checkText(szText);
        CheckParam.checkRectangle(rect);
        ObjectID oid = (ObjectID)objID;
        IdentObj idLabel = new IdentObj(oid.getObjectID());
        SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, idLabel, true);
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, idLabel);
        Rectangle rectVC = this.m_Perspective.getVC().destToVirt(rect);
        DrawFactory.createLabel(this.m_Perspective.getDetectiv(), idLabel, szText, rectVC, textStyle, bb, null);
    }

    public Dimension getTextSize(Object objID, String szText, Dimension maxSizeDC) throws IllegalArgumentException {
        ObjectID oid = (ObjectID)objID;
        IdentObj id = new IdentObj(oid.getObjectID());
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, id);
        return textStyle.getTextSizeDC(szText, textStyle.getFontSizeDC(this.m_Perspective.getVC()), maxSizeDC, null, textStyle.getWordWrap());
    }

    public Dimension getTextSize(Object objID, String szText, IStandardLook stdLook) throws IllegalArgumentException {
        CheckParam.checkObjectID(objID);
        CheckParam.checkText(szText);
        Object fontNameAttr = stdLook.getAttr("FontName");
        String szFontName = (String)stdLook.getAttrValue(objID, fontNameAttr);
        Object fontStyleAttr = stdLook.getAttr("FontStyle");
        Integer fontStyle = (Integer)stdLook.getAttrValue(objID, fontStyleAttr);
        Float fontSize = (Float)stdLook.getFontSize(objID, this.m_rBounds.height);
        Font font = FontCache.getFont(szFontName, fontStyle, fontSize.floatValue());
        Rectangle2D stringRect = font.getStringBounds(szText, this.m_Perspective.getFontRenderContext());
        Rectangle rText = stringRect.getBounds();
        Dimension textDim = new Dimension(rText.width, rText.height);
        return textDim;
    }

    public String formatValue(Object objID, double dValue, IStandardLook stdLook) {
        return this.m_Perspective.getTextFormat(528).format(dValue);
    }

    public Rectangle getRectangle() {
        return this.m_rBounds;
    }

    public Rectangle getRectangleVC() {
        return this.m_rBoundsVC;
    }

    private Color getBorderColor(ObjectID objID, IStandardLook stdLook) {
        Color color = this.m_bDropShadowMode ? (Color)stdLook.getAttrValue(objID, stdLook.getAttr("ShadowColor")) : (Color)stdLook.getAttrValue(objID, stdLook.getAttr("BorderColor"));
        Double dAlpha = (Double)stdLook.getAttrValue(objID, stdLook.getAttr("FillAlpha"));
        if (dAlpha < 1.0) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(dAlpha * 255.0));
        }
        return color;
    }

    private Color getFillColor(ObjectID objID, IStandardLook stdLook) {
        Color color = this.m_bDropShadowMode ? (Color)stdLook.getAttrValue(objID, stdLook.getAttr("ShadowColor")) : (Color)stdLook.getAttrValue(objID, stdLook.getAttr("FillColor"));
        Double dAlpha = (Double)stdLook.getAttrValue(objID, stdLook.getAttr("FillAlpha"));
        if (dAlpha < 1.0) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(dAlpha * 255.0));
        }
        return color;
    }

    public void beginDropShadow(Rectangle rDropshadow) {
        this.m_bDropShadowMode = true;
    }

    public void endDropShadow() {
        this.m_bDropShadowMode = false;
    }

    public void setGroupID(int nGroupID) {
        this.m_nGroupID = nGroupID;
    }

    public int getGroupID() {
        return this.m_nGroupID;
    }

    public void addDetectableObject(ObjectID obj) {
        this.m_detObjSet.add(obj);
    }
}

