/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IDataProcessor;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.ITrendlineEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.ICurveFit;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.SVD;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SVDEngine
implements ITrendlineEngine {
    private boolean isValid = false;
    private List<Point2D> dataSet;
    private ICurveFit curveFit;
    private double[] a;
    private double correlation;
    private int smoothFactor = 100;

    public SVDEngine(ICurveFit curveFit) {
        this.curveFit = curveFit;
    }

    @Override
    public void processDataValues(List<Point2D> data) {
        this.dataSet = data;
        int validDataCount = 0;
        for (Point2D pt : data) {
            if (pt == null) continue;
            ++validDataCount;
        }
        if (validDataCount >= this.curveFit.numCoeffs()) {
            this.isValid = true;
        }
    }

    @Override
    public List<Point> generateCurve(int seriesId, IDataProcessor dataProcessor) {
        if (!this.isValid) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Point> result = new ArrayList<Point>();
        int nValidPoints = 0;
        int nTotalPoints = this.dataSet.size();
        int index = 1;
        double[] xValues = new double[this.dataSet.size() + 1];
        double[] yValues = new double[this.dataSet.size() + 1];
        for (Point2D pt : this.dataSet) {
            if (pt == null) continue;
            ++nValidPoints;
            xValues[index] = pt.getX();
            yValues[index] = pt.getY();
            ++index;
        }
        this.a = new double[this.curveFit.numCoeffs() + 1];
        double[] chisq = new double[1];
        if (!SVD.fit(this.curveFit, xValues, yValues, null, nValidPoints, this.a, chisq)) {
            this.isValid = false;
            return result;
        }
        this.correlation = SVDEngine.calcCorrelation(xValues, yValues, nValidPoints);
        assert (this.correlation >= -1.0);
        assert (this.correlation <= 1.0);
        int minCoord = dataProcessor.getXAxisMinCoord();
        int maxCoord = dataProcessor.getXAxisMaxCoord();
        int xLength = maxCoord - minCoord;
        boolean started = false;
        double step = 1.0 / (double)this.smoothFactor;
        for (double xRelative = 0.0; xRelative <= 1.0; xRelative += step) {
            int xCoord = (int)((double)minCoord + xRelative * (double)xLength);
            double xValue = dataProcessor.getXAxisValue(xCoord);
            double yValue = this.curveFit.compute(xValue, this.a);
            if (Double.isNaN(yValue)) continue;
            if (!dataProcessor.isYValueWithinAxis(seriesId, yValue)) {
                if (!started) continue;
                break;
            }
            started = true;
            int yCoord = dataProcessor.getYAxisCoord(seriesId, yValue);
            result.add(new Point(xCoord, yCoord));
        }
        return result;
    }

    private static double calcCorrelation(double[] x, double[] y, int N) {
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double sum_coproduct = 0.0;
        double mean_x = x[1];
        double mean_y = y[1];
        for (int i = 2; i <= N; ++i) {
            double sweep = ((double)i - 1.0) / (double)i;
            double delta_x = x[i] - mean_x;
            double delta_y = y[i] - mean_y;
            sum_sq_x += delta_x * delta_x * sweep;
            sum_sq_y += delta_y * delta_y * sweep;
            sum_coproduct += delta_x * delta_y * sweep;
            mean_x += delta_x / (double)i;
            mean_y += delta_y / (double)i;
        }
        if (sum_sq_x == 0.0 || sum_sq_y == 0.0) {
            return 0.0;
        }
        double pop_sd_x = Math.sqrt(sum_sq_x / (double)N);
        double pop_sd_y = Math.sqrt(sum_sq_y / (double)N);
        double cov_x_y = sum_coproduct / (double)N;
        return cov_x_y / (pop_sd_x * pop_sd_y);
    }

    @Override
    public String getEquationText(Format format) {
        if (!this.isValid) {
            return "";
        }
        int nCoeffs = this.curveFit.numCoeffs();
        String[] strCoeffs = new String[nCoeffs + 1];
        for (int i = 1; i <= nCoeffs; ++i) {
            strCoeffs[i] = format.format(this.a[i]);
        }
        return this.curveFit.createEquation(strCoeffs, true);
    }

    @Override
    public String getCorrelationText(Format format) {
        if (!this.isValid) {
            return "";
        }
        return "r = " + format.format(this.correlation);
    }

    @Override
    public void setSmoothingFactor(int smoothFactor) {
        assert (smoothFactor > 5);
        this.smoothFactor = smoothFactor;
    }
}

