/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.ICurveFit;

class FitLogarithmic
implements ICurveFit {
    private static final int NUM_COEFFS = 2;

    FitLogarithmic() {
    }

    public double compute(double x, double[] a) {
        assert (a.length >= 3);
        if (x <= 0.0) {
            return Double.NaN;
        }
        double y = a[1] + a[2] * Math.log(x);
        return y;
    }

    public void eval(double x, double[] a) {
        assert (a.length >= 3);
        assert (x > 0.0);
        a[1] = 1.0;
        a[2] = Math.log(x);
    }

    public int numCoeffs() {
        return 2;
    }

    public double transformY(double y) {
        return y;
    }

    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) {
        assert (strCoeffs.length >= 3);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + " * ln(x)";
        if (bHighOrderFirst) {
            return "y = " + strTerm2 + " + " + strTerm1;
        }
        return "y = " + strTerm1 + " + " + strTerm2;
    }
}

