/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;

class NonZeroBaseLine {
    private int m_nBaseCoord = 0;
    private int m_nZeroCoord = 0;
    private int m_nBaseLineYCoord = 0;
    private final boolean m_bAbsolute;
    private boolean m_bNonZeroBaseline = false;
    private final INumericAxis m_yAxisObj;
    private final boolean m_bFromZero;

    public NonZeroBaseLine(Perspective perspective, INumericAxis yAxisObj, boolean bAbsolute, boolean bFromZero) {
        this.m_yAxisObj = yAxisObj;
        this.m_bAbsolute = bAbsolute;
        this.m_bFromZero = bFromZero;
        double fBaseline = 0.0;
        this.m_nBaseCoord = (int)yAxisObj.getBaseCoord();
        this.m_nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
        IdentObj id = yAxisObj.getAxisIdentObj();
        this.m_bNonZeroBaseline = perspective.getNonZeroBaseline(id);
        if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
            fBaseline = perspective.getNonZeroBaselineValue(id);
            if ((yAxisObj.isLogScale() || yAxisObj.isDateScale()) && fBaseline <= 0.0) {
                this.m_bNonZeroBaseline = false;
            }
        }
        if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
            this.m_nBaseLineYCoord = fBaseline <= yAxisObj.getMaxValue() ? (int)yAxisObj.getValueCoord(fBaseline) : (int)yAxisObj.getValueCoord(yAxisObj.getBaseMax());
        }
    }

    public int getYBaseLine() {
        int nY = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_nBaseLineYCoord : (this.getWantRisersFromZero() ? this.m_nZeroCoord : this.m_nBaseCoord);
        return nY;
    }

    public boolean wantNonZeroBaseLine() {
        return this.m_bNonZeroBaseline;
    }

    protected boolean getWantRisersFromZero() {
        boolean bFromZero = this.m_bFromZero;
        if (!bFromZero) {
            boolean bl = bFromZero = this.m_yAxisObj.hasNegData() && !this.m_bAbsolute && !this.m_yAxisObj.isLogScale();
        }
        if (this.m_yAxisObj.isDateScale()) {
            bFromZero = false;
        }
        return bFromZero;
    }
}

