/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataIterator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.IDataStorage;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_Base;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.NatCubic;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MissingData {
    static final int MISSINGDATA_SKIP = 0;
    static final int MISSINGDATA_ZERO = 1;
    static final int MISSINGDATA_INTERPOLATE = 2;
    private Perspective m_Perspective;
    private Access m_Access;
    private JChart_Base m_Chart;
    private IDataStorage m_DataStorage;

    MissingData(JChart_Base chart, Perspective perspective, Access access, IDataStorage dataStorage) {
        this.m_Perspective = perspective;
        this.m_Access = access;
        this.m_Chart = chart;
        this.m_DataStorage = dataStorage;
    }

    void calcMissingData(DataIterator seriesIter, boolean bFirstTime) {
        int nFillMissingData = this.m_Perspective.getFillMissingData();
        switch (nFillMissingData) {
            case 0: {
                break;
            }
            case 1: {
                this.calcMissingDataZero(seriesIter, bFirstTime);
                break;
            }
            case 2: {
                this.calcMissingDataInterpolated(seriesIter, bFirstTime);
            }
        }
    }

    private void calcMissingDataZero(DataIterator seriesIter, boolean bFirstTime) {
        GroupsEnumerator groupIter = GroupsEnumerator.getIterator(this.m_Perspective, this.m_Access);
        seriesIter.reset();
        while (seriesIter.hasNext()) {
            int nSeries = seriesIter.next();
            groupIter.reset();
            while (groupIter.hasNext()) {
                int nGroup = groupIter.next();
                boolean bFillMissingDataIn = this.shouldFillInMissingData(bFirstTime, nSeries, nGroup);
                if (!bFillMissingDataIn) continue;
                this.m_Chart.setDataAsDouble(nSeries, nGroup, DataItem.DI_GENERAL, 0.0);
                this.m_DataStorage.setFillMissingData(nSeries, nGroup, true);
            }
        }
    }

    private void calcMissingDataInterpolated(DataIterator seriesIter, boolean bFirstTime) {
        Polygon polyValidData = null;
        seriesIter.reset();
        while (seriesIter.hasNext()) {
            int nSeries = seriesIter.next();
            List<Integer> vectMissingGroupIndices = this.getMissingDataGroupIndices(bFirstTime, nSeries, polyValidData = new Polygon());
            if (vectMissingGroupIndices.size() < 1) continue;
            Polygon polyInter = NatCubic.interpolate(polyValidData);
            this.setMissingDataForSeries(nSeries, vectMissingGroupIndices, polyInter);
        }
    }

    List<Integer> getMissingDataGroupIndices(boolean bFirstTime, int nSeries, Polygon polyValidData) {
        ArrayList<Integer> vectMissingGroupIndices = new ArrayList<Integer>();
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.m_Access);
        gEnum.reset();
        while (gEnum.hasNext()) {
            int nGroup = gEnum.next();
            boolean bFillMissingDataIn = this.shouldFillInMissingData(bFirstTime, nSeries, nGroup);
            if (bFillMissingDataIn) {
                Integer intGrp = new Integer(nGroup);
                vectMissingGroupIndices.add(intGrp);
                continue;
            }
            DatumObj dObj = this.m_Chart.getDataValue(nSeries, nGroup, DataItem.DI_GENERAL);
            double fValue = dObj.value;
            polyValidData.addPoint(nGroup, (int)fValue);
        }
        return vectMissingGroupIndices;
    }

    private boolean shouldFillInMissingData(boolean bFirstTime, int nSeries, int nGroup) {
        boolean bFillMissingData = false;
        DatumObj dObj = this.m_Chart.getDataValue(nSeries, nGroup, DataItem.DI_GENERAL);
        if (bFirstTime) {
            if (!dObj.m_bOK) {
                bFillMissingData = true;
            }
        } else {
            boolean bPrevFilledInMissingData = this.m_DataStorage.isMissingDataFilledIn(nSeries, nGroup);
            if (bPrevFilledInMissingData) {
                bFillMissingData = true;
            }
        }
        return bFillMissingData;
    }

    private void setMissingDataForSeries(int nSeries, List<Integer> vectMissingGroupIndices, Polygon polyInter) {
        for (int nIdx = 0; nIdx < vectMissingGroupIndices.size(); ++nIdx) {
            Integer intGroup = vectMissingGroupIndices.get(nIdx);
            int nGroup = intGroup;
            double fAverageValue = this.getAverageInterpolatedValue(nGroup, polyInter);
            this.m_Chart.setDataAsDouble(nSeries, nGroup, DataItem.DI_GENERAL, fAverageValue);
            this.m_DataStorage.setFillMissingData(nSeries, nGroup, true);
        }
    }

    private double getAverageInterpolatedValue(int nGroup, Polygon polyInter) {
        int nSum = 0;
        int nNumInterpolatedValues = 0;
        double fAverageValue = 0.0;
        for (int nPt = 0; nPt < polyInter.npoints - 1; ++nPt) {
            if (nGroup != polyInter.xpoints[nPt]) continue;
            nSum += polyInter.ypoints[nPt];
            ++nNumInterpolatedValues;
        }
        if (nNumInterpolatedValues != 0) {
            fAverageValue = nSum / nNumInterpolatedValues;
        }
        return fAverageValue;
    }
}

